/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.tomcat.dev.DevFrameworkBootstrap;
import org.nuxeo.runtime.tomcat.dev.NuxeoDevWebappClassLoader;

public class DevValve
extends ValveBase {
    Log log = LogFactory.getLog(DevValve.class);

    public void invoke(Request req, Response resp) throws IOException, ServletException {
        String path = req.getServletPath();
        if (path != null && path.startsWith("/sdk/")) {
            if ("reload".equals(path = path.substring("/sdk/".length()))) {
                if ("GET".equals(req.getMethod())) {
                    this.getReload(req, resp);
                } else if ("POST".equals(req.getMethod())) {
                    this.postReload(req, resp);
                }
                return;
            }
            if (path.startsWith("files/")) {
                path = path.substring("files/".length());
                this.getFile(path, req, resp);
                return;
            }
            resp.setStatus(404);
            return;
        }
        this.getNext().invoke(req, resp);
    }

    private final File getHome() {
        return new File(System.getProperty("catalina.base"));
    }

    private final File getSDKFile(String path) {
        return new File(new File(this.getHome(), "sdk"), path);
    }

    private void getFile(String path, Request req, Response resp) {
        File file = this.getSDKFile(path);
        if (file == null) {
            resp.setStatus(404);
        } else {
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(200);
            try {
                PrintWriter out = resp.getWriter();
                this.sendFile(file, out);
                ((Writer)out).flush();
            }
            catch (IOException e) {
                resp.setStatus(500);
                this.log.error((Object)("Failed to send file: " + file), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(File file, Writer out) throws IOException {
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            char[] cbuf = new char[65536];
            int r = -1;
            while ((r = in.read(cbuf)) != -1) {
                if (r <= 0) continue;
                out.write(cbuf, 0, r);
            }
        }
    }

    private void getReload(Request req, Response resp) {
        ClassLoader webLoader = req.getContext().getLoader().getClassLoader();
        if (webLoader instanceof NuxeoDevWebappClassLoader) {
            NuxeoDevWebappClassLoader loader = (NuxeoDevWebappClassLoader)((Object)webLoader);
            loader.getBootstrap().loadDevBundles();
        }
        resp.setStatus(200);
    }

    private void postReload(Request req, Response resp) throws IOException {
        ClassLoader webLoader = req.getContext().getLoader().getClassLoader();
        if (webLoader instanceof NuxeoDevWebappClassLoader) {
            NuxeoDevWebappClassLoader loader = (NuxeoDevWebappClassLoader)((Object)webLoader);
            DevFrameworkBootstrap bootstrap = loader.getBootstrap();
            String devBundlesLocation = bootstrap.getDevBundlesLocation();
            try {
                Files.copy(req.getStream(), Paths.get(devBundlesLocation, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to write to dev.bundles", (Throwable)e);
                resp.sendError(500, "Unable to write to dev.bundles");
            }
            bootstrap.loadDevBundles();
        }
        resp.setStatus(200);
    }
}

