/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.liveedit.restclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.nuxeo.ecm.http.client.NuxeoServer;
import org.nuxeo.liveedit.ActionItem;
import org.nuxeo.liveedit.CookieItem;
import org.nuxeo.liveedit.DocumentFileItem;
import org.nuxeo.liveedit.ILiveEditClient;
import org.restlet.data.Cookie;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveEditClientRestletImpl
implements ILiveEditClient {
    Logger log = Logger.getLogger(LiveEditClientRestletImpl.class);
    public static final String SC_LOCKED_OK = "OK";
    public static final String SC_ALREADY_LOCKED_OK = "ALREADYLOCKEDBYYOU";
    private static final String ACTION_NO_INCREMENT = "ACTION_NO_INCREMENT";
    private static final String KEY_FOR_INC_OPTION = "VersioningOption";

    @Override
    public ActionItem loadFileItemXml(String docXmlFilePath) {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(new File(docXmlFilePath));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        ActionItem actionItem = new ActionItem();
        Node node = document.selectSingleNode("//liveEdit/actionSelector");
        actionItem.setActionSelector(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/editId");
        actionItem.setEditId(node == null ? null : node.getText());
        DocumentFileItem documentItem = new DocumentFileItem();
        node = document.selectSingleNode("//liveEdit/document/docRef");
        documentItem.setDocRef(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/docPath");
        documentItem.setDocPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/docTitle");
        documentItem.setDocTitle(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/repository");
        documentItem.setRepository(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/fieldPath");
        documentItem.setFieldPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/fieldName");
        documentItem.setFieldName(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/fileName");
        documentItem.setFileName(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/schemaName");
        documentItem.setSchemaName(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/type");
        documentItem.setType(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/mimetype");
        documentItem.setMimetype(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/fileExtension");
        documentItem.setFileExtension(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/blobFieldPath");
        documentItem.setBlobFieldPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/filenameFieldPath");
        documentItem.setFilenameFieldPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/blobFieldName");
        documentItem.setBlobFieldName(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/filenameFieldName");
        documentItem.setFilenameFieldName(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/document/isLocked");
        documentItem.setLocked(node == null ? null : Boolean.valueOf(node.getText()));
        node = document.selectSingleNode("//liveEdit/document/isVersion");
        documentItem.setVersion(node == null ? null : Boolean.valueOf(node.getText()));
        actionItem.setDocument(documentItem);
        DocumentFileItem templateItem = new DocumentFileItem();
        node = document.selectSingleNode("//liveEdit/template/docRef");
        templateItem.setDocRef(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/docPath");
        templateItem.setDocPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/docTitle");
        templateItem.setDocTitle(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/repository");
        templateItem.setRepository(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/fieldPath");
        templateItem.setFieldPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/fieldName");
        templateItem.setFieldName(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/fileName");
        templateItem.setFileName(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/schemaName");
        templateItem.setSchemaName(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/type");
        templateItem.setType(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/mimetype");
        templateItem.setMimetype(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/fileExtension");
        templateItem.setFileExtension(node == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/template/isLocked");
        templateItem.setLocked(node == null ? null : Boolean.valueOf(node.getText()));
        node = document.selectSingleNode("//liveEdit/template/isVersion");
        templateItem.setVersion(node == null ? null : Boolean.valueOf(node.getText()));
        actionItem.setTemplate(templateItem);
        List nodes = document.selectNodes("//liveEdit/requestInfo/cookies/cookie");
        if (nodes != null) {
            for (Object nodeitem : nodes) {
                if (!(nodeitem instanceof Node)) continue;
                node = (Node)nodeitem;
                List<CookieItem> cookies = actionItem.getCookies();
                if (cookies == null) {
                    cookies = new ArrayList<CookieItem>();
                    actionItem.setCookies(cookies);
                }
                CookieItem ckItem = new CookieItem();
                ckItem.setName(node.valueOf("@name"));
                ckItem.setValue(node.getText());
                cookies.add(ckItem);
            }
        }
        actionItem.setBaseURL((node = document.selectSingleNode("//liveEdit/requestInfo/baseURL")) == null ? null : node.getText());
        if (actionItem.getBaseURL() != null && actionItem.getBaseURL().endsWith("/")) {
            actionItem.setBaseURL(actionItem.getBaseURL().substring(0, actionItem.getBaseURL().length() - 1));
        }
        actionItem.setUserName((node = document.selectSingleNode("//liveEdit/userInfo/userName")) == null ? null : node.getText());
        node = document.selectSingleNode("//liveEdit/userInfo/userPassword");
        actionItem.setUserPassword(node == null ? null : node.getText());
        return actionItem;
    }

    @Override
    public void save(String docpath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(String docpath, DocumentFileItem targetDocFileItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void uploadDocumentFile(String docpath, ActionItem actionitem, DocumentFileItem targetDocFileItem, String versioning) {
        String url = actionitem.getBaseURL();
        NuxeoServer nxServer = new NuxeoServer(url);
        nxServer.setCookies(this.getCookies(actionitem));
        String fileName = null;
        try {
            fileName = URLEncoder.encode(targetDocFileItem.getFileName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        List<String> pathParams = Arrays.asList(targetDocFileItem.getRepository(), targetDocFileItem.getDocRef(), fileName, "uploadFile");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (targetDocFileItem.getBlobFieldName() != null && targetDocFileItem.getFilenameFieldName() != null) {
            queryParams = new HashMap();
            queryParams.put("blobPropertyName", targetDocFileItem.getBlobFieldName());
            queryParams.put("filenamePropertyName", targetDocFileItem.getFilenameFieldName());
        }
        queryParams.put(KEY_FOR_INC_OPTION, versioning);
        try {
            File file = new File(docpath);
            FileInputStream istream = new FileInputStream(file);
            nxServer.doRestletPostCall(pathParams, queryParams, (InputStream)istream, Long.valueOf(file.length()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void uploadDocumentFile(String docpath, ActionItem actionitem, DocumentFileItem targetDocFileItem) {
        this.uploadDocumentFile(docpath, actionitem, targetDocFileItem, ACTION_NO_INCREMENT);
    }

    @Override
    public InputStream downloadDocumentFile(ActionItem actionitem, DocumentFileItem docitem) {
        String url = actionitem.getBaseURL();
        NuxeoServer nxServer = new NuxeoServer(url);
        nxServer.setCookies(this.getCookies(actionitem));
        List<String> pathParams = Arrays.asList(docitem.getRepository(), docitem.getDocRef(), "downloadFile");
        Representation res = null;
        res = nxServer.doRestletGetCall(pathParams, null);
        if (res != null) {
            try {
                return res.getStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String downloadDocumentFileToFile(ActionItem actionitem, DocumentFileItem docitem) throws Exception {
        int numRead;
        InputStream in = this.downloadDocumentFile(actionitem, docitem);
        File documentFile = File.createTempFile(actionitem.getEditId(), actionitem.getDocument().getType());
        FileOutputStream out = new FileOutputStream(documentFile);
        byte[] buffer = new byte[1024];
        long numWritten = 0L;
        while ((numRead = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, numRead);
            numWritten += (long)numRead;
        }
        ((OutputStream)out).close();
        in.close();
        return documentFile.getAbsolutePath();
    }

    @Override
    public DocumentFileItem[] getLocations(ActionItem actionitem) {
        String url = actionitem.getBaseURL();
        NuxeoServer nxServer = new NuxeoServer(url);
        nxServer.setCookies(this.getCookies(actionitem));
        List<String> pathParams = Arrays.asList("creationContainerList");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("docType", actionitem.getDocument().getType());
        Representation res = null;
        res = nxServer.doRestletGetCall(pathParams, queryParams);
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(res.getStream());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List nodes = document.selectNodes("//containers/document");
        if (nodes != null) {
            ArrayList<DocumentFileItem> docfileitems = new ArrayList<DocumentFileItem>();
            for (Object nodeitem : nodes) {
                if (!(nodeitem instanceof Node)) continue;
                DocumentFileItem documentItem = new DocumentFileItem();
                Node docnode = (Node)nodeitem;
                Node node = docnode.selectSingleNode("repository");
                documentItem.setRepository(node == null ? null : node.getText());
                node = docnode.selectSingleNode("docRef");
                documentItem.setDocRef(node == null ? null : node.getText());
                node = docnode.selectSingleNode("docTitle");
                documentItem.setDocTitle(node == null ? null : node.getText());
                node = docnode.selectSingleNode("docPath");
                documentItem.setDocPath(node == null ? null : node.getText());
                node = document.selectSingleNode("blobFieldPath");
                documentItem.setBlobFieldPath(node == null ? null : node.getText());
                node = document.selectSingleNode("filenameFieldPath");
                documentItem.setFilenameFieldPath(node == null ? null : node.getText());
                node = document.selectSingleNode("blobFieldName");
                documentItem.setBlobFieldName(node == null ? null : node.getText());
                node = document.selectSingleNode("filenameFieldName");
                documentItem.setFilenameFieldName(node == null ? null : node.getText());
                docfileitems.add(documentItem);
            }
            return docfileitems.toArray(new DocumentFileItem[docfileitems.size()]);
        }
        return null;
    }

    @Override
    public DocumentFileItem createDocument(ActionItem actionitem, DocumentFileItem parent, String title, String fileName) {
        return this.createDocument(actionitem, parent, title, "", fileName);
    }

    @Override
    public DocumentFileItem createDocument(ActionItem actionitem, DocumentFileItem parent, String title, String description, String fileName) {
        String url = actionitem.getBaseURL();
        NuxeoServer nxServer = new NuxeoServer(url);
        nxServer.setCookies(this.getCookies(actionitem));
        List<String> pathParams = Arrays.asList(parent.getRepository(), parent.getDocRef(), "createDocument");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        try {
            queryParams.put("docType", URLEncoder.encode(actionitem.getDocument().getType(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            queryParams.put("dublincore:title", URLEncoder.encode(title, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            queryParams.put("dublincore:description", URLEncoder.encode(description, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            queryParams.put("file:filename", URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Representation res = null;
        res = nxServer.doRestletGetCall(pathParams, queryParams);
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read((Reader)new InputStreamReader(res.getStream(), "UTF-8"));
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DocumentFileItem documentItem = new DocumentFileItem();
        Node node = document.selectSingleNode("//document/repository");
        documentItem.setRepository(node == null ? null : node.getText());
        node = document.selectSingleNode("//document/docRef");
        documentItem.setDocRef(node == null ? null : node.getText());
        node = document.selectSingleNode("//document/docTitle");
        documentItem.setDocTitle(node == null ? null : node.getText());
        node = document.selectSingleNode("//document/docPath");
        documentItem.setDocPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//document/blobFieldPath");
        documentItem.setBlobFieldPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//document/filenameFieldPath");
        documentItem.setFilenameFieldPath(node == null ? null : node.getText());
        node = document.selectSingleNode("//document/blobFieldName");
        documentItem.setBlobFieldName(node == null ? null : node.getText());
        node = document.selectSingleNode("//document/filenameFieldName");
        documentItem.setFilenameFieldName(node == null ? null : node.getText());
        documentItem.setFileName(fileName);
        return documentItem;
    }

    @Override
    public void close(String docpath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFileExtention(String docpath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getXmlFilePath(String docpath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocked(String docpath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DocumentFileItem[] loadDocumentsXml(String docsXmlString) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean lockDocument(ActionItem actionItem, DocumentFileItem doc) {
        String url = actionItem.getBaseURL();
        this.log.debug((Object)("Lock in progress : " + url));
        NuxeoServer nxServer = new NuxeoServer(url);
        nxServer.setCookies(this.getCookies(actionItem));
        this.log.debug((Object)("Set cookie" + this.getCookies(actionItem)));
        List<String> pathParams = Arrays.asList(doc.getRepository(), doc.getDocRef(), "Locking", "lock");
        this.log.debug((Object)("Rest call : " + pathParams));
        Representation res = nxServer.doRestletGetCall(pathParams, null);
        Document document = this.getParsedDocument(res);
        if (document == null) {
            return false;
        }
        Node node = document.selectSingleNode("//document[@code]");
        String code = node != null ? node.valueOf("@code") : null;
        this.log.debug((Object)("Code received : " + code));
        return this.lockedOK(code);
    }

    @Override
    public boolean unlockDocument(ActionItem actionItem, DocumentFileItem doc) {
        String url = actionItem.getBaseURL();
        NuxeoServer nxServer = new NuxeoServer(url);
        nxServer.setCookies(this.getCookies(actionItem));
        List<String> pathParams = Arrays.asList(doc.getRepository(), doc.getDocRef(), "Locking", "unlock");
        Representation res = nxServer.doRestletGetCall(pathParams, null);
        return true;
    }

    @Override
    public DocumentFileItem parseDocXML(String docXmlStr) {
        throw new UnsupportedOperationException();
    }

    private List<Cookie> getCookies(ActionItem actionItem) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        if (actionItem.getCookies() != null) {
            for (CookieItem cookie : actionItem.getCookies()) {
                cookies.add(new Cookie(cookie.getName(), cookie.getValue()));
            }
        }
        return cookies;
    }

    private Document getParsedDocument(Representation rep) {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(rep.getStream());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }

    private boolean lockedOK(String code) {
        if (code == null) {
            return false;
        }
        return code.equals(SC_LOCKED_OK) || code.equals(SC_ALREADY_LOCKED_OK);
    }
}

