/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.datasource;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.RepositoryResolver;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionFactoryImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionFactoryImpl;
import org.nuxeo.ecm.platform.reporting.datasource.NuxeoDSConfig;
import org.nuxeo.runtime.api.Framework;

public class DSHelper {
    protected static Map<String, NuxeoDSConfig> detectedDS;

    public static Map<String, NuxeoDSConfig> getDSForRepos() throws Exception {
        if (detectedDS == null) {
            HashMap<String, NuxeoDSConfig> configs = new HashMap<String, NuxeoDSConfig>();
            RepositoryManager rm = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            for (org.nuxeo.ecm.core.api.repository.Repository repo : rm.getRepositories()) {
                String singleDS;
                RepositoryDescriptor desc;
                Repository repoImpl = RepositoryResolver.getRepository((String)repo.getName());
                if (repoImpl instanceof RepositoryImpl) {
                    RepositoryImpl sqlRepo = (RepositoryImpl)repoImpl;
                    desc = sqlRepo.getRepositoryDescriptor();
                } else {
                    ConnectionFactoryImpl cf = (ConnectionFactoryImpl)RepositoryResolver.getRepository((String)repo.getName());
                    ManagedConnectionFactoryImpl mcf = cf.getManagedConnectionFactory();
                    Field field = mcf.getClass().getDeclaredField("repository");
                    field.setAccessible(true);
                    RepositoryImpl sqlRepositoryImpl = (RepositoryImpl)field.get(mcf);
                    desc = sqlRepositoryImpl.getRepositoryDescriptor();
                }
                if ((singleDS = Framework.getProperty((String)"nuxeo.db.singleDataSource", null)) != null && !singleDS.isEmpty()) continue;
                NuxeoDSConfig config = new NuxeoDSConfig(desc.xaDataSourceName, desc.properties);
                configs.put(repo.getName(), config);
            }
            detectedDS = configs;
        }
        return detectedDS;
    }

    public static NuxeoDSConfig getDefaultRepoDS(String repositoryName) throws Exception {
        Map<String, NuxeoDSConfig> configs = DSHelper.getDSForRepos();
        if (configs.size() == 0) {
            return null;
        }
        if (configs.size() == 1) {
            return configs.get(configs.keySet().iterator().next());
        }
        if (repositoryName == null) {
            repositoryName = "default";
        }
        return configs.get(repositoryName);
    }

    public static NuxeoDSConfig getReplacementDS(String birtDSName, String repositoryName) throws Exception {
        String name = birtDSName.toLowerCase();
        if (name.equals("nuxeo") || name.equals("nuxeovcs")) {
            return DSHelper.getDefaultRepoDS(repositoryName);
        }
        if (name.startsWith("nuxeo-")) {
            name = name.replace("nuxeo-", "");
        }
        Map<String, NuxeoDSConfig> configs = DSHelper.getDSForRepos();
        return configs.get(name);
    }
}

