/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.listener;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.reporting.api.ReportInstance;

public class ReportKeyListener
implements EventListener {
    protected static final Log log = LogFactory.getLog(ReportKeyListener.class);

    public void handleEvent(Event event) throws ClientException {
        ReportInstance reportInstance;
        DocumentEventContext docCtx;
        DocumentModel doc;
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext && (doc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()).hasSchema("birtreport") && (reportInstance = (ReportInstance)doc.getAdapter(ReportInstance.class)) != null) {
            try {
                String key;
                String title = doc.getTitle();
                if (title == null || title.isEmpty()) {
                    title = reportInstance.getModel().getDoc().getTitle();
                    doc.setPropertyValue("dc:title", (Serializable)((Object)title));
                }
                if ((key = reportInstance.getReportKey()) == null || key.isEmpty()) {
                    reportInstance.setReportKey(this.generateReportKey(reportInstance));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while parsing report parameters", (Throwable)e);
            }
        }
    }

    protected String generateReportKey(ReportInstance reportInstance) throws ClientException {
        String name = reportInstance.getModel().getReportName();
        if (name == null) {
            name = reportInstance.getModel().getDoc().getName();
        }
        StringBuffer key = new StringBuffer();
        key.append(IdUtils.generateId((String)name, (String)"_", (boolean)true, (int)20));
        key.append("-");
        Random rnd = new Random(System.currentTimeMillis());
        key.append(rnd.nextInt(1000));
        return key.toString();
    }
}

