/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.report;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.reporting.report.ReportParameter;

public class ReportContext {
    public static final String DOMAIN_DOCUMENT_TYPE = "Domain";
    public static final String WORKSPACE_DOCUMENT_TYPE = "Workspace";
    public static final String USER_NAME = "userName";
    public static final String DOC_TYPE = "docType";
    public static final String CURRENT_PATH = "currentPath";
    public static final String CURRENT_REPOSITORY = "currentRepository";
    public static final String CURRENT_SUPERSPACE_PATH = "currentSuperSpacePath";
    public static final String CURRENT_SUPERSPACE_ID = "currentSuperSpaceId";
    public static final String CURRENT_WORKSPACE_PATH = "currentWorkspacePath";
    public static final String CURRENT_WORKSPACE_ID = "currentWorkspaceId";
    public static final String CURRENT_DOMAIN_PATH = "currentDomainPath";
    public static final String CURRENT_DOMAIN_ID = "currentDomainId";
    public static final Pattern PATTERN_TO_CHECK = Pattern.compile("\\$\\{(\\w+)\\}");

    public static void setContextualParameters(List<ReportParameter> reportParams, DocumentModel doc) throws Exception {
        Map<String, String> contextualParameters = ReportContext.buildContextualParametersMap(doc);
        for (ReportParameter parameter : reportParams) {
            String parameterName;
            Matcher matcher;
            String value = parameter.getStringValue();
            if (value == null || !(matcher = PATTERN_TO_CHECK.matcher(value)).matches() || !contextualParameters.containsKey(parameterName = matcher.group(1))) continue;
            parameter.setValue(contextualParameters.get(parameterName));
        }
    }

    private static Map<String, String> buildContextualParametersMap(DocumentModel doc) throws ClientException {
        DocumentModel currentSuperSpace;
        DocumentModel currentWorkspace;
        HashMap<String, String> contextualParameters = new HashMap<String, String>();
        contextualParameters.put(USER_NAME, doc.getCoreSession().getPrincipal().getName());
        contextualParameters.put(DOC_TYPE, doc.getType());
        contextualParameters.put(CURRENT_PATH, doc.getPathAsString());
        contextualParameters.put(CURRENT_REPOSITORY, doc.getRepositoryName());
        DocumentModel currentDomain = ReportContext.getFirstParentWithType(doc, DOMAIN_DOCUMENT_TYPE);
        if (currentDomain != null) {
            contextualParameters.put(CURRENT_DOMAIN_ID, currentDomain.getId());
            contextualParameters.put(CURRENT_DOMAIN_PATH, currentDomain.getPathAsString());
        }
        if ((currentWorkspace = ReportContext.getFirstParentWithType(doc, WORKSPACE_DOCUMENT_TYPE)) != null) {
            contextualParameters.put(CURRENT_WORKSPACE_ID, currentWorkspace.getId());
            contextualParameters.put(CURRENT_WORKSPACE_PATH, currentWorkspace.getPathAsString());
        }
        if ((currentSuperSpace = ReportContext.getCurrentSuperSpace(doc)) != null) {
            contextualParameters.put(CURRENT_SUPERSPACE_ID, currentSuperSpace.getId());
            contextualParameters.put(CURRENT_SUPERSPACE_PATH, currentSuperSpace.getPathAsString());
        }
        return contextualParameters;
    }

    private static DocumentModel getFirstParentWithType(DocumentModel doc, String type) throws ClientException {
        List parents = doc.getCoreSession().getParentDocuments(doc.getRef());
        for (DocumentModel parent : parents) {
            if (!parent.getType().equals(type)) continue;
            return parent;
        }
        return null;
    }

    private static DocumentModel getCurrentSuperSpace(DocumentModel doc) throws ClientException {
        return doc.getCoreSession().getSuperSpace(doc);
    }
}

