/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.report;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefn;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.platform.reporting.datasource.DSHelper;
import org.nuxeo.ecm.platform.reporting.datasource.NuxeoDSConfig;
import org.nuxeo.ecm.platform.reporting.engine.BirtEngine;
import org.nuxeo.runtime.api.DataSourceHelper;
import org.nuxeo.runtime.api.Framework;

public class ReportHelper {
    protected static final Log log = LogFactory.getLog(ReportHelper.class);

    public static IReportRunnable getReport(String reportPath) throws EngineException {
        return BirtEngine.getBirtEngine().openReportDesign(reportPath);
    }

    public static IReportRunnable getReport(InputStream stream) throws EngineException {
        return BirtEngine.getBirtEngine().openReportDesign(stream);
    }

    public static IReportRunnable getNuxeoReport(InputStream stream) throws Exception {
        return ReportHelper.getNuxeoReport(stream, null);
    }

    public static Map<String, String> getReportMetaData(InputStream stream) throws Exception {
        IDesignEngine dEngine = BirtEngine.getBirtDesignEngine();
        SessionHandle sh = dEngine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = sh.openDesign((String)null, stream);
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("title", designHandle.getTitle());
        meta.put("author", designHandle.getAuthor());
        meta.put("description", designHandle.getDescription());
        meta.put("displayName", designHandle.getDisplayName());
        sh.closeAll(false);
        return meta;
    }

    public static IReportRunnable getNuxeoReport(InputStream stream, String repositoryName) throws Exception {
        IDesignEngine dEngine = BirtEngine.getBirtDesignEngine();
        SessionHandle sh = dEngine.newSessionHandle(ULocale.ENGLISH);
        ReportDesignHandle designHandle = sh.openDesign((String)null, stream);
        for (OdaDataSourceHandle dsh : designHandle.getDataSources()) {
            String singleDS = Framework.getProperty((String)"nuxeo.db.singleDataSource", null);
            if (singleDS != null && !singleDS.isEmpty()) {
                OdaDataSource ds = (OdaDataSource)dsh.getElement();
                String dsName = DataSourceHelper.getDataSourceJNDIName((String)singleDS);
                ds.setProperty("odaJndiName", (Object)DataSourceHelper.getDataSourceJNDIName((String)dsName));
                continue;
            }
            NuxeoDSConfig newConfig = DSHelper.getReplacementDS(dsh.getName(), repositoryName);
            if (newConfig == null) continue;
            OdaDataSource ds = (OdaDataSource)dsh.getElement();
            log.debug((Object)("Editing ODA datasource " + ds.getName()));
            List propNames = ds.getPropertyDefns();
            for (IElementPropertyDefn propName : propNames) {
                ElementPropertyDefn prop = ds.getPropertyDefn(propName.getName());
                if (propName.getName().equals("odaDriverClass")) {
                    log.debug((Object)(" ->changing odaDriverClass to " + newConfig.getDriverClass()));
                    ds.setProperty(prop, (Object)newConfig.getDriverClass());
                    continue;
                }
                if (propName.getName().equals("odaURL")) {
                    log.debug((Object)(" ->changing odaURL to " + newConfig.getUrl()));
                    ds.setProperty(prop, (Object)newConfig.getUrl());
                    continue;
                }
                if (propName.getName().equals("odaUser")) {
                    log.debug((Object)(" ->changing odaUser to " + newConfig.getUserName()));
                    ds.setProperty(prop, (Object)newConfig.getUserName());
                    continue;
                }
                if (!propName.getName().equals("odaPassword")) continue;
                if (prop.isEncryptable()) {
                    String b64pwd = Base64.encodeBytes((byte[])newConfig.getPassword().getBytes());
                    ds.setProperty(prop, (Object)b64pwd);
                    continue;
                }
                ds.setProperty(prop, (Object)newConfig.getPassword());
            }
        }
        IReportRunnable modifiedReport = BirtEngine.getBirtEngine().openReportDesign(designHandle);
        sh.closeAll(false);
        return modifiedReport;
    }

    public static List<IParameterDefn> getReportParameter(IReportRunnable report) throws EngineException {
        ArrayList<IParameterDefn> params = new ArrayList<IParameterDefn>();
        IGetParameterDefinitionTask task = BirtEngine.getBirtEngine().createGetParameterDefinitionTask(report);
        for (Object paramDefn : task.getParameterDefns(false)) {
            if (!(paramDefn instanceof IParameterDefn)) continue;
            IParameterDefn param = (IParameterDefn)paramDefn;
            params.add(param);
        }
        return params;
    }
}

