/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.report;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.report.engine.api.IParameterDefn;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;

public class ReportParameter {
    private static final Log log = LogFactory.getLog(ReportParameter.class);
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "hh:mm:ss";
    protected int type;
    protected String stringValue;
    protected String name;
    protected String displayName;
    protected String help;
    protected boolean required;
    protected boolean editable = true;
    protected boolean error;

    public ReportParameter(IParameterDefn paramDef) {
        this(paramDef, null);
    }

    public ReportParameter(IParameterDefn paramDef, String value) {
        this.type = paramDef.getDataType();
        this.name = paramDef.getName();
        this.displayName = paramDef.getDisplayName();
        this.help = paramDef.getHelpText();
        this.required = paramDef.isRequired();
        if (value != null && value.isEmpty()) {
            this.stringValue = value;
        } else if (paramDef instanceof ScalarParameterDefn) {
            ScalarParameterDefn scalarParam = (ScalarParameterDefn)paramDef;
            this.stringValue = scalarParam.getDefaultValue();
        }
    }

    public void setValue(String value) {
        this.stringValue = value;
    }

    public boolean setAndValidateValue(String value) {
        if (value == null) {
            return false;
        }
        try {
            if (this.type == 7) {
                new SimpleDateFormat(DATE_FORMAT).parse(value);
            } else if (this.type == 4) {
                new SimpleDateFormat(DATETIME_FORMAT).parse(value);
            } else if (this.type == 8) {
                new SimpleDateFormat(TIME_FORMAT).parse(value);
            } else if (this.type == 6) {
                Integer.parseInt(value);
            } else if (this.type == 2) {
                Float.parseFloat(value);
            } else if (this.type == 5) {
                Boolean.parseBoolean(value);
            } else if (value.trim().isEmpty()) {
                return false;
            }
            this.stringValue = value;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getTypeName() {
        if (this.type == 7) {
            return "Date";
        }
        if (this.type == 4) {
            return "DateTime";
        }
        if (this.type == 8) {
            return "Time";
        }
        if (this.type == 6) {
            return "Integer";
        }
        if (this.type == 2) {
            return "Float";
        }
        if (this.type == 5) {
            return "Boolean";
        }
        return "String";
    }

    public String getTypeFormat() {
        if (this.type == 7) {
            return DATE_FORMAT;
        }
        if (this.type == 4) {
            return DATETIME_FORMAT;
        }
        if (this.type == 8) {
            return TIME_FORMAT;
        }
        return null;
    }

    public void setValue(Calendar value) {
        this.setValue(value.getTime());
    }

    public void setValue(Date value) {
        if (this.type == 7) {
            this.stringValue = new SimpleDateFormat(DATE_FORMAT).format(value);
        } else if (this.type == 4) {
            this.stringValue = new SimpleDateFormat(DATETIME_FORMAT).format(value);
        } else if (this.type == 8) {
            this.stringValue = new SimpleDateFormat(TIME_FORMAT).format(value);
        }
    }

    public void setValue(Integer value) {
        if (this.type == 6) {
            this.stringValue = value.toString();
        }
    }

    public void setValue(Float value) {
        if (this.type == 2) {
            this.stringValue = value.toString();
        }
    }

    public void setValue(Boolean value) {
        if (this.type == 5) {
            this.stringValue = value.toString();
        }
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Date getDateTimeValue() {
        try {
            if (this.type == 7) {
                return new SimpleDateFormat(DATE_FORMAT).parse(this.stringValue);
            }
            if (this.type == 4) {
                return new SimpleDateFormat(DATETIME_FORMAT).parse(this.stringValue);
            }
            if (this.type == 8) {
                return new SimpleDateFormat(TIME_FORMAT).parse(this.stringValue);
            }
        }
        catch (Exception e) {
            String message = String.format("Error while parsing the '%s' date value", this.stringValue);
            log.error((Object)message, (Throwable)e);
        }
        return null;
    }

    public Boolean getBooleanValue() {
        return Boolean.parseBoolean(this.stringValue);
    }

    public Integer getIntegerValue() {
        return Integer.parseInt(this.stringValue);
    }

    public Float getFloatValue() {
        return Float.valueOf(Float.parseFloat(this.stringValue));
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.displayName == null || this.displayName.isEmpty()) {
            return this.name;
        }
        return this.displayName;
    }

    public String getHelp() {
        return this.help;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Object getObjectValue() {
        if (this.type == 7) {
            return this.getDateTimeValue();
        }
        if (this.type == 4) {
            return this.getDateTimeValue();
        }
        if (this.type == 8) {
            return this.getDateTimeValue();
        }
        if (this.type == 5) {
            return this.getBooleanValue();
        }
        if (this.type == 6) {
            return this.getIntegerValue();
        }
        if (this.type == 2) {
            return this.getFloatValue();
        }
        if (this.type == 3) {
            return this.getFloatValue();
        }
        return this.stringValue;
    }

    public void setObjectValue(Object value) {
        if (value instanceof Calendar) {
            this.setValue((Calendar)value);
        } else if (value instanceof Date) {
            this.setValue((Date)value);
        } else if (value instanceof Boolean) {
            this.setValue((Boolean)value);
        } else if (value instanceof Integer) {
            this.setValue((Integer)value);
        } else if (value instanceof Float) {
            this.setValue((Float)value);
        } else if (value != null) {
            this.setValue(value.toString());
        } else {
            this.setValue((String)null);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String toString() {
        return "" + this.name + ":" + this.type + "(" + this.stringValue + ")";
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }
}

