/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ActionType implements Enumerator
{
    URL_REDIRECT_LITERAL(0, "URLRedirect", "URL_Redirect"),
    SHOW_TOOLTIP_LITERAL(1, "ShowTooltip", "Show_Tooltip"),
    TOGGLE_VISIBILITY_LITERAL(2, "ToggleVisibility", "Toggle_Visibility"),
    INVOKE_SCRIPT_LITERAL(3, "InvokeScript", "Invoke_Script"),
    HIGHLIGHT_LITERAL(4, "Highlight", "Highlight"),
    CALL_BACK_LITERAL(5, "CallBack", "CallBack"),
    TOGGLE_DATA_POINT_VISIBILITY_LITERAL(6, "ToggleDataPointVisibility", "Toggle_DataPoint_Visibility");

    public static final int URL_REDIRECT = 0;
    public static final int SHOW_TOOLTIP = 1;
    public static final int TOGGLE_VISIBILITY = 2;
    public static final int INVOKE_SCRIPT = 3;
    public static final int HIGHLIGHT = 4;
    public static final int CALL_BACK = 5;
    public static final int TOGGLE_DATA_POINT_VISIBILITY = 6;
    private static final ActionType[] VALUES_ARRAY;
    public static final List<ActionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActionType[]{URL_REDIRECT_LITERAL, SHOW_TOOLTIP_LITERAL, TOGGLE_VISIBILITY_LITERAL, INVOKE_SCRIPT_LITERAL, HIGHLIGHT_LITERAL, CALL_BACK_LITERAL, TOGGLE_DATA_POINT_VISIBILITY_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActionType get(int value) {
        switch (value) {
            case 0: {
                return URL_REDIRECT_LITERAL;
            }
            case 1: {
                return SHOW_TOOLTIP_LITERAL;
            }
            case 2: {
                return TOGGLE_VISIBILITY_LITERAL;
            }
            case 3: {
                return INVOKE_SCRIPT_LITERAL;
            }
            case 4: {
                return HIGHLIGHT_LITERAL;
            }
            case 5: {
                return CALL_BACK_LITERAL;
            }
            case 6: {
                return TOGGLE_DATA_POINT_VISIBILITY_LITERAL;
            }
        }
        return null;
    }

    private ActionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

