/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartInXTabStatusManager;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.IChartReportItem;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartCubeUtil
extends ChartItemUtil {
    public static final DimensionValue DEFAULT_COLUMN_WIDTH = new DimensionValue(80.0, "pt");
    public static final DimensionValue DEFAULT_ROW_HEIGHT = new DimensionValue(30.0, "pt");

    public static CubeHandle getBindingCube(DesignElementHandle element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ReportItemHandle) {
            CubeHandle cube = ((ReportItemHandle)element).getCube();
            if (cube != null) {
                return cube;
            }
            if (((ReportItemHandle)element).getDataBindingType() == 2) {
                return ChartCubeUtil.getBindingCube(((ReportItemHandle)element).getDataBindingReference());
            }
            if (((ReportItemHandle)element).getDataBindingType() == 1) {
                return null;
            }
        }
        if (element.getContainer() != null) {
            return ChartCubeUtil.getBindingCube(element.getContainer());
        }
        return null;
    }

    public static List<MeasureHandle> getAllMeasures(CubeHandle cube) {
        if (cube.getContentCount("measureGroups") > 0) {
            ArrayList<MeasureHandle> measures = new ArrayList<MeasureHandle>();
            for (MeasureGroupHandle measureGroup : cube.getContents("measureGroups")) {
                measures.addAll(measureGroup.getContents("measures"));
            }
            return measures;
        }
        return Collections.emptyList();
    }

    public static List<LevelHandle> getAllLevels(CubeHandle cube) {
        if (cube.getContentCount("dimensions") > 0) {
            ArrayList<LevelHandle> levels = new ArrayList<LevelHandle>();
            for (DimensionHandle dimensionHandle : cube.getContents("dimensions")) {
                HierarchyHandle hierarchy = (HierarchyHandle)dimensionHandle.getContent("hierarchies", 0);
                int count = hierarchy.getLevelCount();
                int i = 0;
                while (i < count) {
                    levels.add(hierarchy.getLevel(i));
                    ++i;
                }
            }
            return levels;
        }
        return Collections.emptyList();
    }

    public static int getDimensionCount(CubeHandle cube) {
        if (cube == null) {
            return 0;
        }
        return cube.getContentCount("dimensions");
    }

    public static List<String> getAllLevelsBindingName(CrosstabReportItemHandle xtab) {
        DataItemHandle dataItemHandle;
        ArrayList<String> levels = new ArrayList<String>();
        Object content = ChartCubeUtil.getFirstContent(ChartCubeUtil.getInnermostLevelCell(xtab, 1));
        if (content instanceof DataItemHandle) {
            dataItemHandle = (DataItemHandle)content;
            levels.add(dataItemHandle.getResultSetColumn());
        }
        if ((content = ChartCubeUtil.getFirstContent(ChartCubeUtil.getInnermostLevelCell(xtab, 0))) instanceof DataItemHandle) {
            dataItemHandle = (DataItemHandle)content;
            levels.add(dataItemHandle.getResultSetColumn());
        }
        return levels;
    }

    public static List<String> getAllLevelsBindingName(Iterator<ComputedColumnHandle> columnBindings) {
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        ArrayList<String> bindings = new ArrayList<String>();
        while (columnBindings.hasNext()) {
            ComputedColumnHandle cc = columnBindings.next();
            ChartReportItemUtil.loadExpression(exprCodec, cc);
            if (!exprCodec.isDimensionExpresion()) continue;
            bindings.add(cc.getName());
        }
        return bindings;
    }

    public static List<String> getAllMeasuresBindingName(Iterator<ComputedColumnHandle> columnBindings) {
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        ArrayList<String> bindings = new ArrayList<String>();
        while (columnBindings.hasNext()) {
            ComputedColumnHandle cc = columnBindings.next();
            ChartReportItemUtil.loadExpression(exprCodec, cc);
            if (exprCodec.isDimensionExpresion()) continue;
            bindings.add(cc.getName());
        }
        return bindings;
    }

    public static Object getFirstContent(CrosstabCellHandle cell) {
        List contents;
        if (cell != null && (contents = cell.getContents()) != null && contents.size() >= 1) {
            return contents.get(0);
        }
        return null;
    }

    public static ExtendedItemHandle findAxisChartInCell(CrosstabCellHandle cell) {
        List contents;
        if (cell != null && (contents = cell.getContents()) != null && contents.size() >= 1) {
            int i = 0;
            while (i < contents.size()) {
                Object obj = contents.get(i);
                if (obj instanceof ExtendedItemHandle && ChartCubeUtil.isAxisChart((ExtendedItemHandle)obj)) {
                    return (ExtendedItemHandle)obj;
                }
                ++i;
            }
        }
        return null;
    }

    public static LevelViewHandle getLevel(CrosstabReportItemHandle xtab, int axisType, int levelIndex) {
        if (xtab == null) {
            return null;
        }
        CrosstabViewHandle xtabView = xtab.getCrosstabView(axisType);
        if (xtabView == null) {
            return null;
        }
        int countAll = 0;
        int dimensionCount = xtabView.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dim = xtabView.getDimension(i);
            if (dim != null) {
                if (levelIndex >= countAll && levelIndex < countAll + dim.getLevelCount()) {
                    return dim.getLevel(levelIndex - countAll);
                }
                countAll += dim.getLevelCount();
            }
            ++i;
        }
        return null;
    }

    public static CrosstabCellHandle getInnermostLevelCell(CrosstabReportItemHandle xtab, int axisType) {
        int levelCount = ChartCubeUtil.getLevelCount(xtab, axisType);
        LevelViewHandle levelView = ChartCubeUtil.getLevel(xtab, axisType, levelCount - 1);
        if (levelView != null) {
            return levelView.getCell();
        }
        return null;
    }

    public static int getLevelCount(CrosstabReportItemHandle xtab, int axisType) {
        if (xtab == null) {
            return 0;
        }
        CrosstabViewHandle xtabView = xtab.getCrosstabView(axisType);
        if (xtabView == null) {
            return 0;
        }
        int countAll = 0;
        int dimensionCount = xtabView.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dim = xtabView.getDimension(i);
            if (dim != null) {
                countAll += dim.getLevelCount();
            }
            ++i;
        }
        return countAll;
    }

    public static AggregationCellHandle getXtabContainerCell(DesignElementHandle chartHandle) throws BirtException {
        ExtendedItemHandle xtabHandle;
        String exName;
        DesignElementHandle container = chartHandle.getContainer();
        if (container instanceof ExtendedItemHandle && "AggregationCell".equals(exName = (xtabHandle = (ExtendedItemHandle)container).getExtensionName())) {
            return (AggregationCellHandle)xtabHandle.getReportItem();
        }
        return null;
    }

    public static CrosstabCellHandle getXtabContainerCell(DesignElementHandle chartHandle, boolean bOnlyAggrCell) throws BirtException {
        DesignElementHandle container = chartHandle.getContainer();
        if (container instanceof ExtendedItemHandle) {
            IReportItem cellHandle;
            ExtendedItemHandle xtabHandle = (ExtendedItemHandle)container;
            String exName = xtabHandle.getExtensionName();
            if ("AggregationCell".equals(exName)) {
                return (AggregationCellHandle)xtabHandle.getReportItem();
            }
            if (!bOnlyAggrCell && (cellHandle = xtabHandle.getReportItem()) instanceof CrosstabCellHandle) {
                return (CrosstabCellHandle)cellHandle;
            }
        }
        return null;
    }

    public static String createDimensionExpression(LevelHandle level) {
        if (level == null) {
            return null;
        }
        if (level instanceof TabularLevelHandle && ((TabularLevelHandle)level).getDisplayColumnName() != null && ((TabularLevelHandle)level).getDisplayColumnName().trim().length() > 0) {
            return ExpressionUtil.createJSDimensionExpression(level.getContainer().getContainer().getName(), level.getName(), "DisplayName");
        }
        return ExpressionUtil.createJSDimensionExpression(level.getContainer().getContainer().getName(), level.getName());
    }

    public static String createDimensionExpression(LevelHandle level, String attributeName) {
        if (level == null) {
            return null;
        }
        return ExpressionUtil.createJSDimensionExpression(level.getContainer().getContainer().getName(), level.getName(), attributeName);
    }

    public static String createMeasureExpression(MeasureHandle measure) {
        if (measure == null) {
            return null;
        }
        return ExpressionUtil.createJSMeasureExpression(measure.getName());
    }

    public static String createLevelBindingName(LevelHandle level) {
        if (level == null) {
            return null;
        }
        return String.valueOf(level.getContainer().getContainer().getName()) + "/" + level.getName();
    }

    public static String createLevelAttrBindingName(LevelHandle level, LevelAttributeHandle levelAttr) {
        String levelName = ChartCubeUtil.createLevelBindingName(level);
        if (levelName == null || levelAttr == null) {
            return null;
        }
        return String.valueOf(levelName) + "/" + levelAttr.getName();
    }

    public static String createMeasureBindingName(MeasureHandle measure) {
        if (measure == null) {
            return null;
        }
        return String.valueOf(measure.getContainer().getName()) + "/" + measure.getName();
    }

    public static ComputedColumnHandle findBinding(ReportItemHandle handle, String expression) {
        if (expression != null) {
            Iterator<ComputedColumnHandle> bindings = ChartCubeUtil.getAllColumnBindingsIterator(handle);
            while (bindings.hasNext()) {
                ComputedColumnHandle cc = bindings.next();
                if (!expression.equals(cc.getExpression())) continue;
                return cc;
            }
        }
        return null;
    }

    public static ComputedColumnHandle findLevelBinding(ReportItemHandle handle, String dimensionName, String levelName) {
        if (dimensionName != null && levelName != null) {
            ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
            Iterator<ComputedColumnHandle> bindings = ChartCubeUtil.getAllColumnBindingsIterator(handle);
            while (bindings.hasNext()) {
                ComputedColumnHandle cch = bindings.next();
                ChartReportItemUtil.loadExpression(exprCodec, cch);
                String[] levelNames = exprCodec.getLevelNames();
                if (levelNames == null || !dimensionName.equals(levelNames[0]) || !levelName.equals(levelNames[1])) continue;
                return cch;
            }
        }
        return null;
    }

    public static ComputedColumnHandle findLevelAttrBinding(ReportItemHandle handle, String dimensionName, String levelName, String laName) {
        if (dimensionName != null && levelName != null && laName != null) {
            ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
            Iterator<ComputedColumnHandle> bindings = ChartCubeUtil.getAllColumnBindingsIterator(handle);
            while (bindings.hasNext()) {
                ComputedColumnHandle cch = bindings.next();
                ChartReportItemUtil.loadExpression(exprCodec, cch);
                String[] levelNames = exprCodec.getLevelNames();
                if (levelNames == null || !dimensionName.equals(levelNames[0]) || !levelName.equals(levelNames[1]) || levelNames.length <= 2 || !laName.equals(levelNames[2])) continue;
                return cch;
            }
        }
        return null;
    }

    public static ComputedColumnHandle findMeasureBinding(ReportItemHandle handle, String measureName) {
        if (measureName != null) {
            ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
            Iterator<ComputedColumnHandle> bindings = ChartCubeUtil.getAllColumnBindingsIterator(handle);
            while (bindings.hasNext()) {
                ComputedColumnHandle cch = bindings.next();
                ChartReportItemUtil.loadExpression(exprCodec, cch);
                String name = exprCodec.getMeasureName();
                if (name == null || !measureName.equals(name)) continue;
                return cch;
            }
        }
        return null;
    }

    public static boolean isInXTabMeasureCell(DesignElementHandle chartHandle) {
        String exName;
        DesignElementHandle container = chartHandle.getContainer();
        return container instanceof ExtendedItemHandle && "AggregationCell".equals(exName = ((ExtendedItemHandle)container).getExtensionName());
    }

    public static boolean isPlotChart(DesignElementHandle chartHandle) {
        if (ChartCubeUtil.isChartHandle(chartHandle)) {
            return "plotChart".equals(chartHandle.getProperty("chartType"));
        }
        return false;
    }

    public static boolean isAxisChart(DesignElementHandle chartHandle) {
        if (ChartCubeUtil.isChartHandle(chartHandle)) {
            return "axisChart".equals(chartHandle.getProperty("chartType"));
        }
        return false;
    }

    public static Chart updateModelToRenderPlot(Chart cm, boolean bRtL) {
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes chart = (ChartWithAxes)cm;
            boolean bTransposed = chart.isTransposed();
            chart.getLegend().setVisible(false);
            chart.getTitle().setVisible(false);
            chart.getBlock().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.setReverseCategory(bTransposed || bRtL);
            chart.getPlot().getOutline().setVisible(false);
            chart.getPlot().getClientArea().setVisible(true);
            chart.getPlot().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().getClientArea().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().setVerticalSpacing(0);
            chart.getPlot().setHorizontalSpacing(0);
            Axis xAxis = (Axis)chart.getAxes().get(0);
            Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
            xAxis.getTitle().setVisible(false);
            xAxis.getLabel().setVisible(false);
            xAxis.getLineAttributes().setVisible(false);
            xAxis.getMajorGrid().getTickAttributes().setVisible(false);
            xAxis.getMinorGrid().getTickAttributes().setVisible(false);
            xAxis.setCategoryAxis(true);
            yAxis.getTitle().setVisible(false);
            yAxis.getLabel().setVisible(false);
            yAxis.getLineAttributes().setVisible(false);
            yAxis.getMajorGrid().getTickAttributes().setVisible(false);
            yAxis.getMinorGrid().getTickAttributes().setVisible(false);
            yAxis.setLabelWithinAxes(true);
        }
        return cm;
    }

    public static Chart updateModelToRenderAxis(Chart cm, boolean bRtL) {
        if (cm instanceof ChartWithAxes) {
            ChartWithAxes chart = (ChartWithAxes)cm;
            chart.getLegend().setVisible(false);
            chart.getTitle().setVisible(false);
            chart.getPlot().getOutline().setVisible(false);
            chart.getPlot().getClientArea().setVisible(false);
            chart.getBlock().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().getClientArea().getInsets().set(0.0, 0.0, 0.0, 0.0);
            chart.getPlot().setVerticalSpacing(0);
            chart.getPlot().setHorizontalSpacing(0);
            boolean bTransposed = chart.isTransposed();
            Axis xAxis = (Axis)chart.getAxes().get(0);
            Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
            xAxis.getTitle().setVisible(false);
            xAxis.getLabel().setVisible(false);
            xAxis.getLineAttributes().setVisible(false);
            xAxis.getMajorGrid().getTickAttributes().setVisible(false);
            xAxis.getMajorGrid().getLineAttributes().setVisible(false);
            xAxis.getMinorGrid().getTickAttributes().setVisible(false);
            xAxis.getMinorGrid().getLineAttributes().setVisible(false);
            yAxis.getLabel().setVisible(true);
            yAxis.getMajorGrid().getTickAttributes().setVisible(true);
            yAxis.getTitle().setVisible(false);
            yAxis.getLineAttributes().setVisible(false);
            yAxis.getMajorGrid().getLineAttributes().setVisible(false);
            yAxis.getMinorGrid().getLineAttributes().setVisible(false);
            yAxis.getMajorGrid().setTickStyle(bTransposed || bRtL ? TickStyle.LEFT_LITERAL : TickStyle.RIGHT_LITERAL);
            yAxis.setLabelPosition(bTransposed || bRtL ? Position.LEFT_LITERAL : Position.RIGHT_LITERAL);
            yAxis.setLabelWithinAxes(true);
            if (bTransposed) {
                yAxis.getOrigin().setType(IntersectionType.MAX_LITERAL);
            }
        } else {
            cm = null;
        }
        return cm;
    }

    public static String generateComputedColumnName(AggregationCellHandle cell) {
        MeasureViewHandle measureView = (MeasureViewHandle)cell.getContainer();
        LevelHandle rowLevelHandle = cell.getAggregationOnRow();
        LevelHandle colLevelHandle = cell.getAggregationOnColumn();
        String aggregationOnRow = rowLevelHandle == null ? null : rowLevelHandle.getFullName();
        String aggregationOnColumn = colLevelHandle == null ? null : colLevelHandle.getFullName();
        String name = "";
        String temp = measureView.getCubeMeasureName();
        if (temp != null && temp.length() > 0) {
            name = String.valueOf(name) + temp;
        }
        if (aggregationOnRow != null && aggregationOnRow.length() > 0) {
            name = name.length() > 0 ? String.valueOf(name) + "_" + aggregationOnRow : String.valueOf(name) + aggregationOnRow;
        }
        if (aggregationOnColumn != null && aggregationOnColumn.length() > 0) {
            name = name.length() > 0 ? String.valueOf(name) + "_" + aggregationOnColumn : String.valueOf(name) + aggregationOnColumn;
        }
        if (name.length() <= 0) {
            name = "measure";
        }
        ComputedColumn column = StructureFactory.newComputedColumn(cell.getCrosstabHandle(), name);
        String dataType = measureView.getDataType();
        column.setDataType(dataType);
        column.setExpression(ExpressionUtil.createJSMeasureExpression(measureView.getCubeMeasureName()));
        column.setAggregateFunction(ChartCubeUtil.getDefaultMeasureAggregationFunction(measureView));
        if (aggregationOnRow != null) {
            column.addAggregateOn(aggregationOnRow);
        }
        if (aggregationOnColumn != null) {
            column.addAggregateOn(aggregationOnColumn);
        }
        try {
            ComputedColumnHandle columnHandle = ((ReportItemHandle)cell.getCrosstabHandle()).addColumnBinding(column, false);
            return columnHandle.getName();
        }
        catch (SemanticException e) {
            logger.log(e);
            return name;
        }
    }

    static String getDefaultMeasureAggregationFunction(MeasureViewHandle mv) {
        String func;
        if (mv != null && mv.getCubeMeasure() != null && (func = mv.getCubeMeasure().getFunction()) != null) {
            return ChartCubeUtil.getRollUpAggregationFunction(func);
        }
        return "sum";
    }

    static String getRollUpAggregationFunction(String functionName) {
        if ("average".equals(functionName) || "count".equals(functionName) || "count-distinct".equals(functionName)) {
            return "sum";
        }
        return functionName;
    }

    public static List<String> getRelatedBindingNames(String dimExpr, Collection<ComputedColumnHandle> values) {
        ArrayList<String> bindingNames = new ArrayList<String>(1);
        for (ComputedColumnHandle cch : values) {
            if (!dimExpr.equals(cch.getExpression())) continue;
            bindingNames.add(cch.getName());
        }
        return bindingNames;
    }

    public static List<String> findDimensionBindingNames(String dimName, String levelName, Collection<ComputedColumnHandle> bindings) {
        ArrayList<String> bindingNames = new ArrayList<String>(1);
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        for (ComputedColumnHandle cch : bindings) {
            ChartReportItemUtil.loadExpression(exprCodec, cch);
            String[] levelNames = exprCodec.getLevelNames();
            if (levelNames == null || !levelNames[0].equals(dimName) || !levelNames[1].equals(levelName)) continue;
            bindingNames.add(cch.getName());
        }
        return bindingNames;
    }

    public static ComputedColumnHandle findDimensionBinding(ChartExpressionUtil.ExpressionCodec exprCodec, String dimName, String levelName, Collection<ComputedColumnHandle> bindings) {
        for (ComputedColumnHandle cch : bindings) {
            ChartReportItemUtil.loadExpression(exprCodec, cch);
            String[] levelNames = exprCodec.getLevelNames();
            if (levelNames == null || !levelNames[0].equals(dimName) || !levelNames[1].equals(levelName)) continue;
            return cch;
        }
        return null;
    }

    public static ExtendedItemHandle findReferenceChart(ExtendedItemHandle chartHandle) {
        if (ChartCubeUtil.isAxisChart(chartHandle)) {
            return (ExtendedItemHandle)chartHandle.getElementProperty("hostChart");
        }
        if (ChartCubeUtil.isPlotChart(chartHandle)) {
            Iterator iterator = chartHandle.clientsIterator();
            while (iterator.hasNext()) {
                DesignElementHandle client = (DesignElementHandle)iterator.next();
                if (!ChartCubeUtil.isAxisChart(client)) continue;
                return (ExtendedItemHandle)client;
            }
        }
        return null;
    }

    public static boolean isDetailCell(AggregationCellHandle cell) {
        return "detail".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
    }

    public static boolean isAggregationCell(AggregationCellHandle cell) {
        return "aggregations".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
    }

    public static int getXTabAxisType(boolean bTransposed) {
        return bTransposed ? 0 : 1;
    }

    public static void updateXTabForAxis(AggregationCellHandle cell, ExtendedItemHandle hostChartHandle, boolean bTransOld, ChartWithAxes cmNew) throws BirtException {
        if (cell == null) {
            return;
        }
        boolean bTransNew = cmNew.isTransposed();
        if (bTransOld != bTransNew) {
            ChartCubeUtil.updateXTabDirection(cell.getCrosstab(), bTransNew);
            boolean bNewTotalJustAdded = false;
            List<ExtendedItemHandle> otherPlotCharts = ChartCubeUtil.findChartInOtherMeasures(cell, true);
            int i = 0;
            while (i < otherPlotCharts.size()) {
                ExtendedItemHandle chartInOtherMeasure = otherPlotCharts.get(i);
                if (chartInOtherMeasure != null) {
                    ChartWithAxes cwa = ChartCubeUtil.updateChartModelWhenTransposing(chartInOtherMeasure, cmNew);
                    AggregationCellHandle cellAgg = ChartCubeUtil.getXtabContainerCell(chartInOtherMeasure);
                    if (ChartCubeUtil.removeAxisChartInXTab(cellAgg, bTransOld, true)) {
                        bNewTotalJustAdded = ChartCubeUtil.addAxisChartInXTab(cellAgg, cwa, chartInOtherMeasure, bNewTotalJustAdded);
                    } else {
                        ChartCubeUtil.updateAxisChartCells(cell, cmNew);
                    }
                }
                ++i;
            }
            if (ChartCubeUtil.removeAxisChartInXTab(cell, bTransOld, true)) {
                ChartCubeUtil.addAxisChartInXTab(cell, cmNew, hostChartHandle, bNewTotalJustAdded);
            } else {
                ChartCubeUtil.updateAxisChartCells(cell, cmNew);
            }
        }
    }

    private static ChartWithAxes updateChartModelWhenTransposing(ExtendedItemHandle eih, ChartWithAxes cmFrom) throws ExtendedElementException {
        IChartReportItem reportItem = (IChartReportItem)eih.getReportItem();
        ChartWithAxes cmOld = (ChartWithAxes)reportItem.getProperty("chart.instance");
        ChartWithAxes cmNew = cmOld.copyInstance();
        cmNew.setTransposed(cmFrom.isTransposed());
        cmNew.getBaseAxes()[0].setType(AxisType.TEXT_LITERAL);
        Query queryFrom = (Query)((SeriesDefinition)((Axis)cmFrom.getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries().getDataDefinition().get(0);
        Query queryTo = (Query)((SeriesDefinition)((Axis)cmNew.getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries().getDataDefinition().get(0);
        queryTo.setDefinition(queryFrom.getDefinition());
        reportItem.executeSetModelCommand(eih, cmOld, cmNew);
        return cmNew;
    }

    public static void updateXTabDirection(CrosstabReportItemHandle xtab, boolean bTransposed) throws SemanticException {
        if (bTransposed) {
            if (!"horizontal".equals(xtab.getMeasureDirection())) {
                xtab.setMeasureDirection("horizontal");
            }
        } else if (!"vertical".equals(xtab.getMeasureDirection())) {
            xtab.setMeasureDirection("vertical");
        }
    }

    public static List<ExtendedItemHandle> findChartInOtherMeasures(AggregationCellHandle cell, boolean bPlotChart) {
        if (cell.getCrosstab().getMeasureCount() > 1) {
            ArrayList<ExtendedItemHandle> list = new ArrayList<ExtendedItemHandle>();
            int i = 0;
            while (i < cell.getCrosstab().getMeasureCount()) {
                MeasureViewHandle mv = cell.getCrosstab().getMeasure(i);
                if (mv != cell.getContainer()) {
                    AggregationCellHandle aggCell = mv.getCell();
                    Object content = ChartCubeUtil.getFirstContent(aggCell);
                    if (bPlotChart && ChartCubeUtil.isPlotChart((DesignElementHandle)content) || !bPlotChart && ChartCubeUtil.isAxisChart((DesignElementHandle)content)) {
                        list.add((ExtendedItemHandle)content);
                    }
                    int j = 0;
                    while (j < mv.getAggregationCount()) {
                        aggCell = mv.getAggregationCell(j);
                        content = ChartCubeUtil.getFirstContent(aggCell);
                        if (bPlotChart && ChartCubeUtil.isPlotChart((DesignElementHandle)content) || !bPlotChart && ChartCubeUtil.isAxisChart((DesignElementHandle)content)) {
                            list.add((ExtendedItemHandle)content);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean removeAxisChartInXTab(AggregationCellHandle cell, boolean bTransposed, boolean bCleanSpan) throws BirtException {
        AggregationCellHandle grandTotalAggCell;
        if (bCleanSpan) {
            cell.setSpanOverOnRow(null);
            cell.setSpanOverOnColumn(null);
        }
        if ((grandTotalAggCell = ChartCubeUtil.getGrandTotalAggregationCell(cell, bTransposed)) != null && grandTotalAggCell.getContents().size() > 0) {
            ExtendedItemHandle axisChart = ChartCubeUtil.findAxisChartInCell(grandTotalAggCell);
            if (axisChart != null) {
                axisChart.dropAndClear();
            }
            if (ChartCubeUtil.isEmptyInAllGrandTotalCells(cell.getCrosstab(), bTransposed)) {
                cell.getCrosstab().removeGrandTotal(ChartCubeUtil.getXTabAxisType(bTransposed));
            }
            return true;
        }
        return false;
    }

    public static AggregationCellHandle getGrandTotalAggregationCell(AggregationCellHandle cell, boolean bTransposed) {
        if (cell == null) {
            return null;
        }
        if (bTransposed) {
            return ((MeasureViewHandle)cell.getContainer()).getAggregationCell(null, null, cell.getDimensionName(1), cell.getLevelName(1));
        }
        return ((MeasureViewHandle)cell.getContainer()).getAggregationCell(cell.getDimensionName(0), cell.getLevelName(0), null, null);
    }

    private static boolean isEmptyInAllGrandTotalCells(CrosstabReportItemHandle xtab, boolean bTransposed) {
        int i = 0;
        while (i < xtab.getMeasureCount()) {
            MeasureViewHandle mv = xtab.getMeasure(i);
            AggregationCellHandle grandTotalCell = ChartCubeUtil.getGrandTotalAggregationCell(mv.getCell(), bTransposed);
            if (grandTotalCell != null && grandTotalCell.getContents().size() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean addAxisChartInXTab(AggregationCellHandle cell, ChartWithAxes cwa, ExtendedItemHandle hostChartHandle, boolean bNewTotalJustAdded) throws BirtException {
        Object content;
        if (!ChartCubeUtil.updateAxisChartCells(cell, cwa)) {
            return false;
        }
        if (!ChartCubeUtil.isYAxisVisible(cwa)) {
            return bNewTotalJustAdded;
        }
        boolean bTransposed = cwa.isTransposed();
        int axisType = ChartCubeUtil.getXTabAxisType(bTransposed);
        boolean bNewGrandTotol = bNewTotalJustAdded;
        if (cell.getCrosstab().getGrandTotal(axisType) == null) {
            bNewGrandTotol = true;
            cell.getCrosstab().addGrandTotal(axisType);
            ChartCubeUtil.deleteGrandTotalItems(cell.getCrosstab(), bTransposed);
        }
        AggregationCellHandle grandTotalAggCell = bTransposed ? ((MeasureViewHandle)cell.getContainer()).getAggregationCell(null, null, cell.getDimensionName(1), cell.getLevelName(1)) : ((MeasureViewHandle)cell.getContainer()).getAggregationCell(cell.getDimensionName(0), cell.getLevelName(0), null, null);
        ChartCubeUtil.initCellSize(grandTotalAggCell);
        if (bNewGrandTotol && (content = ChartCubeUtil.getFirstContent(grandTotalAggCell)) instanceof DesignElementHandle) {
            ((DesignElementHandle)content).dropAndClear();
        }
        if (ChartCubeUtil.findAxisChartInCell(grandTotalAggCell) != null) {
            return bNewTotalJustAdded;
        }
        if (grandTotalAggCell != null) {
            ExtendedItemHandle axisChartHandle = ChartCubeUtil.createChartHandle(cell.getModelHandle(), "axisChart", hostChartHandle);
            grandTotalAggCell.addContent(axisChartHandle, 0);
        }
        return bNewGrandTotol;
    }

    public static boolean addAxisChartInXTab(AggregationCellHandle cell, ChartWithAxes cwa, ExtendedItemHandle hostChartHandle) throws BirtException {
        return ChartCubeUtil.addAxisChartInXTab(cell, cwa, hostChartHandle, !ChartInXTabStatusManager.hasGrandItem(hostChartHandle));
    }

    private static void initCellSize(AggregationCellHandle cell) throws BirtException {
        if (cell.getWidth() == null || cell.getWidth().getMeasure() == 0.0) {
            cell.getCrosstab().setColumnWidth(cell, DEFAULT_COLUMN_WIDTH);
        }
        if (cell.getHeight() == null || cell.getHeight().getMeasure() == 0.0) {
            cell.getCrosstab().setRowHeight(cell, DEFAULT_ROW_HEIGHT);
        }
    }

    public static boolean updateAxisChartCells(AggregationCellHandle cell, ChartWithAxes cwa) throws BirtException {
        ChartCubeUtil.initCellSize(cell);
        boolean bTransposed = cwa.isTransposed();
        if (bTransposed) {
            cell.setSpanOverOnRow(cell.getAggregationOnRow());
            cell.setSpanOverOnColumn(null);
            CrosstabCellHandle rowCell = ChartCubeUtil.getInnermostLevelCell(cell.getCrosstab(), 0);
            if (rowCell == null) {
                return false;
            }
            if (rowCell.getHeight() == null || rowCell.getHeight().getMeasure() == 0.0) {
                cell.getCrosstab().setRowHeight(rowCell, DEFAULT_ROW_HEIGHT);
            }
            ChartCubeUtil.removeCellPadding(rowCell, bTransposed);
        } else {
            cell.setSpanOverOnColumn(cell.getAggregationOnColumn());
            cell.setSpanOverOnRow(null);
            CrosstabCellHandle columnCell = ChartCubeUtil.getInnermostLevelCell(cell.getCrosstab(), 1);
            if (columnCell == null) {
                return false;
            }
            if (columnCell.getWidth() != null || columnCell.getWidth().getMeasure() == 0.0) {
                cell.getCrosstab().setColumnWidth(columnCell, DEFAULT_COLUMN_WIDTH);
            }
            ChartCubeUtil.removeCellPadding(columnCell, bTransposed);
        }
        ChartCubeUtil.removeCellPadding(cell, bTransposed);
        ChartCubeUtil.removeCellPadding(ChartCubeUtil.getGrandTotalAggregationCell(cell, !bTransposed), bTransposed);
        ChartCubeUtil.removeCellPadding(ChartCubeUtil.getMeasureAggregationCell(cell), bTransposed);
        return true;
    }

    private static void deleteGrandTotalItems(CrosstabReportItemHandle xtab, boolean bTransposed) throws SemanticException {
        int i = 0;
        while (i < xtab.getMeasureCount()) {
            MeasureViewHandle mv = xtab.getMeasure(i);
            AggregationCellHandle aggCell = ChartCubeUtil.getGrandTotalAggregationCell(mv.getCell(), bTransposed);
            Object content = ChartCubeUtil.getFirstContent(aggCell);
            if (content instanceof DataItemHandle) {
                ((DataItemHandle)content).dropAndClear();
            }
            ++i;
        }
    }

    public static void updateAxisChart(AggregationCellHandle cell, ChartWithAxes cwa, ExtendedItemHandle hostChartHandle) throws BirtException {
        boolean bTransposed = cwa.isTransposed();
        if (ChartCubeUtil.getGrandTotalCell(cell, bTransposed) != null) {
            AggregationCellHandle grandTotalAggCell = ChartCubeUtil.getGrandTotalAggregationCell(cell, bTransposed);
            Object content = ChartCubeUtil.getFirstContent(grandTotalAggCell);
            if (content instanceof DataItemHandle) {
                if (ChartCubeUtil.isYAxisVisible(cwa)) {
                    ExtendedItemHandle axisChartHandle = ChartCubeUtil.createChartHandle(cell.getModelHandle(), "axisChart", hostChartHandle);
                    grandTotalAggCell.addContent(axisChartHandle, 0);
                }
                if (!ChartInXTabStatusManager.hasGrandItem(cell)) {
                    ((DataItemHandle)content).dropAndClear();
                }
            } else if (ChartCubeUtil.isAxisChart((DesignElementHandle)content)) {
                if (((ExtendedItemHandle)content).getElementProperty("hostChart") != hostChartHandle) {
                    ((ExtendedItemHandle)content).setProperty("hostChart", hostChartHandle);
                }
            } else if (content == null) {
                ChartCubeUtil.addAxisChartInXTab(cell, cwa, hostChartHandle);
            }
        } else {
            ChartCubeUtil.addAxisChartInXTab(cell, cwa, hostChartHandle);
        }
    }

    public static AggregationCellHandle getMeasureAggregationCell(AggregationCellHandle cell) {
        if (cell == null) {
            return null;
        }
        return ((MeasureViewHandle)cell.getContainer()).getCell();
    }

    private static CrosstabCellHandle getGrandTotalCell(CrosstabCellHandle cell, boolean bTransposed) {
        if (cell == null) {
            return null;
        }
        return cell.getCrosstab().getGrandTotal(bTransposed ? 0 : 1);
    }

    public static ExtendedItemHandle createChartHandle(DesignElementHandle anyHandle, String chartType, ExtendedItemHandle hostChartHandle) throws SemanticException {
        ExtendedItemHandle chartHandle = anyHandle.getElementFactory().newExtendedItem(null, "Chart");
        if (chartType != null) {
            chartHandle.setProperty("chartType", chartType);
        }
        if (hostChartHandle != null) {
            chartHandle.setProperty("hostChart", hostChartHandle);
        } else {
            String namePrexif = Messages.getString((String)chartHandle.getDefn().getDisplayNameKey());
            chartHandle.makeUniqueName(namePrexif);
        }
        return chartHandle;
    }

    private static boolean isYAxisVisible(ChartWithAxes cwa) {
        Axis yAxis = (Axis)((Axis)cwa.getAxes().get(0)).getAssociatedAxes().get(0);
        return yAxis.getLineAttributes().isVisible();
    }

    private static void removeCellPadding(CrosstabCellHandle cell, boolean bTransposed) throws SemanticException {
        if (cell != null) {
            if (bTransposed) {
                cell.getModelHandle().setProperty("paddingTop", new DimensionValue(0.0, "pt"));
                cell.getModelHandle().setProperty("paddingBottom", new DimensionValue(0.0, "pt"));
            } else {
                cell.getModelHandle().setProperty("paddingLeft", new DimensionValue(0.0, "pt"));
                cell.getModelHandle().setProperty("paddingRight", new DimensionValue(0.0, "pt"));
            }
        }
    }

    public static boolean checkColumnbindingForCube(Iterator<ComputedColumnHandle> columnBindings) {
        boolean containDimension = false;
        boolean containMeasure = false;
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        while (columnBindings.hasNext()) {
            ComputedColumnHandle cc = columnBindings.next();
            ChartReportItemUtil.loadExpression(exprCodec, cc);
            if (!containDimension && exprCodec.isDimensionExpresion()) {
                containDimension = true;
            }
            if (containMeasure || !exprCodec.isMeasureExpresion()) continue;
            containMeasure = true;
        }
        return containDimension && containMeasure;
    }
}

