/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.NoRecalculateIVQuery;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.NoRecalculateIVResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.impl.PreparedIVQuerySourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

public class PreparedNoRecalculateIVQuery
extends PreparedIVQuerySourceQuery {
    private String resultSetId;

    PreparedNoRecalculateIVQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext, IQueryContextVisitor visitor) throws DataException {
        super(dataEngine, queryDefn, appContext, visitor);
    }

    protected void prepareQuery() throws DataException {
        try {
            this.queryResults = PreparedQueryUtil.newInstance(this.engine, (IQueryDefinition)this.queryDefn.getSourceQuery(), this.appContext).execute(null);
            ((NoRecalculateIVQuery)this.queryDefn).setSourceQuery(null);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        if (!this.hasBinding) {
            IBinding[] bindings = new IBinding[]{};
            if (this.queryResults != null && this.queryResults.getPreparedQuery() != null) {
                IQueryDefinition queryDefinition = this.queryResults.getPreparedQuery().getReportQueryDefn();
                bindings = queryDefinition.getBindings().values().toArray(new IBinding[0]);
            }
            int i = 0;
            while (i < bindings.length) {
                IBinding binding = bindings[i];
                if (!this.queryDefn.getBindings().containsKey(binding.getBindingName())) {
                    this.queryDefn.addBinding(new Binding(binding.getBindingName(), new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression(binding.getBindingName()), binding.getDataType())));
                }
                ++i;
            }
        }
    }

    protected void initializeExecution(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        String basedID = this.queryDefn.getQueryResultsID();
        String _1partID = QueryResultIDUtil.get1PartID(basedID);
        this.resultSetId = _1partID == null ? basedID : _1partID;
    }

    protected IQueryResults produceQueryResults(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        QueryResults queryResults = this.preparedQuery.doPrepare(outerResults, scope, this.newExecutor(), this);
        queryResults.setID(this.resultSetId);
        return queryResults;
    }

    protected QueryExecutor newExecutor() {
        return new NoUpdateAggrFilterIVQuerySourceExecutor(this.engine.getSession().getSharedScope());
    }

    protected class NoUpdateAggrFilterIVQuerySourceExecutor
    extends PreparedIVQuerySourceQuery.IVQuerySourceExecutor {
        NoUpdateAggrFilterIVQuerySourceExecutor(Scriptable sharedScope) {
            super(sharedScope);
            this.ignoreDataSetFilter = true;
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            try {
                ResultIterator sourceData = (ResultIterator)PreparedNoRecalculateIVQuery.this.queryResults.getResultIterator();
                PreparedIVQuerySourceQuery.IVQuerySourcePopulator querySourcePopulator = new PreparedIVQuerySourceQuery.IVQuerySourcePopulator(sourceData, this.getResultClass(), this.query, PreparedNoRecalculateIVQuery.this.queryDefn.getStartingRow());
                return new NoRecalculateIVResultSet(this.query, this.resultClass, querySourcePopulator, eventHandler, PreparedNoRecalculateIVQuery.this.engine.getSession(), sourceData.getGroupInfos());
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }
}

