/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.DataExtractionOption;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.IInternalReportDocument;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.api.impl.ResultSetItem;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.extension.IDataExtractionExtension;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class DataExtractionTaskV0
extends EngineTask
implements IDataExtractionTask {
    protected IReportDocument reportDocReader;
    protected Report report;
    protected InstanceID instanceId;
    protected String resultSetName;
    protected String[] selectedColumns;
    protected IExtractionResults currentResult = null;
    protected IFilterDefinition[] filterExpressions = null;
    protected ISortDefinition[] sortExpressions = null;
    protected int maxRows = -1;
    protected int startRow = 0;
    protected boolean distinct;
    protected boolean isMetaDataPrepared = false;
    protected HashMap rsetName2IdMapping = new HashMap();
    protected HashMap rsetId2queryIdMapping = new HashMap();
    protected HashMap queryId2NameMapping = new HashMap();
    protected HashMap queryId2QueryMapping = new HashMap();
    protected ArrayList resultMetaList = new ArrayList();
    private boolean isCubeExportEnabled;
    protected static Logger logger = Logger.getLogger(DteDataEngine.class.getName());

    public DataExtractionTaskV0(ReportEngine engine, IReportDocument reader) throws EngineException {
        super(engine, 4);
        IReportRunnable runnable = this.getOnPreparedRunnable(reader);
        this.setReportRunnable(runnable);
        IInternalReportDocument internalDoc = (IInternalReportDocument)reader;
        Report reportIR = internalDoc.getReportIR(this.executionContext.getReportDesign());
        this.executionContext.setReport(reportIR);
        this.report = this.executionContext.getReport();
        this.reportDocReader = reader;
        this.executionContext.setReportDocument(this.reportDocReader);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
    }

    private void prepareMetaData() throws EngineException {
        if (this.isMetaDataPrepared) {
            return;
        }
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        dataEngine.prepare(this.report, this.executionContext.getAppContext());
        HashMap queryIds = this.report.getQueryIDs();
        HashMap query2itemMapping = this.report.getReportItemToQueryMap();
        for (Map.Entry entry : queryIds.entrySet()) {
            IBaseQueryDefinition baseQuery = (IBaseQueryDefinition)entry.getKey();
            if (!(baseQuery instanceof IQueryDefinition)) continue;
            IQueryDefinition query = (IQueryDefinition)baseQuery;
            String queryId = (String)entry.getValue();
            ReportItemDesign item = (ReportItemDesign)query2itemMapping.get(query);
            String queryName = item.getName();
            if (queryName == null) {
                queryName = "ELEMENT_" + item.getID();
            }
            this.queryId2NameMapping.put(queryId, queryName);
            this.queryId2QueryMapping.put(queryId, query);
        }
        try {
            this.loadResultSetMetaData();
        }
        catch (EngineException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            this.executionContext.addException(e);
        }
        this.isMetaDataPrepared = true;
    }

    private String getQueryName(String queryId) {
        return (String)this.queryId2NameMapping.get(queryId);
    }

    private IQueryDefinition getQuery(String queryId) {
        return (IQueryDefinition)this.queryId2QueryMapping.get(queryId);
    }

    private void loadResultSetMetaData() throws EngineException {
        try {
            HashMap query2ResultMetaData = this.report.getResultMetaData();
            IDocArchiveReader reader = this.reportDocReader.getArchive();
            HashMap<String, Integer> queryCounts = new HashMap<String, Integer>();
            ArrayList result = DteMetaInfoIOUtil.loadDteMetaInfo(reader);
            if (result != null) {
                int i = 0;
                while (i < result.size()) {
                    String[] rsetRelation = (String[])result.get(i);
                    String queryId = rsetRelation[2];
                    String rsetId = rsetRelation[3];
                    IQueryDefinition query = this.getQuery(queryId);
                    this.rsetId2queryIdMapping.put(rsetId, queryId);
                    if (this.isMasterQuery(query)) {
                        ResultMetaData metaData;
                        int count = -1;
                        Integer countObj = (Integer)queryCounts.get(queryId);
                        if (countObj != null) {
                            count = countObj;
                        }
                        String rsetName = this.getQueryName(queryId);
                        if (++count > 0) {
                            rsetName = String.valueOf(rsetName) + "_" + count;
                        }
                        queryCounts.put(queryId, count);
                        this.rsetName2IdMapping.put(rsetName, rsetId);
                        if (query2ResultMetaData != null && (metaData = (ResultMetaData)query2ResultMetaData.get(query)).getColumnCount() > 0) {
                            ResultSetItem resultItem = new ResultSetItem(rsetName, metaData);
                            this.resultMetaList.add(resultItem);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
        }
    }

    private boolean isMasterQuery(IQueryDefinition query) {
        if (query.getDataSetName() == null) {
            return false;
        }
        IBaseQueryDefinition parent = query.getParentQuery();
        while (parent != null) {
            if (parent instanceof IQueryDefinition) {
                IQueryDefinition parentQuery = (IQueryDefinition)parent;
                if (parentQuery.getDataSetName() != null) {
                    return false;
                }
            } else {
                return false;
            }
            parent = parent.getParentQuery();
        }
        return true;
    }

    protected String instanceId2RsetName(InstanceID iid) {
        String rsetId;
        DataSetID dataSetId;
        DataID dataId = iid.getDataID();
        if (dataId != null && (dataSetId = dataId.getDataSetID()) != null && (rsetId = dataSetId.getDataSetName()) != null) {
            return this.rsetId2Name(rsetId);
        }
        return null;
    }

    protected String queryId2rsetId(String id) {
        for (Map.Entry entry : this.rsetId2queryIdMapping.entrySet()) {
            String queryId = (String)entry.getValue();
            String rsetId = (String)entry.getKey();
            if (!queryId.equals(id)) continue;
            return rsetId;
        }
        return null;
    }

    protected String rsetId2Name(String id) {
        for (Map.Entry entry : this.rsetName2IdMapping.entrySet()) {
            String rsetId = (String)entry.getValue();
            String rsetName = (String)entry.getKey();
            if (!rsetId.equals(id)) continue;
            return rsetName;
        }
        return null;
    }

    protected String rsetName2Id(String name) {
        return (String)this.rsetName2IdMapping.get(name);
    }

    public void setInstanceID(InstanceID iid) {
        assert (iid != null);
        try {
            this.prepareMetaData();
        }
        catch (EngineException e) {
            this.executionContext.addException(e);
        }
        this.instanceId = iid;
        this.resultSetName = null;
        this.selectedColumns = null;
    }

    public void selectResultSet(String displayName) {
        assert (displayName != null);
        try {
            this.prepareMetaData();
        }
        catch (EngineException e) {
            this.executionContext.addException(e);
        }
        if (displayName.startsWith("InstanceId:")) {
            this.resultSetName = null;
            this.instanceId = InstanceID.parse(displayName.substring(11));
        } else {
            this.resultSetName = displayName;
            this.instanceId = null;
        }
        this.selectedColumns = null;
    }

    public List getMetaData() throws EngineException {
        return this.getResultSetList();
    }

    public List getResultSetList() throws EngineException {
        this.prepareMetaData();
        if (this.instanceId != null) {
            ArrayList<ResultSetItem> rsetList = new ArrayList<ResultSetItem>();
            String rsetName = this.instanceId2RsetName(this.instanceId);
            if (rsetName != null) {
                IResultMetaData metaData = this.getResultMetaData(rsetName);
                if (metaData != null) {
                    rsetList.add(new ResultSetItem(rsetName, metaData));
                }
            } else {
                IResultMetaData metaData = this.getMetaDateByInstanceID(this.instanceId);
                if (metaData != null) {
                    rsetList.add(new ResultSetItem("InstanceId:" + this.instanceId, metaData));
                }
            }
            return rsetList;
        }
        return this.resultMetaList;
    }

    protected IResultMetaData getResultMetaData(String rsetName) {
        for (IResultSetItem rsetItem : this.resultMetaList) {
            if (!rsetItem.getResultSetName().equals(rsetName)) continue;
            return rsetItem.getResultMetaData();
        }
        return null;
    }

    protected IResultSetItem getResultSetItem(String rsetName) {
        for (IResultSetItem rsetItem : this.resultMetaList) {
            if (!rsetItem.getResultSetName().equals(rsetName)) continue;
            return rsetItem;
        }
        return null;
    }

    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    public IExtractionResults extract() throws EngineException {
        String rsetName = this.resultSetName;
        if (rsetName == null && this.instanceId != null) {
            rsetName = this.instanceId2RsetName(this.instanceId);
        }
        if (rsetName != null) {
            return this.extractByResultSetName(rsetName);
        }
        if (this.instanceId != null) {
            return this.extractByInstanceID(this.instanceId);
        }
        this.prepareMetaData();
        if (!this.resultMetaList.isEmpty()) {
            IResultSetItem resultItem = (IResultSetItem)this.resultMetaList.get(0);
            return this.extractByResultSetName(resultItem.getResultSetName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IExtractionResults extractByResultSetName(String rsetName) throws EngineException {
        assert (rsetName != null);
        assert (this.executionContext.getDataEngine() != null);
        this.prepareMetaData();
        DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
        try {
            DesignElementHandle designElementHandle;
            String rsetId = this.rsetName2Id(rsetName);
            if (rsetId == null) return null;
            IQueryResults results = null;
            if (this.filterExpressions == null && this.sortExpressions == null && this.maxRows == -1) {
                results = dataSession.getQueryResults(rsetId);
            } else {
                int iNum;
                String queryId = (String)this.rsetId2queryIdMapping.get(rsetId);
                QueryDefinition query = (QueryDefinition)this.getQuery(queryId);
                QueryDefinition newQuery = this.queryCopy(query);
                if (newQuery == null) {
                    return null;
                }
                if (this.filterExpressions != null) {
                    iNum = 0;
                    while (true) {
                        if (iNum >= this.filterExpressions.length) {
                            this.filterExpressions = null;
                            break;
                        }
                        newQuery.getFilters().add(this.filterExpressions[iNum]);
                        ++iNum;
                    }
                }
                if (this.sortExpressions != null) {
                    iNum = 0;
                    while (true) {
                        if (iNum >= this.sortExpressions.length) {
                            this.sortExpressions = null;
                            break;
                        }
                        query.getSorts().add(this.sortExpressions[iNum]);
                        ++iNum;
                    }
                }
                if (this.maxRows != -1) {
                    query.setMaxRows(this.maxRows);
                    this.maxRows = -1;
                }
                newQuery.setQueryResultsID(rsetId);
                IPreparedQuery preparedQuery = dataSession.prepare(newQuery);
                dataSession.execute((IBasePreparedQuery)preparedQuery, null, this.executionContext.getScriptContext());
            }
            if (results == null) return null;
            IResultMetaData metaData = null;
            IResultSetItem rset = this.getResultSetItem(rsetName);
            if (rset != null) {
                metaData = rset.getResultMetaData();
            }
            if (metaData == null) return null;
            if (rset instanceof ResultSetItem) {
                designElementHandle = ((ResultSetItem)rset).getHandle();
                return new ExtractionResults(results, metaData, this.selectedColumns, this.startRow, this.maxRows, designElementHandle);
            }
            designElementHandle = null;
            return new ExtractionResults(results, metaData, this.selectedColumns, this.startRow, this.maxRows, designElementHandle);
        }
        catch (BirtException e) {
            throw new EngineException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private IExtractionResults extractByInstanceID(InstanceID iid) throws EngineException {
        block18: {
            block19: {
                dataId = iid.getDataID();
                dataSetId = dataId.getDataSetID();
                dataSession = this.executionContext.getDataEngine().getDTESession();
                scriptContext = this.executionContext.getScriptContext();
                dataIter = null;
                query = null;
                try {
                    if (this.filterExpressions == null && this.sortExpressions == null && this.maxRows == -1) {
                        dataIter = this.getResultSetIterator(dataSession, dataSetId, scriptContext);
                    }
                    id = iid.getComponentID();
                    design = (ReportItemDesign)this.report.getReportItemByID(id);
                    dataQuery = design.getQuery();
                    if (!(dataQuery instanceof IBaseQueryDefinition)) {
                    }
                    try {
                        query = (IBaseQueryDefinition)dataQuery;
                        if (this.filterExpressions != null) {
                            iNum = 0;
                            while (iNum < this.filterExpressions.length) {
                                query.getFilters().add(this.filterExpressions[iNum]);
                                ++iNum;
                            }
                        }
                        if (this.sortExpressions != null) {
                            iNum = 0;
                            while (iNum < this.sortExpressions.length) {
                                query.getSorts().add(this.sortExpressions[iNum]);
                                ++iNum;
                            }
                        }
                        if (this.maxRows != -1) {
                            query.setMaxRows(this.maxRows);
                        }
                        rootQuery = query;
                        while (rootQuery instanceof SubqueryDefinition) {
                            rootQuery = rootQuery.getParentQuery();
                        }
                        newRootQuery = this.queryCopy((QueryDefinition)rootQuery);
                        queryIds = this.report.getQueryIDs();
                        queryId = (String)queryIds.get(rootQuery);
                        rsetId = this.queryId2rsetId(queryId);
                        newRootQuery.setQueryResultsID(rsetId);
                        preparedQuery = dataSession.prepare(newRootQuery);
                        rootResults = (IQueryResults)dataSession.execute((IBasePreparedQuery)preparedQuery, null, scriptContext);
                        dataIter = this.getFilterResultSetIterator(dataSession, dataSetId, scriptContext, rootResults);
                    }
                    catch (BirtException e) {
                        throw new EngineException("Error.DataExportionError", (Object)iid, (Throwable)e);
                    }
                }
                finally {
                    if (query == null) break block18;
                    if (this.filterExpressions == null) break block19;
                    iNum = 0;
                    ** while (iNum < this.filterExpressions.length)
                }
lbl-1000:
                // 1 sources

                {
                    query.getFilters().remove(this.filterExpressions[iNum]);
                    ++iNum;
                    continue;
                }
lbl58:
                // 1 sources

                this.filterExpressions = null;
            }
            if (this.sortExpressions != null) {
                iNum = 0;
                while (iNum < this.sortExpressions.length) {
                    query.getSorts().remove(this.sortExpressions[iNum]);
                    ++iNum;
                }
                this.sortExpressions = null;
            }
            this.maxRows = -1;
        }
        if ((metaData = this.getMetaDateByInstanceID(iid)) != null) {
            return new ExtractionResults(dataIter, metaData, this.selectedColumns, this.startRow, this.maxRows);
        }
        return null;
    }

    private IResultMetaData getMetaDateByInstanceID(InstanceID iid) {
        ResultMetaData metaData = null;
        long id = iid.getComponentID();
        ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
        IDataQueryDefinition query = design.getQuery();
        if (query == null) {
            return null;
        }
        HashMap query2ResultMetaData = this.report.getResultMetaData();
        if (query2ResultMetaData != null) {
            metaData = (ResultMetaData)query2ResultMetaData.get(query);
        }
        return metaData;
    }

    private IResultIterator getResultSetIterator(DataRequestSession dataSession, DataSetID dataSet, ScriptContext scriptContext) throws BirtException {
        DataSetID parent = dataSet.getParentID();
        if (parent == null) {
            String rsetName = dataSet.getDataSetName();
            assert (rsetName != null);
            IQueryResults rset = dataSession.getQueryResults(rsetName);
            return rset.getResultIterator();
        }
        IResultIterator iter = this.getResultSetIterator(dataSession, parent, scriptContext);
        long rowId = dataSet.getRowID();
        String queryName = dataSet.getQueryName();
        assert (rowId != -1L);
        assert (queryName != null);
        iter.moveTo((int)rowId);
        return iter.getSecondaryIterator(scriptContext, queryName);
    }

    private IResultIterator getFilterResultSetIterator(DataRequestSession dataSession, DataSetID dataSet, ScriptContext scriptContext, IQueryResults rset) throws BirtException {
        DataSetID parent = dataSet.getParentID();
        if (parent == null) {
            return rset.getResultIterator();
        }
        IResultIterator iter = this.getFilterResultSetIterator(dataSession, parent, scriptContext, rset);
        long rowId = dataSet.getRowID();
        String queryName = dataSet.getQueryName();
        assert (rowId != -1L);
        assert (queryName != null);
        iter.moveTo((int)rowId);
        return iter.getSecondaryIterator(scriptContext, queryName);
    }

    private QueryDefinition queryCopy(QueryDefinition query) {
        if (query == null) {
            return null;
        }
        QueryDefinition newQuery = new QueryDefinition((BaseQueryDefinition)query.getParentQuery());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getSubqueries().addAll(query.getSubqueries());
        newQuery.getBindings().putAll(query.getBindings());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setMaxRows(query.getMaxRows());
        newQuery.setDataSetName(query.getDataSetName());
        newQuery.setAutoBinding(query.needAutoBinding());
        newQuery.setColumnProjection(query.getColumnProjection());
        return newQuery;
    }

    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }

    public void setSorts(ISortDefinition[] simpleSortExpression) {
        this.sortExpressions = simpleSortExpression;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void extract(IExtractionOption options) throws BirtException {
        DataExtractionOption option = null;
        option = options == null ? new DataExtractionOption() : new DataExtractionOption(options.getOptions());
        IDataExtractionExtension dataExtraction = this.getDataExtractionExtension(option);
        try {
            dataExtraction.initialize(this.executionContext.getReportContext(), option);
            dataExtraction.output(this.extract());
        }
        finally {
            dataExtraction.release();
        }
    }

    private IDataExtractionExtension getDataExtractionExtension(IDataExtractionOption option) throws EngineException {
        IDataExtractionExtension dataExtraction = null;
        String extension = option.getExtension();
        ExtensionManager extensionManager = ExtensionManager.getInstance();
        if (extension != null && (dataExtraction = extensionManager.createDataExtractionExtensionById(extension)) == null) {
            logger.log(Level.WARNING, "Extension with id " + extension + " doesn't exist.");
        }
        String format = null;
        if (dataExtraction == null && (format = option.getOutputFormat()) != null && (dataExtraction = extensionManager.createDataExtractionExtensionByFormat(format)) == null) {
            logger.log(Level.WARNING, "Extension of format " + format + " doesn't exist.");
        }
        if (dataExtraction == null) {
            throw new EngineException("Error.InvalidExtensionError", new Object[]{extension, format});
        }
        return dataExtraction;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setDistinctValuesOnly(boolean distinct) {
        this.distinct = distinct;
    }

    public void setCubeExportEnabled(boolean isCubeExportEnabled) {
        this.isCubeExportEnabled = isCubeExportEnabled;
    }

    public boolean isCubeExportEnabled() {
        return this.isCubeExportEnabled;
    }
}

