/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import com.lowagie.text.Image;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class EmitterUtil {
    protected static Logger logger = Logger.getLogger(EmitterUtil.class.getName());
    public static float ITALIC_HORIZONTAL_COEFFICIENT = (float)Math.tan(0.2617993877991494);

    public static OutputStream getOuputStream(IEmitterServices services, String defaultOutputFile) throws EngineException {
        FilterOutputStream out = null;
        Object fd = services.getOption("outputFile");
        File file = null;
        try {
            if (fd != null) {
                file = new File(fd.toString());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                out = new BufferedOutputStream(new FileOutputStream(file));
            }
        }
        catch (FileNotFoundException e) {
            throw new EngineException("Error.FailedToInitializeEmitter", e);
        }
        if (out == null) {
            Object value = services.getOption("outputStream");
            if (value != null && value instanceof OutputStream) {
                Object closeOnExitValue = services.getOption("closeOutputStreamOnExit");
                boolean closeOnExit = false;
                if (closeOnExitValue != null && closeOnExitValue instanceof Boolean) {
                    closeOnExit = (Boolean)closeOnExitValue;
                }
                out = new EmitterOutputStream((OutputStream)value, closeOnExit);
            } else {
                try {
                    file = new File(defaultOutputFile);
                    out = new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    throw new EngineException("Error.FailedToInitializeEmitter", e);
                }
            }
        }
        return out;
    }

    public static Image getImage(IImageContent content) {
        Image image = null;
        try {
            String uri = content.getURI();
            String mimeType = content.getMIMEType();
            String extension = content.getExtension();
            switch (content.getImageSource()) {
                case 0: {
                    ResourceLocatorWrapper rl = null;
                    ExecutionContext exeContext = ((ReportContent)content.getReportContent()).getExecutionContext();
                    if (exeContext != null) {
                        rl = exeContext.getResourceLocator();
                    }
                    ReportDesignHandle design = content.getReportContent().getDesign().getReportDesign();
                    byte[] buffer = null;
                    if (rl == null) {
                        URL url = design.findResource(uri, 1, content.getReportContent().getReportContext() == null ? null : content.getReportContent().getReportContext().getAppContext());
                        buffer = EmitterUtil.getImageByteArray(url.openStream());
                    } else {
                        buffer = rl.findResource(design, uri, 1, content.getReportContent().getReportContext() == null ? null : content.getReportContent().getReportContext().getAppContext());
                    }
                    if (buffer != null) {
                        if (SvgFile.isSvg(content.getURI())) {
                            buffer = SvgFile.transSvgToArray(new ByteArrayInputStream(buffer));
                        }
                        image = Image.getInstance((byte[])buffer);
                    }
                    break;
                }
                case 1: 
                case 2: {
                    byte[] data = content.getData();
                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                    if (SvgFile.isSvg(mimeType, uri, extension)) {
                        data = SvgFile.transSvgToArray(in);
                    }
                    in.close();
                    image = Image.getInstance((byte[])data);
                    break;
                }
                case 3: {
                    image = SvgFile.isSvg(uri) ? Image.getInstance((byte[])SvgFile.transSvgToArray(uri)) : Image.getInstance((URL)new URL(content.getURI()));
                    break;
                }
                default: {
                    assert (false);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        return image;
    }

    private static byte[] getImageByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int size = in.read(buffer);
        while (size != -1) {
            out.write(buffer, 0, size);
            size = in.read(buffer);
        }
        buffer = out.toByteArray();
        out.close();
        return buffer;
    }

    public static float getItalicHorizontalCoefficient() {
        return ITALIC_HORIZONTAL_COEFFICIENT;
    }

    public static String getColorString(Color color) {
        StringBuffer buffer = new StringBuffer();
        EmitterUtil.appendComponent(buffer, color.getRed());
        EmitterUtil.appendComponent(buffer, color.getGreen());
        EmitterUtil.appendComponent(buffer, color.getBlue());
        return buffer.toString();
    }

    public static void appendComponent(StringBuffer buffer, int component) {
        String hex = Integer.toHexString(component);
        if (hex.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hex);
    }

    public static String getImageExtension(String imageURI) {
        String rectifiedImageURI = imageURI.replace('.', '&');
        String extension = imageURI.substring(rectifiedImageURI.lastIndexOf(38) + 1).toLowerCase();
        if (extension.equals("svg")) {
            extension = "jpg";
        }
        return extension;
    }

    public static Position getImageSize(String imageURI) {
        Position imageSize;
        block14: {
            InputStream imageStream = null;
            imageSize = new Position(0.0f, 0.0f);
            try {
                try {
                    URL url = new URL(imageURI);
                    imageStream = url.openStream();
                    BufferedImage image = ImageIO.read(imageStream);
                    ImageIcon imageIcon = new ImageIcon(image);
                    imageSize.setX(imageIcon.getIconWidth());
                    imageSize.setY(imageIcon.getIconHeight());
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, ioe.getMessage(), ioe);
                    if (imageStream != null) {
                        try {
                            imageStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (imageStream != null) {
                    try {
                        imageStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (imageStream != null) {
                try {
                    imageStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageSize;
    }

    public static byte[] getImageData(String imageURI) throws IOException {
        byte[] imageData = null;
        if (SvgFile.isSvg(imageURI)) {
            try {
                imageData = SvgFile.transSvgToArray(imageURI);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        } else {
            imageData = EmitterUtil.getNonSVGImageData(imageURI);
        }
        return imageData;
    }

    private static byte[] getNonSVGImageData(String imageURI) throws IOException {
        byte[] imageData;
        InputStream imageStream = null;
        try {
            URL url = new URL(imageURI);
            imageStream = url.openStream();
            imageData = EmitterUtil.readData(imageStream);
        }
        catch (Throwable throwable) {
            if (imageStream != null) {
                try {
                    imageStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (imageStream != null) {
            try {
                imageStream.close();
            }
            catch (IOException iOException) {}
        }
        return imageData;
    }

    public static byte[] readData(InputStream imageStream) throws IOException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        int data = -1;
        while ((data = imageStream.read()) >= 0) {
            byteArrayStream.write(data);
        }
        byteArrayStream.close();
        return byteArrayStream.toByteArray();
    }

    public static String getBackgroundImageUrl(IStyle style, ReportDesignHandle reportDesign, Map context) {
        String url;
        String imageUri = PropertyUtil.getBackgroundImage(style.getProperty(49));
        if (imageUri != null && (url = EmitterUtil.getImageUrl(imageUri, reportDesign, context)) != null && url.length() > 0) {
            return url;
        }
        return null;
    }

    private static String getImageUrl(String imageUri, ReportDesignHandle reportDesign, Map context) {
        URL url;
        String imageUrl = imageUri;
        if (reportDesign != null && (url = reportDesign.findResource(imageUri, 1, context)) != null) {
            imageUrl = url.toExternalForm();
        }
        return imageUrl;
    }

    public static org.eclipse.birt.report.engine.layout.emitter.Image parseImage(IImageContent image, int imageSource, String uri, String mimeType, String extension) throws IOException {
        org.eclipse.birt.report.engine.layout.emitter.Image imageInfo = null;
        byte[] data = null;
        InputStream in = null;
        try {
            switch (imageSource) {
                case 0: 
                case 3: {
                    if (uri == null) break;
                    if (SvgFile.isSvg(uri)) {
                        try {
                            data = SvgFile.transSvgToArray(uri);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage());
                        }
                        break;
                    }
                    data = EmitterUtil.getNonSVGImageData(uri);
                    break;
                }
                case 1: 
                case 2: {
                    data = image.getData();
                    if (!SvgFile.isSvg(mimeType, uri, extension) || data == null) break;
                    in = new ByteArrayInputStream(data);
                    try {
                        data = SvgFile.transSvgToArray(in);
                        break;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage());
                    }
                }
            }
            imageInfo = new org.eclipse.birt.report.engine.layout.emitter.Image();
            if (data != null) {
                imageInfo.setInput(data);
                if (!imageInfo.check()) {
                    imageInfo.setData(null);
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (Exception t) {
                    logger.log(Level.WARNING, t.getMessage());
                }
            }
        }
        return imageInfo;
    }

    public static org.eclipse.birt.report.engine.layout.emitter.Image parseImage(byte[] imageData, String mimeType, String extension) throws IOException {
        if (imageData != null) {
            org.eclipse.birt.report.engine.layout.emitter.Image imageInfo = new org.eclipse.birt.report.engine.layout.emitter.Image();
            imageInfo.setInput(imageData);
            if (!imageInfo.check()) {
                imageInfo.setData(null);
            }
            return imageInfo;
        }
        return null;
    }

    public static String getHyperlinkUrl(IHyperlinkAction linkAction, IReportRunnable reportRunnable, IHTMLActionHandler actionHandler, IReportContext reportContext) {
        String systemId = reportRunnable == null ? null : reportRunnable.getReportName();
        Action action = new Action(systemId, linkAction);
        if (actionHandler != null) {
            return actionHandler.getURL((IAction)action, reportContext);
        }
        return linkAction.getHyperlink();
    }

    public static String parseColor(String color) {
        if ("transparent".equalsIgnoreCase(color) || color == null || color.length() == 0) {
            return null;
        }
        if (color.startsWith("#")) {
            return color.substring(1, Math.min(color.length(), 7));
        }
        if (color.equalsIgnoreCase("Black")) {
            return "000000";
        }
        if (color.equalsIgnoreCase("Gray")) {
            return "121212";
        }
        if (color.equalsIgnoreCase("White")) {
            return "ffffff";
        }
        if (color.equalsIgnoreCase("Red")) {
            return "ff0000";
        }
        if (color.equalsIgnoreCase("Green")) {
            return "00ff00";
        }
        if (color.equalsIgnoreCase("Yellow")) {
            return "ffff00";
        }
        if (color.equalsIgnoreCase("Blue")) {
            return "0000ff";
        }
        if (color.equalsIgnoreCase("Teal")) {
            return "008080";
        }
        if (color.equalsIgnoreCase("Aqua")) {
            return "00FFFF";
        }
        if (color.equalsIgnoreCase("Silver")) {
            return "C0C0C0";
        }
        if (color.equalsIgnoreCase("Navy")) {
            return "000080";
        }
        if (color.equalsIgnoreCase("Lime")) {
            return "00FF00";
        }
        if (color.equalsIgnoreCase("Olive")) {
            return "808000";
        }
        if (color.equalsIgnoreCase("Purple")) {
            return "800080";
        }
        if (color.equalsIgnoreCase("Fuchsia")) {
            return "FF00FF";
        }
        if (color.equalsIgnoreCase("Maroon")) {
            return "800000";
        }
        String[] values = color.substring(color.indexOf("(") + 1, color.length() - 1).split(",");
        String value = "";
        int i = 0;
        while (i < values.length) {
            try {
                String s = Integer.toHexString(Integer.parseInt(values[i].trim()));
                if (s.length() == 1) {
                    s = "0" + s;
                }
                value = String.valueOf(value) + s;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                value = null;
            }
            ++i;
        }
        return value;
    }

    public static int[] resizeTableColumn(int tableWidth, int[] tblColumns, int count, int totalAssigned) {
        block8: {
            int remainWidth;
            block6: {
                int average;
                block7: {
                    remainWidth = tableWidth - totalAssigned;
                    average = 0;
                    if (remainWidth <= 0) break block6;
                    if (count <= 0) break block7;
                    average = remainWidth / count;
                    int i = 0;
                    while (i < tblColumns.length) {
                        if (tblColumns[i] == -1) {
                            tblColumns[i] = average;
                            remainWidth -= average;
                        }
                        ++i;
                    }
                    if (remainWidth <= 0) break block8;
                    int n = tblColumns.length - 1;
                    tblColumns[n] = tblColumns[n] + remainWidth;
                    break block8;
                }
                if (tblColumns.length <= 0) break block8;
                average = remainWidth / tblColumns.length;
                int i = 0;
                while (i < tblColumns.length) {
                    int n = i++;
                    tblColumns[n] = tblColumns[n] + average;
                }
                break block8;
            }
            if (remainWidth <= 0 && count > 0) {
                int i = 0;
                while (i < tblColumns.length) {
                    if (tblColumns[i] == -1) {
                        tblColumns[i] = 0;
                    }
                    ++i;
                }
            }
        }
        return tblColumns;
    }

    private static class EmitterOutputStream
    extends FilterOutputStream {
        private boolean closeOutputStreamOnExit;

        public EmitterOutputStream(OutputStream out, boolean closeOutputStreamOnExit) {
            super(out);
            this.closeOutputStreamOnExit = closeOutputStreamOnExit;
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void close() throws IOException {
            try {
                this.flush();
            }
            catch (IOException iOException) {}
            if (this.closeOutputStreamOnExit) {
                this.out.close();
            }
        }
    }
}

