/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterPageTypeValidator
extends AbstractElementValidator {
    private static MasterPageTypeValidator instance = new MasterPageTypeValidator();

    public static MasterPageTypeValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        if (!(element instanceof MasterPage)) {
            return Collections.emptyList();
        }
        return this.doValidate(module, (MasterPage)element);
    }

    private List<SemanticException> doValidate(Module module, MasterPage toValidate) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        String type = toValidate.getStringProperty(module, "type");
        String height = toValidate.getStringProperty(module, "height");
        String width = toValidate.getStringProperty(module, "width");
        if ("custom".equalsIgnoreCase(type) && (StringUtil.isBlank(height) || StringUtil.isBlank(width))) {
            list.add(new SemanticError(toValidate, "Error.SemanticError.MISSING_PAGE_SIZE"));
        }
        return list;
    }
}

