/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedElementValidator
extends AbstractElementValidator {
    private static final String[] unSupportedElements = new String[]{"GraphicMasterPage", "FreeForm", "Line", "Rectangle"};
    public static final String NAME = "UnsupportedElementValidator";
    private static final UnsupportedElementValidator instance = new UnsupportedElementValidator();

    public static UnsupportedElementValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        String elementName = element.getElementName();
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        int i = 0;
        while (i < unSupportedElements.length) {
            if (unSupportedElements[i].equalsIgnoreCase(elementName)) {
                list.add(new SemanticError(element, "Error.SemanticError.UNSUPPORTED_ELEMENT", 1));
            }
            ++i;
        }
        return list;
    }
}

