/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ThemeStyleNameValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.LayoutModule;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.MultiViews;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.ContentIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContainerContextProviderImpl {
    protected ContainerContext focus = null;

    public ContainerContextProviderImpl(ContainerContext containerInfo) {
        if (containerInfo == null) {
            throw new IllegalArgumentException("The containerInfo of this context should not be null");
        }
        this.focus = containerInfo;
    }

    public final boolean canContain(Module module, String type) {
        if (type == null) {
            return false;
        }
        return this.canContain(module, MetaDataDictionary.getInstance().getElement(type));
    }

    public final boolean canContain(Module module, DesignElement element) {
        if (module != null && module.isReadOnly()) {
            return false;
        }
        List<SemanticException> errors = this.checkContainmentContext(module, element);
        return errors.isEmpty();
    }

    public boolean canContain(Module module, IElementDefn defn) {
        if (defn == null || module != null && module.isReadOnly()) {
            return false;
        }
        boolean retValue = this.canContainInRom(defn);
        if (!retValue) {
            return false;
        }
        if (this.focus.getElement().isRootIncludedByModule()) {
            return false;
        }
        if (!this.canContainTemplateElement(module, defn)) {
            return false;
        }
        if (this.focus.getElement().isVirtualElement() || this.focus.getElement().getExtendsName() != null) {
            return false;
        }
        if (this.focus.getElement() instanceof TableItem && this.focus.getElement().getBooleanProperty(module, "isSummaryTable") && this.focus.containerSlotID == 2) {
            return false;
        }
        ContainerContext containerInfo = this.focus;
        while (containerInfo != null) {
            DesignElement container = containerInfo.getElement();
            if (container instanceof ListingElement || container instanceof MasterPage) {
                List<SemanticException> errors = container.checkContent(module, this.focus, defn);
                return errors.isEmpty();
            }
            containerInfo = container.getContainerInfo();
        }
        return retValue;
    }

    public List<SemanticException> checkContainmentContext(Module module, DesignElement element) {
        List<Object> dimensions;
        if (element == null) {
            return Collections.emptyList();
        }
        boolean retValue = this.canContainInRom(element.getDefn());
        ContentException e = ContentExceptionFactory.createContentException(this.focus, element, "Error.ContentException.INVALID_CONTEXT_CONTAINMENT");
        List<SemanticException> errors = new ArrayList<SemanticException>();
        if (!retValue) {
            errors.add(e);
            return errors;
        }
        if (!this.canContainTemplateElement(module, element)) {
            errors.add(e);
            return errors;
        }
        if (this.focus.getElement().isRootIncludedByModule()) {
            errors.add(e);
            return errors;
        }
        if (this.focus.getElement().isVirtualElement() || this.focus.getElement().getExtendsName() != null) {
            errors.add(e);
            return errors;
        }
        if (this.focus.getElement() instanceof TableItem && this.focus.getElement().getBooleanProperty(module, "isSummaryTable") && this.focus.containerSlotID == 2) {
            errors.add(e);
            return errors;
        }
        if (this.focus.getElement() instanceof ReportItemTheme) {
            ReportItemTheme theme = (ReportItemTheme)this.focus.getElement();
            String type = theme.getType(theme.getRoot());
            String styleName = element.getName();
            IPredefinedStyle style = MetaDataDictionary.getInstance().getPredefinedStyle(styleName);
            if (StringUtil.isBlank(type) || style == null || !type.equals(style.getType())) {
                errors.add(e);
                return errors;
            }
            List<SemanticException> exceptions = ThemeStyleNameValidator.getInstance().validateForAddingStyle((AbstractThemeHandle)theme.getHandle(theme.getRoot()), styleName);
            if (exceptions != null && !exceptions.isEmpty()) {
                errors.addAll(exceptions);
                return errors;
            }
        }
        if (element instanceof Cube && module instanceof LayoutModule && (dimensions = element.getListProperty(module, "dimensions")) != null) {
            int i = 0;
            while (i < dimensions.size()) {
                List<Object> hierarchies;
                Dimension dimension = (Dimension)dimensions.get(i);
                String dimensionName = dimension.getStringProperty(module, "internalDimensionRef");
                if (dimensionName != null && ((hierarchies = dimension.getListProperty(module, "hierarchies")) == null || hierarchies.isEmpty())) {
                    ContentException exception = new ContentException(this.focus.getElement(), this.focus.getSlotID(), element, "Error.ContentException.SHARE_DIMENSION_NOT_EXIST", new String[]{dimensionName});
                    errors.add(exception);
                    return errors;
                }
                ++i;
            }
        }
        ContainerContext containerInfor = this.focus;
        while (containerInfor != null) {
            DesignElement container = containerInfor.getElement();
            if (container == element) {
                errors.add(e);
                return errors;
            }
            if ((container instanceof ListingElement || container instanceof MasterPage) && (errors = container.checkContent(module, this.focus, element)) != null && !errors.isEmpty()) {
                return errors;
            }
            containerInfor = container.getContainerInfo();
        }
        if ((this.focus.getElement() instanceof MultiViews || element instanceof MultiViews) && !this.checkMutliViews(module, element)) {
            errors.add(e);
            return errors;
        }
        if (!this.checkRecursiveShareBinding(element)) {
            errors.add(e);
            return errors;
        }
        if (element instanceof ReportItem) {
            ElementRefValue refCube;
            ElementRefValue refSet;
            ReportItem item = (ReportItem)element;
            DataSet dataSet = null;
            ElementPropertyDefn tmpPropDefn = item.getPropertyDefn("dataSet");
            if (tmpPropDefn != null && (refSet = (ElementRefValue)item.getProperty(null, "dataSet")) != null) {
                dataSet = (DataSet)module.resolveElement((DesignElement)item, refSet.getQualifiedReference(), (PropertyDefn)tmpPropDefn, null);
            }
            Cube cube = null;
            tmpPropDefn = item.getPropertyDefn("cube");
            if (tmpPropDefn != null && (refCube = (ElementRefValue)item.getProperty(null, "cube")) != null) {
                cube = (Cube)module.resolveElement((DesignElement)item, refCube.getQualifiedReference(), (PropertyDefn)tmpPropDefn, null);
            }
            if (!ContainerContext.isValidContainerment(module, this.focus.getElement(), item, dataSet, cube)) {
                errors.add(e);
                return errors;
            }
        }
        return Collections.emptyList();
    }

    private boolean checkMutliViews(Module module, DesignElement element) {
        DesignElement targetReportItem = null;
        targetReportItem = element instanceof MultiViews ? this.focus.getElement() : this.focus.getElement().getContainer();
        if (targetReportItem instanceof ReportItem) {
            ReportItem item = (ReportItem)targetReportItem;
            DataSet dataSet = (DataSet)item.getDataSetElement(module);
            Cube cube = (Cube)item.getCubeElement(module);
            if (dataSet != null || cube != null) {
                ContentIterator iter = new ContentIterator(module, item);
                while (iter.hasNext()) {
                    DesignElement child = iter.next();
                    if (!(child instanceof ReportItem)) continue;
                    ReportItem childItem = (ReportItem)child;
                    DataSet childDataSet = (DataSet)childItem.getDataSetElement(module);
                    Cube childCube = (Cube)childItem.getCubeElement(module);
                    if (childDataSet == null && childCube == null || (childDataSet == dataSet || childDataSet == null) && (childCube == cube || childCube == null)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean canContainInRom(IElementDefn defn) {
        if (!this.focus.canContainInRom(defn)) {
            return false;
        }
        String name = defn.getName();
        if ("TemplateDataSet".equals(name) || "TemplateReportItem".equals(name) || "TemplateElement".equals(name)) {
            return true;
        }
        return this.focus.getContentCount(this.focus.getElement().getRoot()) <= 0 || this.focus.isContainerMultipleCardinality() && !(this.focus.getElement() instanceof MultiViews);
    }

    private boolean canContainTemplateElement(Module module, DesignElement element) {
        IElementDefn defn = MetaDataDictionary.getInstance().getElement("TemplateElement");
        if (element instanceof TemplateElement) {
            return this.canContainTemplateElement(module, defn);
        }
        ContentIterator contents = new ContentIterator(module, element);
        while (contents.hasNext()) {
            DesignElement content = contents.next();
            if (!(content instanceof TemplateElement)) continue;
            return this.canContainTemplateElement(module, defn);
        }
        return true;
    }

    private boolean canContainTemplateElement(Module module, IElementDefn defn) {
        if (defn != null && defn.isKindOf(MetaDataDictionary.getInstance().getElement("TemplateElement"))) {
            ContainerContext containerInfo = this.focus;
            while (containerInfo != null) {
                DesignElement container = containerInfo.getElement();
                if (container instanceof Module && containerInfo.getSlotID() == 5 || container instanceof Library) {
                    return false;
                }
                containerInfo = container.getContainerInfo();
            }
            if (module instanceof Library) {
                return false;
            }
        }
        return true;
    }

    private boolean checkRecursiveShareBinding(DesignElement element) {
        Module root;
        DesignElement focusElement = this.focus.getElement();
        if (focusElement == (root = focusElement.getRoot()) || !(element instanceof ReportItem) || element instanceof ExtendedItem) {
            return true;
        }
        DesignElement bindingElement = null;
        ElementRefValue ref = (ElementRefValue)element.getProperty(root, "dataBindingRef");
        if (ref != null && ref.isResolved()) {
            bindingElement = ref.getElement();
        }
        while (focusElement != root) {
            if (focusElement == bindingElement) {
                return false;
            }
            if (focusElement instanceof ReportItem && !(focusElement instanceof ExtendedItem) && (ref = (ElementRefValue)focusElement.getProperty(root, "dataBindingRef")) != null && ref.isResolved() && ref.getElement() == element) {
                return false;
            }
            focusElement = focusElement.getContainer();
        }
        return true;
    }
}

