/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class TabularDimensionPropSearchStrategy
extends PropertySearchStrategy {
    private static final TabularDimensionPropSearchStrategy instance = new TabularDimensionPropSearchStrategy();

    protected TabularDimensionPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    protected Object getPropertyFromSelf(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (element.getContainer() instanceof Module) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        if ("internalDimensionRef".equalsIgnoreCase(prop.getName()) || prop.getTypeCode() == 23) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        Dimension tmpDimension = TabularDimensionPropSearchStrategy.getSharedDimension(module, element);
        if (tmpDimension == null || !(tmpDimension.getContainer() instanceof Module)) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        return super.getPropertyFromSelf(module, tmpDimension, prop);
    }

    public static Dimension getSharedDimension(Module root, DesignElement element) {
        if (!(element instanceof TabularDimension)) {
            return null;
        }
        ElementRefValue tmpRef = (ElementRefValue)element.getLocalProperty(root, "internalDimensionRef");
        if (tmpRef == null) {
            return null;
        }
        return (Dimension)tmpRef.getElement();
    }
}

