/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.parser.AbstractPropertyState;
import org.eclipse.birt.report.model.parser.ContentNodeState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.EncryptedPropertyState;
import org.eclipse.birt.report.model.parser.ExpressionState;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.SimplePropertyListState;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.parser.TextPropertyState;
import org.eclipse.birt.report.model.parser.XmlPropertyState;
import org.eclipse.birt.report.model.parser.treebuild.ContentNode;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;

public class PropertyContentState
extends AbstractParseState {
    protected ModuleParserHandler handler = null;
    protected DesignElement element = null;
    protected ContentNode parentNode = null;
    protected String name = null;
    protected String tagName = null;
    protected boolean valid = true;
    protected Map attributes = new LinkedHashMap(6);

    public PropertyContentState(ModuleParserHandler theHandler, DesignElement element, String tagName, ContentNode parent) {
        this.handler = theHandler;
        this.tagName = tagName;
        this.element = element;
        this.parentNode = parent;
    }

    public final void parseAttrs(Attributes attrs) throws XMLParserException {
        super.parseAttrs(attrs);
        this.name = attrs.getValue("name");
        if (StringUtil.isBlank(this.name)) {
            DesignParserException e = new DesignParserException("Error.DesignParserException.NAME_REQUIRED");
            this.handler.getErrorHandler().semanticError(e);
            this.valid = false;
            return;
        }
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getQName(i);
            String value = attrs.getValue(i);
            this.attributes.put(name, value);
            ++i;
        }
    }

    public XMLParserHandler getHandler() {
        return this.handler;
    }

    public final AbstractParseState jumpTo() {
        if (!this.valid) {
            return new AnyElementState(this.handler);
        }
        AbstractParseState state = null;
        int maxJump = 5;
        state = this.generalJumpTo();
        int i = 1;
        while (i < maxJump) {
            if (state != null && state.jumpTo() != null) {
                state = state.jumpTo();
            }
            ++i;
        }
        if (state != null) {
            return state;
        }
        return super.jumpTo();
    }

    protected final AbstractParseState generalJumpTo() {
        ElementPropertyDefn defn = this.element.getPropertyDefn(this.name);
        if (defn == null) {
            return new ContentNodeState(this.tagName, this.handler, this.parentNode, this.attributes);
        }
        AbstractPropertyState state = null;
        if (this.tagName.equalsIgnoreCase("property")) {
            state = new PropertyState(this.handler, this.element);
            state.setName(this.name);
        }
        if (this.tagName.equalsIgnoreCase("list-property")) {
            state = new ListPropertyState(this.handler, this.element);
            state.setName(this.name);
        }
        if (this.tagName.equalsIgnoreCase("expression")) {
            state = new ExpressionState(this.handler, this.element);
            state.setName(this.name);
        }
        if (this.tagName.equalsIgnoreCase("xml-property")) {
            state = new XmlPropertyState(this.handler, this.element);
            state.setName(this.name);
        }
        if (this.tagName.equalsIgnoreCase("structure")) {
            state = new StructureState(this.handler, this.element);
            state.setName(this.name);
        }
        if (this.tagName.equalsIgnoreCase("method")) {
            state = new PropertyState(this.handler, this.element);
            state.setName(this.name);
        }
        if (this.tagName.equalsIgnoreCase("text-property")) {
            state = new TextPropertyState(this.handler, this.element);
            state.setName(this.name);
            ((TextPropertyState)state).setKeyValue((String)this.attributes.get("key"));
        }
        if (this.tagName.equalsIgnoreCase("html-property")) {
            state = new TextPropertyState(this.handler, this.element);
            state.setName(this.name);
        }
        if (this.tagName.equalsIgnoreCase("encrypted-property")) {
            state = new EncryptedPropertyState(this.handler, this.element);
            state.setName(this.name);
        }
        if (this.tagName.equalsIgnoreCase("simple-property-list")) {
            state = new SimplePropertyListState(this.handler, this.element);
            state.setName(this.name);
        }
        return state;
    }
}

