/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.report;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefn;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.reporting.engine.BirtEngine;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.DataSourceHelper;

public class ReportHelper {
    protected static final Log log = LogFactory.getLog(ReportHelper.class);

    public static IReportRunnable getReport(String reportPath) {
        try {
            return BirtEngine.getBirtEngine().openReportDesign(reportPath);
        }
        catch (BirtException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public static IReportRunnable getReport(InputStream stream) {
        try {
            return BirtEngine.getBirtEngine().openReportDesign(stream);
        }
        catch (BirtException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public static IReportRunnable getNuxeoReport(InputStream stream) {
        return ReportHelper.getNuxeoReport(stream, ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName());
    }

    public static Map<String, String> getReportMetaData(InputStream stream) {
        ReportDesignHandle designHandle;
        IDesignEngine dEngine = BirtEngine.getBirtDesignEngine();
        SessionHandle sh = dEngine.newSessionHandle(ULocale.ENGLISH);
        try {
            designHandle = sh.openDesign((String)null, stream);
        }
        catch (BirtException e) {
            throw new NuxeoException((Throwable)e);
        }
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("title", designHandle.getTitle());
        meta.put("author", designHandle.getAuthor());
        meta.put("description", designHandle.getDescription());
        meta.put("displayName", designHandle.getDisplayName());
        try {
            sh.closeAll(false);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return meta;
    }

    public static IReportRunnable getNuxeoReport(InputStream stream, String repositoryName) {
        IReportRunnable modifiedReport;
        ReportDesignHandle designHandle;
        IDesignEngine dEngine = BirtEngine.getBirtDesignEngine();
        SessionHandle sh = dEngine.newSessionHandle(ULocale.ENGLISH);
        try {
            designHandle = sh.openDesign((String)null, stream);
        }
        catch (BirtException e) {
            throw new NuxeoException((Throwable)e);
        }
        String dsName = DataSourceHelper.getDataSourceRepositoryJNDIName((String)repositoryName);
        for (OdaDataSourceHandle dsh : designHandle.getDataSources()) {
            OdaDataSource ds = (OdaDataSource)dsh.getElement();
            ds.setProperty("odaJndiName", (Object)DataSourceHelper.getDataSourceJNDIName((String)dsName));
        }
        try {
            modifiedReport = BirtEngine.getBirtEngine().openReportDesign(designHandle);
        }
        catch (BirtException e) {
            throw new NuxeoException((Throwable)e);
        }
        try {
            sh.closeAll(false);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return modifiedReport;
    }

    public static List<IParameterDefn> getReportParameter(IReportRunnable report) {
        ArrayList<IParameterDefn> params = new ArrayList<IParameterDefn>();
        IGetParameterDefinitionTask task = BirtEngine.getBirtEngine().createGetParameterDefinitionTask(report);
        for (Object paramDefn : task.getParameterDefns(false)) {
            if (!(paramDefn instanceof IParameterDefn)) continue;
            IParameterDefn param = (IParameterDefn)paramDefn;
            params.add(param);
        }
        return params;
    }
}

