/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.reporting.widget;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.LeafFaceletHandler;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.plugins.AbstractWidgetTypeHandler;
import org.nuxeo.ecm.platform.reporting.api.ReportInstance;
import org.nuxeo.ecm.platform.reporting.api.ReportModel;
import org.nuxeo.ecm.platform.reporting.report.ReportParameter;

public class HtmlReportParameterWidgetTypeHandler
extends AbstractWidgetTypeHandler {
    private static final long serialVersionUID = 1L;

    public FaceletHandler getFaceletHandler(FaceletContext ctx, TagConfig tagConfig, Widget widget, FaceletHandler[] subHandlers) throws WidgetException {
        List reportParams;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, tagConfig);
        String mode = widget.getMode();
        String widgetId = widget.getId();
        String docVar = RenderVariables.globalVariables.value.name();
        DocumentModel doc = (DocumentModel)ctx.getAttribute(docVar);
        ReportInstance reportInstance = (ReportInstance)doc.getAdapter(ReportInstance.class);
        try {
            if (reportInstance != null) {
                reportParams = reportInstance.getReportParameters();
            } else {
                ReportModel reportModel = (ReportModel)doc.getAdapter(ReportModel.class);
                reportParams = reportModel.getReportParameters();
            }
        }
        catch (IOException e) {
            throw new WidgetException("Unable to resolve report parameters", (Throwable)e);
        }
        TagAttributes attributes = helper.getTagAttributes(widgetId, widget);
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        FaceletHandler[] handlers = new FaceletHandler[reportParams.size() * 4];
        int idx = 0;
        int row = 0;
        for (ReportParameter param : reportParams) {
            ComponentHandler pValue;
            ArrayList<TagAttribute> attrs = new ArrayList<TagAttribute>();
            attrs.add(helper.createIdAttribute("paramName" + idx));
            attrs.add(helper.createAttribute("value", param.getName()));
            ComponentHandler pName = helper.getHtmlComponentHandler(FaceletHandlerHelper.getTagAttributes(attrs), (FaceletHandler)leaf, "javax.faces.HtmlOutputText", null);
            ArrayList<TagAttribute> attrs2 = new ArrayList<TagAttribute>();
            attrs2.add(helper.createIdAttribute("paramValue" + idx));
            String globalEL = attributes.get("value").getValue();
            String locator = "[" + row + "]['pValue']}";
            String value = globalEL.replace("}", locator);
            if (value == null) {
                value = "unset";
            }
            if ("edit".equals(mode) && param.isEditable()) {
                attrs2.add(helper.createAttribute("value", value));
                pValue = helper.getHtmlComponentHandler(FaceletHandlerHelper.getTagAttributes(attrs2), (FaceletHandler)leaf, "javax.faces.HtmlInputText", null);
            } else {
                if (!param.isEditable()) {
                    attrs2.add(helper.createAttribute("value", param.getStringValue()));
                } else {
                    attrs2.add(helper.createAttribute("value", value));
                }
                pValue = helper.getHtmlComponentHandler(FaceletHandlerHelper.getTagAttributes(attrs2), (FaceletHandler)leaf, "javax.faces.HtmlOutputText", null);
            }
            ArrayList<TagAttribute> attrs3 = new ArrayList<TagAttribute>();
            attrs3.add(helper.createIdAttribute("spacer1" + idx));
            attrs3.add(helper.createAttribute("value", "&nbsp;:&nbsp;"));
            attrs3.add(helper.createAttribute("escape", "false"));
            ComponentHandler spacer = helper.getHtmlComponentHandler(FaceletHandlerHelper.getTagAttributes(attrs3), (FaceletHandler)leaf, "javax.faces.HtmlOutputText", null);
            ArrayList<TagAttribute> attrs4 = new ArrayList<TagAttribute>();
            attrs4.add(helper.createIdAttribute("spacer2" + idx));
            attrs4.add(helper.createAttribute("value", "<br/>"));
            attrs4.add(helper.createAttribute("escape", "false"));
            ComponentHandler spacer2 = helper.getHtmlComponentHandler(FaceletHandlerHelper.getTagAttributes(attrs4), (FaceletHandler)leaf, "javax.faces.HtmlOutputText", null);
            handlers[idx] = pName;
            handlers[idx + 1] = spacer;
            handlers[idx + 2] = pValue;
            handlers[idx + 3] = spacer2;
            idx += 4;
            ++row;
        }
        return new CompositeFaceletHandler(handlers);
    }
}

