/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private FileUtils() {
    }

    public static CmisObject getObject(String pathOrIdOfObject, Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session must be set!");
        }
        if (pathOrIdOfObject == null || pathOrIdOfObject.length() == 0) {
            throw new IllegalArgumentException("pathOrIdOfObject must be set!");
        }
        CmisObject result = null;
        result = pathOrIdOfObject.charAt(0) == '/' ? session.getObjectByPath(pathOrIdOfObject) : session.getObject(pathOrIdOfObject);
        return result;
    }

    public static Folder getFolder(String pathOrIdOfObject, Session session) {
        CmisObject folder = FileUtils.getObject(pathOrIdOfObject, session);
        if (folder instanceof Folder) {
            return (Folder)folder;
        }
        throw new IllegalArgumentException("Object is not a folder!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDocumentFromFile(String parentIdOrPath, File file, String type, VersioningState versioningState, Session session) throws FileNotFoundException {
        if (type == null) {
            type = BaseTypeId.CMIS_DOCUMENT.value();
        }
        Folder parentFolder = FileUtils.getFolder(parentIdOrPath, session);
        String name = file.getName();
        String mimetype = MimeTypes.getMIMEType((File)file);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", name);
        FileInputStream stream = new FileInputStream(file);
        ContentStreamImpl contentStream = new ContentStreamImpl(name, BigInteger.valueOf(file.length()), mimetype, (InputStream)stream);
        try {
            Document document = parentFolder.createDocument(properties, (ContentStream)contentStream, versioningState);
            return document;
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException ioe) {
                    throw new CmisRuntimeException("Cannot close source stream!", (Throwable)ioe);
                }
            }
        }
    }

    public static Document createTextDocument(String parentIdOrPath, String name, String content, String type, VersioningState versioningState, Session session) {
        if (type == null) {
            type = BaseTypeId.CMIS_DOCUMENT.value();
        }
        Folder parentFolder = FileUtils.getFolder(parentIdOrPath, session);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", name);
        byte[] contentBytes = new byte[]{};
        if (content != null) {
            try {
                contentBytes = content.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                contentBytes = content.getBytes();
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(contentBytes);
        ContentStreamImpl contentStream = new ContentStreamImpl(name, BigInteger.valueOf(contentBytes.length), "text/plain", (InputStream)bais);
        return parentFolder.createDocument(properties, (ContentStream)contentStream, versioningState);
    }

    public static Folder createFolder(Folder parentFolder, String name, String type) {
        if (type == null) {
            type = BaseTypeId.CMIS_FOLDER.value();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", name);
        return parentFolder.createFolder(properties);
    }

    public static Folder createFolder(String parentIdOrPath, String name, String type, Session session) {
        Folder parentFolder = FileUtils.getFolder(parentIdOrPath, session);
        if (type == null) {
            type = BaseTypeId.CMIS_FOLDER.value();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", name);
        return parentFolder.createFolder(properties);
    }

    public static void download(Document doc, String destinationPath) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(destinationPath);
        BufferedOutputStream out = new BufferedOutputStream(fileStream);
        FileUtils.copyStream(doc.getContentStream().getStream(), out);
        out.close();
    }

    public static void download(String docIdOrPath, String destinationPath, Session session) throws IOException {
        CmisObject doc = FileUtils.getObject(docIdOrPath, session);
        if (!(doc instanceof Document)) {
            throw new IllegalArgumentException("Object is not a document!");
        }
        FileUtils.download((Document)doc, destinationPath);
    }

    static void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        byte[] buffer = new byte[49152];
        int bytesRead = 0;
        while ((bytesRead = inStream.read(buffer, 0, buffer.length)) > 0) {
            outStream.write(buffer, 0, bytesRead);
        }
    }

    public static void delete(String pathOrIdOfObject, Session session) {
        CmisObject object = FileUtils.getObject(pathOrIdOfObject, session);
        if (object instanceof Folder) {
            ((Folder)object).deleteTree(true, UnfileObject.DELETE, true);
        } else {
            object.delete(true);
        }
    }

    public static void printProperties(CmisObject object) {
        FileUtils.printProperties(object, System.out);
    }

    public static void printProperties(CmisObject object, PrintStream out) {
        for (Property prop : object.getProperties()) {
            FileUtils.printProperty(prop, out);
        }
    }

    public static void printProperty(Property<?> prop) {
        FileUtils.printProperty(prop, System.out);
    }

    public static void printProperty(Property<?> prop, PrintStream out) {
        out.println(prop.getId() + ": " + prop.getValuesAsString());
    }
}

