/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdOutputStream.class);
    private static final int MAX_GROW = 0xA00000;
    private static final int DEFAULT_THRESHOLD = 0x400000;
    private static final String ALGORITHM = "AES";
    private static final String MODE = "CTR";
    private static final String PADDING = "PKCS5Padding";
    private static final String TRANSFORMATION = "AES/CTR/PKCS5Padding";
    private static final int KEY_SIZE = 128;
    private final File tempDir;
    private final int memoryThreshold;
    private final long maxContentSize;
    private final boolean encrypt;
    private byte[] buf = null;
    private int bufSize = 0;
    private long size = 0L;
    private File tempFile;
    private OutputStream tmpStream;
    private Key key;
    private byte[] iv;

    public ThresholdOutputStream(File tempDir, int memoryThreshold, long maxContentSize) {
        this(65536, tempDir, memoryThreshold, maxContentSize, false);
    }

    public ThresholdOutputStream(File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        this(65536, tempDir, memoryThreshold, maxContentSize, encrypt);
    }

    public ThresholdOutputStream(int initSize, File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        if (initSize < 0) {
            throw new IllegalArgumentException("Negative initial size: " + initSize);
        }
        this.tempDir = tempDir;
        this.memoryThreshold = memoryThreshold < 0 ? 0x400000 : memoryThreshold;
        this.maxContentSize = maxContentSize;
        this.encrypt = encrypt;
        this.buf = new byte[initSize];
    }

    private void expand(int nextBufferSize) throws IOException {
        if (this.bufSize + nextBufferSize <= this.buf.length) {
            return;
        }
        if (this.bufSize + nextBufferSize > this.memoryThreshold) {
            if (this.tmpStream == null) {
                this.tempFile = File.createTempFile("opencmis", null, this.tempDir);
                if (this.encrypt) {
                    Cipher cipher;
                    try {
                        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
                        keyGenerator.init(128);
                        this.key = keyGenerator.generateKey();
                        cipher = Cipher.getInstance(TRANSFORMATION);
                        cipher.init(1, this.key);
                        this.iv = cipher.getIV();
                    }
                    catch (Exception e) {
                        throw new IOException("Cannot initialize encryption cipher!", e);
                    }
                    this.tmpStream = new BufferedOutputStream(new CipherOutputStream(new FileOutputStream(this.tempFile), cipher));
                } else {
                    this.tmpStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
                }
            }
            this.tmpStream.write(this.buf, 0, this.bufSize);
            if (this.buf.length != this.memoryThreshold) {
                this.buf = new byte[this.memoryThreshold];
            }
            this.bufSize = 0;
            return;
        }
        int newSize = (this.bufSize + nextBufferSize) * 2 < 0xA00000 ? (this.bufSize + nextBufferSize) * 2 : this.buf.length + nextBufferSize + 0xA00000;
        byte[] newbuf = new byte[newSize];
        System.arraycopy(this.buf, 0, newbuf, 0, this.bufSize);
        this.buf = newbuf;
    }

    public long getSize() {
        return this.size;
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int len) throws IOException {
        try {
            if (len == 0) {
                return;
            }
            if (this.maxContentSize > -1L && this.size + (long)len > this.maxContentSize) {
                this.destroy();
                throw new CmisConstraintException("Content too big!");
            }
            this.expand(len);
            System.arraycopy(buffer, offset, this.buf, this.bufSize, len);
            this.bufSize += len;
            this.size += (long)len;
        }
        catch (IOException ioe) {
            this.destroy();
            throw ioe;
        }
    }

    public void write(int oneByte) throws IOException {
        try {
            if (this.maxContentSize > -1L && this.size + 1L > this.maxContentSize) {
                this.destroy();
                throw new CmisConstraintException("Content too big!");
            }
            if (this.bufSize == this.buf.length) {
                this.expand(1);
            }
            this.buf[this.bufSize++] = (byte)oneByte;
            ++this.size;
        }
        catch (IOException ioe) {
            this.destroy();
            throw ioe;
        }
    }

    public void flush() throws IOException {
        if (this.tmpStream != null) {
            try {
                if (this.bufSize > 0) {
                    this.tmpStream.write(this.buf, 0, this.bufSize);
                    this.bufSize = 0;
                }
                this.tmpStream.flush();
            }
            catch (IOException ioe) {
                this.destroy();
                throw ioe;
            }
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.tmpStream != null) {
            this.tmpStream.close();
        }
    }

    public void destroy() {
        boolean isDeleted;
        try {
            if (this.tmpStream != null) {
                this.tmpStream.flush();
                this.tmpStream.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.tempFile != null && !(isDeleted = this.tempFile.delete())) {
            LOG.warn("Temp file " + this.tempFile.getAbsolutePath() + " could not be deleted!");
        }
        this.buf = null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.tmpStream != null) {
            this.close();
            this.buf = null;
            return new InternalTempFileInputStream();
        }
        return new InternalBufferInputStream();
    }

    static /* synthetic */ byte[] access$202(ThresholdOutputStream x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    private class InternalTempFileInputStream
    extends ThresholdInputStream {
        private final Cipher cipher;
        private BufferedInputStream stream;
        private boolean isDeleted;
        private boolean isClosed;

        public InternalTempFileInputStream() throws IOException {
            this.isDeleted = false;
            this.isClosed = false;
            if (ThresholdOutputStream.this.encrypt) {
                try {
                    this.cipher = Cipher.getInstance(ThresholdOutputStream.TRANSFORMATION);
                    this.cipher.init(2, ThresholdOutputStream.this.key, new IvParameterSpec(ThresholdOutputStream.this.iv));
                }
                catch (Exception e) {
                    this.delete();
                    throw new IOException("Cannot initialize decryption cipher!", e);
                }
            } else {
                this.cipher = null;
            }
            this.openStream();
        }

        protected void openStream() throws FileNotFoundException {
            this.stream = ThresholdOutputStream.this.encrypt ? new BufferedInputStream(new CipherInputStream(new FileInputStream(ThresholdOutputStream.this.tempFile), this.cipher), ThresholdOutputStream.this.memoryThreshold) : new BufferedInputStream(new FileInputStream(ThresholdOutputStream.this.tempFile), ThresholdOutputStream.this.memoryThreshold);
        }

        public boolean isInMemory() {
            return false;
        }

        public File getTemporaryFile() {
            return ThresholdOutputStream.this.tempFile;
        }

        public void rewind() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is already closed!");
            }
            this.stream.close();
            this.openStream();
        }

        public int available() throws IOException {
            if (this.isClosed) {
                return 0;
            }
            return this.stream.available();
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }

        public void mark(int readlimit) {
            if (!this.isClosed) {
                this.stream.mark(readlimit);
            }
        }

        public void reset() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is already closed!");
            }
            this.stream.reset();
        }

        public long skip(long n) throws IOException {
            if (this.isClosed) {
                return -1L;
            }
            return this.stream.skip(n);
        }

        public int read() throws IOException {
            if (this.isClosed) {
                return -1;
            }
            int b = this.stream.read();
            if (b == -1) {
                this.delete();
            }
            return b;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.isClosed) {
                return -1;
            }
            int n = super.read(b, off, len);
            if (n == -1) {
                this.delete();
            }
            return n;
        }

        public void close() throws IOException {
            this.delete();
        }

        protected void delete() {
            if (!this.isClosed) {
                try {
                    this.stream.close();
                    this.isClosed = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.isDeleted) {
                this.isDeleted = ThresholdOutputStream.this.tempFile.delete();
                if (!this.isDeleted) {
                    LOG.warn("Temp file " + ThresholdOutputStream.this.tempFile.getAbsolutePath() + " could not be deleted!");
                }
            }
        }
    }

    private class InternalBufferInputStream
    extends ThresholdInputStream {
        private int pos;
        private int mark;

        private InternalBufferInputStream() {
            this.pos = 0;
            this.mark = -1;
        }

        public boolean isInMemory() {
            return true;
        }

        public byte[] getBytes() {
            return ThresholdOutputStream.this.buf;
        }

        public void rewind() throws IOException {
            if (ThresholdOutputStream.this.buf == null) {
                throw new IOException("Stream is already closed!");
            }
            this.pos = 0;
            this.mark = -1;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int readlimit) {
            if (ThresholdOutputStream.this.buf != null) {
                this.mark = this.pos;
            }
        }

        public void reset() throws IOException {
            if (this.mark < 0) {
                throw new IOException("Reset not possible.");
            }
            this.pos = this.mark;
        }

        public int available() {
            if (ThresholdOutputStream.this.buf == null) {
                return 0;
            }
            return ThresholdOutputStream.this.bufSize - this.pos;
        }

        public int read() {
            return this.pos < ThresholdOutputStream.this.bufSize && ThresholdOutputStream.this.buf != null ? ThresholdOutputStream.this.buf[this.pos++] & 0xFF : -1;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            if (this.pos >= ThresholdOutputStream.this.bufSize || ThresholdOutputStream.this.buf == null) {
                return -1;
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos + len > ThresholdOutputStream.this.bufSize) {
                len = ThresholdOutputStream.this.bufSize - this.pos;
            }
            System.arraycopy(ThresholdOutputStream.this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public long skip(long n) {
            if (ThresholdOutputStream.this.buf == null) {
                return -1L;
            }
            if (n <= 0L) {
                return 0L;
            }
            if ((long)this.pos + n > (long)ThresholdOutputStream.this.bufSize) {
                n = ThresholdOutputStream.this.bufSize - this.pos;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }

        public void close() throws IOException {
            ThresholdOutputStream.access$202(ThresholdOutputStream.this, null);
            this.mark = -1;
        }
    }

    public abstract class ThresholdInputStream
    extends InputStream {
        public abstract boolean isInMemory();

        public File getTemporaryFile() {
            return null;
        }

        public byte[] getBytes() {
            return null;
        }

        public long length() {
            return ThresholdOutputStream.this.size;
        }

        public abstract void rewind() throws IOException;
    }
}

