/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.PaddingException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyEncrypted;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.utils.EqualsUtil;

public abstract class AbstractID3v2Frame
extends AbstractTagFrame
implements TagTextField {
    protected static final String TYPE_FRAME = "frame";
    protected static final String TYPE_FRAME_SIZE = "frameSize";
    protected static final String UNSUPPORTED_ID = "Unsupported";
    protected String identifier = "";
    protected int frameSize;
    private String loggingFilename = "";
    StatusFlags statusFlags = null;
    EncodingFlags encodingFlags = null;

    protected abstract int getFrameIdSize();

    protected abstract int getFrameSizeSize();

    protected abstract int getFrameHeaderSize();

    protected AbstractID3v2Frame() {
    }

    public AbstractID3v2Frame(AbstractID3v2Frame frame) {
        super(frame);
    }

    public AbstractID3v2Frame(AbstractID3v2FrameBody body) {
        this.frameBody = body;
        this.frameBody.setHeader(this);
    }

    public AbstractID3v2Frame(String identifier) {
        logger.info("Creating empty frame of type" + identifier);
        this.identifier = identifier;
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
            this.frameBody = (AbstractTagFrameBody)c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            logger.severe(cnfe.getMessage());
            this.frameBody = new FrameBodyUnsupported(identifier);
        }
        catch (InstantiationException ie) {
            logger.log(Level.SEVERE, "InstantiationException:" + identifier, ie);
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.SEVERE, "IllegalAccessException:" + identifier, iae);
            throw new RuntimeException(iae);
        }
        this.frameBody.setHeader(this);
        if (this instanceof ID3v24Frame) {
            this.frameBody.setTextEncoding(TagOptionSingleton.getInstance().getId3v24DefaultTextEncoding());
        } else if (this instanceof ID3v23Frame) {
            this.frameBody.setTextEncoding(TagOptionSingleton.getInstance().getId3v23DefaultTextEncoding());
        }
        logger.info("Created empty frame of type" + identifier);
    }

    protected String getLoggingFilename() {
        return this.loggingFilename;
    }

    protected void setLoggingFilename(String loggingFilename) {
        this.loggingFilename = loggingFilename;
    }

    public String getId() {
        return this.getIdentifier();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void copyContent(TagField field) {
    }

    protected AbstractID3v2FrameBody readEncryptedBody(String identifier, ByteBuffer byteBuffer, int frameSize) throws InvalidFrameException, InvalidDataTypeException {
        try {
            FrameBodyEncrypted frameBody = new FrameBodyEncrypted(identifier, byteBuffer, frameSize);
            frameBody.setHeader(this);
            return frameBody;
        }
        catch (InvalidTagException ite) {
            throw new InvalidDataTypeException(ite);
        }
    }

    protected boolean isPadding(byte[] buffer) {
        return buffer[0] == 0 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0;
    }

    protected AbstractID3v2FrameBody readBody(String identifier, ByteBuffer byteBuffer, int frameSize) throws InvalidFrameException, InvalidDataTypeException {
        AbstractID3v2FrameBody frameBody;
        logger.finest("Creating framebody:start");
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
            Class[] constructorParameterTypes = new Class[]{Class.forName("java.nio.ByteBuffer"), Integer.TYPE};
            Object[] constructorParameterValues = new Object[]{byteBuffer, frameSize};
            Constructor<?> construct = c.getConstructor(constructorParameterTypes);
            frameBody = (AbstractID3v2FrameBody)construct.newInstance(constructorParameterValues);
        }
        catch (ClassNotFoundException cex) {
            logger.info(this.getLoggingFilename() + ":" + "Identifier not recognised:" + identifier + " using FrameBodyUnsupported");
            try {
                frameBody = new FrameBodyUnsupported(byteBuffer, frameSize);
            }
            catch (InvalidFrameException ife) {
                throw ife;
            }
            catch (InvalidTagException te) {
                throw new InvalidFrameException(te.getMessage());
            }
        }
        catch (InvocationTargetException ite) {
            logger.severe(this.getLoggingFilename() + ":" + "An error occurred within abstractID3v2FrameBody for identifier:" + identifier + ":" + ite.getCause().getMessage());
            if (ite.getCause() instanceof Error) {
                throw (Error)ite.getCause();
            }
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            if (ite.getCause() instanceof InvalidFrameException) {
                throw (InvalidFrameException)ite.getCause();
            }
            if (ite.getCause() instanceof InvalidDataTypeException) {
                throw (InvalidDataTypeException)ite.getCause();
            }
            throw new InvalidFrameException(ite.getCause().getMessage());
        }
        catch (NoSuchMethodException sme) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + ":" + "No such method:" + sme.getMessage(), sme);
            throw new RuntimeException(sme.getMessage());
        }
        catch (InstantiationException ie) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + ":" + "Instantiation exception:" + ie.getMessage(), ie);
            throw new RuntimeException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.SEVERE, this.getLoggingFilename() + ":" + "Illegal access exception :" + iae.getMessage(), iae);
            throw new RuntimeException(iae.getMessage());
        }
        logger.finest(this.getLoggingFilename() + ":" + "Created framebody:end" + frameBody.getIdentifier());
        frameBody.setHeader(this);
        return frameBody;
    }

    protected String readIdentifier(ByteBuffer byteBuffer) throws PaddingException, InvalidFrameException {
        byte[] buffer = new byte[this.getFrameIdSize()];
        if (byteBuffer.position() + this.getFrameHeaderSize() >= byteBuffer.limit()) {
            logger.warning(this.getLoggingFilename() + ":" + "No space to find another frame:");
            throw new InvalidFrameException(this.getLoggingFilename() + ":" + "No space to find another frame");
        }
        byteBuffer.get(buffer, 0, this.getFrameIdSize());
        if (this.isPadding(buffer)) {
            throw new PaddingException(this.getLoggingFilename() + ":only padding found");
        }
        this.identifier = new String(buffer);
        logger.fine(this.getLoggingFilename() + ":" + "Identifier is" + this.identifier);
        return this.identifier;
    }

    protected AbstractID3v2FrameBody readBody(String identifier, AbstractID3v2FrameBody body) throws InvalidFrameException {
        AbstractID3v2FrameBody frameBody;
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + identifier);
            Class[] constructorParameterTypes = new Class[]{body.getClass()};
            Object[] constructorParameterValues = new Object[]{body};
            Constructor<?> construct = c.getConstructor(constructorParameterTypes);
            frameBody = (AbstractID3v2FrameBody)construct.newInstance(constructorParameterValues);
        }
        catch (ClassNotFoundException cex) {
            logger.info("Identifier not recognised:" + identifier + " unable to create framebody");
            throw new InvalidFrameException("FrameBody" + identifier + " does not exist");
        }
        catch (NoSuchMethodException sme) {
            logger.log(Level.SEVERE, "No such method:" + sme.getMessage(), sme);
            throw new InvalidFrameException("FrameBody" + identifier + " does not have a constructor that takes:" + body.getClass().getName());
        }
        catch (InvocationTargetException ite) {
            logger.severe("An error occurred within abstractID3v2FrameBody");
            logger.log(Level.SEVERE, "Invocation target exception:" + ite.getCause().getMessage(), ite.getCause());
            if (ite.getCause() instanceof Error) {
                throw (Error)ite.getCause();
            }
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            throw new InvalidFrameException(ite.getCause().getMessage());
        }
        catch (InstantiationException ie) {
            logger.log(Level.SEVERE, "Instantiation exception:" + ie.getMessage(), ie);
            throw new RuntimeException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.SEVERE, "Illegal access exception :" + iae.getMessage(), iae);
            throw new RuntimeException(iae.getMessage());
        }
        logger.finer("frame Body created" + frameBody.getIdentifier());
        frameBody.setHeader(this);
        return frameBody;
    }

    public byte[] getRawContent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        return baos.toByteArray();
    }

    public abstract void write(ByteArrayOutputStream var1);

    public void isBinary(boolean b) {
    }

    public boolean isEmpty() {
        AbstractTagFrameBody body = this.getBody();
        return body == null;
    }

    public StatusFlags getStatusFlags() {
        return this.statusFlags;
    }

    public EncodingFlags getEncodingFlags() {
        return this.encodingFlags;
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_FRAME, this.getIdentifier());
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_FRAME);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractID3v2Frame)) {
            return false;
        }
        AbstractID3v2Frame that = (AbstractID3v2Frame)obj;
        return super.equals(that);
    }

    public String getContent() {
        return this.getBody().getUserFriendlyValue();
    }

    public String getEncoding() {
        return TextEncoding.getInstanceOf().getValueForId(this.getBody().getTextEncoding());
    }

    public void setContent(String content) {
        throw new UnsupportedOperationException("Not implemeneted please use the generic tag methods for setting content");
    }

    class EncodingFlags {
        protected static final String TYPE_FLAGS = "encodingFlags";
        protected byte flags;

        protected EncodingFlags() {
            this.resetFlags();
        }

        protected EncodingFlags(byte flags) {
            this.setFlags(flags);
        }

        public byte getFlags() {
            return this.flags;
        }

        public void setFlags(byte flags) {
            this.flags = flags;
        }

        public void resetFlags() {
            this.setFlags((byte)0);
        }

        public void createStructure() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EncodingFlags)) {
                return false;
            }
            EncodingFlags that = (EncodingFlags)obj;
            return EqualsUtil.areEqual(this.getFlags(), that.getFlags());
        }
    }

    public class StatusFlags {
        protected static final String TYPE_FLAGS = "statusFlags";
        protected byte originalFlags;
        protected byte writeFlags;

        protected StatusFlags() {
        }

        public byte getOriginalFlags() {
            return this.originalFlags;
        }

        public byte getWriteFlags() {
            return this.writeFlags;
        }

        public void createStructure() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StatusFlags)) {
                return false;
            }
            StatusFlags that = (StatusFlags)obj;
            return EqualsUtil.areEqual(this.getOriginalFlags(), that.getOriginalFlags()) && EqualsUtil.areEqual(this.getWriteFlags(), that.getWriteFlags());
        }
    }
}

