/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskProvider;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.core.helpers.TaskActorsHelper;
import org.nuxeo.ecm.platform.task.core.service.TaskEventNotificationHelper;
import org.nuxeo.runtime.api.Framework;

public class DocumentTaskProvider
implements TaskProvider {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentTaskProvider.class);

    public List<Task> getCurrentTaskInstances(CoreSession coreSession) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)coreSession.getPrincipal();
        List<String> actors = TaskActorsHelper.getTaskActors(principal);
        return this.getCurrentTaskInstances(actors, coreSession);
    }

    public List<Task> getCurrentTaskInstances(CoreSession coreSession, List<SortInfo> sortInfos) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)coreSession.getPrincipal();
        List<String> actors = TaskActorsHelper.getTaskActors(principal);
        return this.getCurrentTaskInstances(actors, coreSession, sortInfos);
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession) throws ClientException {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_ACTORS", coreSession, true, null, actors);
    }

    public List<Task> getCurrentTaskInstances(List<String> actors, CoreSession coreSession, List<SortInfo> sortInfos) throws ClientException {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_ACTORS", coreSession, true, sortInfos, actors);
    }

    public List<Task> getTaskInstances(DocumentModel dm, NuxeoPrincipal user, CoreSession coreSession) throws ClientException {
        if (user == null) {
            return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS", coreSession, true, null, dm.getId(), dm.getId());
        }
        List<String> actors = TaskActorsHelper.getTaskActors(user);
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS_AND_ACTORS", coreSession, true, null, dm.getId(), dm.getId(), actors);
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, CoreSession coreSession) throws ClientException {
        if (actors == null || actors.isEmpty()) {
            return new ArrayList<Task>();
        }
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS_AND_ACTORS", coreSession, true, null, dm.getId(), dm.getId(), actors);
    }

    public List<Task> getAllTaskInstances(String processId, CoreSession session) throws ClientException {
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_PROCESS", session, true, null, processId);
    }

    public List<Task> getAllTaskInstances(String processId, NuxeoPrincipal user, CoreSession session) throws ClientException {
        List<String> actors = TaskActorsHelper.getTaskActors(user);
        return this.getAllTaskInstances(processId, actors, session);
    }

    public List<Task> getAllTaskInstances(String processId, List<String> actors, CoreSession session) throws ClientException {
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_PROCESS_AND_ACTORS", session, true, null, processId, actors);
    }

    public static List<Task> wrapDocModelInTask(List<DocumentModel> taskDocuments) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (DocumentModel doc : taskDocuments) {
            tasks.add((Task)doc.getAdapter(Task.class));
        }
        return tasks;
    }

    @Deprecated
    public static List<Task> wrapDocModelInTask(DocumentModelList taskDocuments) throws ClientException {
        return DocumentTaskProvider.wrapDocModelInTask(taskDocuments, false);
    }

    @Deprecated
    public static List<Task> wrapDocModelInTask(DocumentModelList taskDocuments, boolean detach) throws ClientException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (DocumentModel doc : taskDocuments) {
            if (detach) {
                doc.detach(true);
            }
            tasks.add((Task)doc.getAdapter(Task.class));
        }
        return tasks;
    }

    public String endTask(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment, String eventName, boolean isValidated) throws ClientException {
        String docIdVar;
        if (!StringUtils.isEmpty((String)comment)) {
            task.addComment(principal.getName(), comment);
        }
        task.setVariable(TaskService.VariableName.validated.name(), String.valueOf(isValidated));
        task.end(coreSession);
        DocumentModel taskDocument = task.getDocument();
        if (taskDocument.getSessionId() == null) {
            taskDocument.attach(coreSession.getSessionId());
        }
        coreSession.saveDocument(taskDocument);
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        ArrayList<String> notificationRecipients = new ArrayList<String>();
        notificationRecipients.add(task.getInitiator());
        notificationRecipients.addAll(task.getActors());
        eventProperties.put("recipients", notificationRecipients);
        DocumentModel document = null;
        ArrayList<String> docIds = new ArrayList<String>();
        docIds.addAll(task.getTargetDocumentsIds());
        String docId = task.getTargetDocumentId();
        if (!docIds.contains(docId)) {
            docIds.add(docId);
        }
        if (!docIds.contains(docIdVar = task.getVariable(TaskService.VariableName.documentId.name()))) {
            docIds.add(docIdVar);
        }
        String docRepo = task.getVariable(TaskService.VariableName.documentRepositoryName.name());
        ArrayList<DocumentModel> documents = new ArrayList<DocumentModel>();
        if (coreSession.getRepositoryName().equals(docRepo)) {
            try {
                for (String id : docIds) {
                    document = coreSession.getDocument((DocumentRef)new IdRef(id));
                    documents.add(document);
                }
            }
            catch (ClientException e) {
                log.error((Object)String.format("Could not fetch document with id '%s:%s' for notification", docRepo, docId), (Throwable)e);
            }
        } else {
            log.error((Object)String.format("Could not resolve document for notification: document is on repository '%s' and given session is on repository '%s'", docRepo, coreSession.getRepositoryName()));
        }
        boolean taskEndedByDelegatedActor = task.getDelegatedActors() != null && task.getDelegatedActors().contains(principal.getName());
        for (DocumentModel doc : documents) {
            TaskEventNotificationHelper.notifyEvent(coreSession, doc, principal, task, eventName, eventProperties, comment, null);
            if (!taskEndedByDelegatedActor) continue;
            TaskEventNotificationHelper.notifyEvent(coreSession, doc, principal, task, eventName, eventProperties, String.format("Task ended by an delegated actor '%s' ", principal.getName()) + (!StringUtils.isEmpty((String)comment) ? " with the following comment: " + comment : ""), null);
        }
        String seamEventName = isValidated ? "workflowTaskCompleted" : "workflowTaskRejected";
        return seamEventName;
    }

    public List<Task> getAllTaskInstances(String processId, String nodeId, CoreSession session) throws ClientException {
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_PROCESS_AND_NODE", session, true, null, processId, nodeId);
    }

    public List<Task> getTaskInstances(DocumentModel dm, List<String> actors, boolean includeDelegatedTasks, CoreSession session) throws ClientException {
        if (includeDelegatedTasks) {
            return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS_AND_ACTORS_OR_DELEGATED_ACTORS", session, true, null, dm.getId(), dm.getId(), actors, actors);
        }
        return DocumentTaskProvider.getTasks("GET_TASKS_FOR_TARGET_DOCUMENTS_AND_ACTORS", session, true, null, dm.getId(), dm.getId(), actors);
    }

    public static List<Task> getTasks(String pageProviderName, CoreSession session, boolean unrestricted, List<SortInfo> sortInfos, Object ... params) {
        PageProvider pp;
        Map defProps;
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        if (ppService == null) {
            throw new RuntimeException("Missing PageProvider service");
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        PageProviderDefinition def = ppService.getPageProviderDefinition(pageProviderName);
        if (def != null && (defProps = def.getProperties()) != null) {
            props.putAll(defProps);
        }
        props.put("coreSession", (Serializable)session);
        if (unrestricted) {
            props.put("useUnrestrictedSession", Boolean.TRUE);
        }
        if ((pp = ppService.getPageProvider(pageProviderName, sortInfos, null, null, props, params)) == null) {
            throw new ClientException("Page provider not found: " + pageProviderName);
        }
        return DocumentTaskProvider.wrapDocModelInTask(pp.getCurrentPage());
    }
}

