/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.bank;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.bank.ThemeBankException;
import org.nuxeo.theme.presets.PaletteIdentifyException;
import org.nuxeo.theme.presets.PaletteParseException;
import org.nuxeo.theme.presets.PaletteParser;
import org.nuxeo.theme.resources.BankManager;
import org.nuxeo.theme.resources.BankUtils;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final List<String> PRESET_CATEGORIES = Arrays.asList("color", "background", "font", "border");

    public static List<String> getCollections(String bankName) throws IOException {
        return BankManager.getCollections((String)bankName);
    }

    public static List<String> getItemsInCollection(String bankName, String collection, String typeName) throws IOException {
        return BankManager.getItemsInCollection((String)bankName, (String)collection, (String)typeName);
    }

    public static List<String> listSkinsInCollection(String bankName, String collection) throws IOException {
        Map info = BankManager.getInfo((String)bankName, (String)collection, (String)"style");
        ArrayList<String> skins = new ArrayList<String>();
        if (info != null) {
            for (Map.Entry entry : info.entrySet()) {
                String resource = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                Boolean isSkin = false;
                if (value.containsKey("skin")) {
                    isSkin = (Boolean)value.get("skin");
                }
                if (!isSkin.booleanValue()) continue;
                skins.add(resource);
            }
        }
        return skins;
    }

    public static Properties getPresetProperties(String bank, String collection, String category) {
        File file;
        String path = String.format("%s/%s/preset/%s", bank, collection, category);
        try {
            file = BankManager.getFile((String)path);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        Properties properties = new Properties();
        if (!file.exists()) {
            return properties;
        }
        for (File f : file.listFiles()) {
            String content;
            try {
                content = BankUtils.getFileContent((File)f);
            }
            catch (IOException e) {
                log.warn((Object)("Could not read file: " + f.getAbsolutePath()));
                continue;
            }
            try {
                properties.putAll((Map<?, ?>)PaletteParser.parse((byte[])content.getBytes(), (String)f.getName()));
            }
            catch (PaletteIdentifyException e) {
                log.warn((Object)("Could not identify palette type: " + f.getAbsolutePath()));
            }
            catch (PaletteParseException e) {
                log.warn((Object)("Could not parse palette: " + f.getAbsolutePath()));
            }
        }
        return properties;
    }

    public static String listBankSkins(String bankName) throws IOException {
        JSONArray skins = new JSONArray();
        for (String collection : BankManager.getCollections((String)bankName)) {
            Map info = BankManager.getInfo((String)bankName, (String)collection, (String)"style");
            if (info == null) continue;
            for (Map.Entry entry : info.entrySet()) {
                String resource = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                if (!value.containsKey("skin") || !((Boolean)value.get("skin")).booleanValue()) continue;
                Boolean isBase = false;
                if (value.containsKey("base")) {
                    isBase = (Boolean)value.get("base");
                }
                JSONObject skinMap = new JSONObject();
                skinMap.put((Object)"bank", (Object)bankName);
                skinMap.put((Object)"collection", (Object)collection);
                skinMap.put((Object)"resource", (Object)resource);
                skinMap.put((Object)"name", (Object)String.format("%s (%s)", resource.replace(".css", ""), collection));
                skinMap.put((Object)"base", (Object)isBase);
                skins.add((Object)skinMap);
            }
        }
        return skins.toString();
    }

    public static String listBankStyles(String bankName) throws IOException {
        JSONArray styles = new JSONArray();
        for (String collection : BankManager.getCollections((String)bankName)) {
            for (String resource : Utils.getItemsInCollection(bankName, collection, "style")) {
                JSONObject styleMap = new JSONObject();
                styleMap.put((Object)"bank", (Object)bankName);
                styleMap.put((Object)"collection", (Object)collection);
                styleMap.put((Object)"resource", (Object)resource);
                styleMap.put((Object)"name", (Object)String.format("%s (%s)", resource.replace(".css", ""), collection));
                styles.add((Object)styleMap);
            }
        }
        return styles.toString();
    }

    public static String listBankPresets(String bankName) throws IOException {
        JSONArray presets = new JSONArray();
        for (String collection : BankManager.getCollections((String)bankName)) {
            for (String category : PRESET_CATEGORIES) {
                for (Map.Entry<Object, Object> property : Utils.getPresetProperties(bankName, collection, category).entrySet()) {
                    JSONObject presetMap = new JSONObject();
                    presetMap.put((Object)"bank", (Object)bankName);
                    presetMap.put((Object)"collection", (Object)collection);
                    presetMap.put((Object)"category", (Object)category);
                    presetMap.put((Object)"name", property.getKey());
                    presetMap.put((Object)"value", property.getValue());
                    presets.add((Object)presetMap);
                }
            }
        }
        return presets.toString();
    }

    public static String listImages(String bank) throws IOException {
        JSONArray index = new JSONArray();
        for (String collection : BankManager.getCollections((String)bank)) {
            String path = String.format("%s/%s/image/", bank, collection);
            File file = BankManager.getFile((String)path);
            if (!file.isDirectory()) {
                throw new IOException("Expected folder: " + path);
            }
            for (File image : file.listFiles()) {
                JSONObject imageMap = new JSONObject();
                imageMap.put((Object)"name", (Object)image.getName());
                imageMap.put((Object)"collection", (Object)collection);
                index.add((Object)imageMap);
            }
        }
        return index.toString();
    }

    public static String listCollections(String bank) throws IOException {
        JSONArray index = new JSONArray();
        for (String collection : BankManager.getCollections((String)bank)) {
            index.add((Object)collection);
        }
        return index.toString();
    }

    public static String getNavTree() throws IOException {
        JSONArray tree = new JSONArray();
        for (String bankName : BankManager.getBankNames()) {
            JSONObject bankNode = new JSONObject();
            bankNode.put((Object)"state", (Object)"open");
            JSONObject bankMap = new JSONObject();
            bankMap.put((Object)"title", (Object)bankName);
            JSONObject bankAttributes = new JSONObject();
            bankAttributes.put((Object)"rel", (Object)"bank");
            bankAttributes.put((Object)"path", (Object)String.format("/%s", bankName));
            bankAttributes.put((Object)"id", (Object)BankUtils.getDomId((String)bankName));
            bankNode.put((Object)"attributes", (Object)bankAttributes);
            bankNode.put((Object)"data", (Object)bankMap);
            JSONArray childrenNodes = new JSONArray();
            for (String collection : BankManager.getCollections((String)bankName)) {
                childrenNodes.add((Object)Utils.getNavTreeCollectionNode(bankName, collection));
            }
            bankNode.put((Object)"children", (Object)childrenNodes);
            tree.add((Object)bankNode);
        }
        return tree.toString();
    }

    private static JSONObject getNavTreeCollectionNode(String bankName, String collection) throws IOException {
        String[] TYPE_NAMES;
        JSONObject collectionNode = new JSONObject();
        JSONObject collectionMap = new JSONObject();
        collectionMap.put((Object)"title", (Object)collection);
        JSONObject collectionAttributes = new JSONObject();
        collectionAttributes.put((Object)"rel", (Object)"collection");
        collectionAttributes.put((Object)"path", (Object)String.format("/%s/%s", bankName, collection));
        collectionAttributes.put((Object)"id", (Object)BankUtils.getDomId((String)String.format("%s-%s", bankName, collection)));
        collectionNode.put((Object)"data", (Object)collectionMap);
        collectionNode.put((Object)"attributes", (Object)collectionAttributes);
        JSONArray folderTypeNodes = new JSONArray();
        for (String typeName : TYPE_NAMES = new String[]{"skin", "style", "preset", "image"}) {
            JSONObject folderTypeNode = new JSONObject();
            JSONObject folderTypeMap = new JSONObject();
            folderTypeMap.put((Object)"title", (Object)typeName);
            JSONObject folderTypeAttributes = new JSONObject();
            folderTypeAttributes.put((Object)"rel", (Object)"folder");
            folderTypeAttributes.put((Object)"path", (Object)String.format("/%s/%s/%s", bankName, collection, typeName));
            folderTypeAttributes.put((Object)"id", (Object)BankUtils.getDomId((String)String.format("%s-%s-%s", bankName, collection, typeName)));
            folderTypeNode.put((Object)"attributes", (Object)folderTypeAttributes);
            folderTypeNode.put((Object)"data", (Object)folderTypeMap);
            JSONArray items = new JSONArray();
            List<String> skins = Utils.listSkinsInCollection(bankName, collection);
            String effectiveTypeName = "skin".equals(typeName) ? "style" : typeName;
            for (String item : BankManager.getItemsInCollection((String)bankName, (String)collection, (String)effectiveTypeName)) {
                if ("skin".equals(typeName) ? !skins.contains(item) : "style".equals(typeName) && skins.contains(item)) continue;
                JSONObject itemNode = new JSONObject();
                JSONObject itemMap = new JSONObject();
                itemMap.put((Object)"title", (Object)item);
                JSONObject itemAttributes = new JSONObject();
                itemAttributes.put((Object)"rel", (Object)typeName);
                itemAttributes.put((Object)"path", (Object)String.format("/%s/%s/%s/%s", bankName, collection, typeName, item));
                itemAttributes.put((Object)"id", (Object)BankUtils.getDomId((String)String.format("%s-%s-%s-%s", bankName, collection, typeName, item)));
                itemNode.put((Object)"attributes", (Object)itemAttributes);
                itemNode.put((Object)"data", (Object)itemMap);
                items.add((Object)itemNode);
            }
            folderTypeNode.put((Object)"children", (Object)items);
            folderTypeNodes.add((Object)folderTypeNode);
        }
        collectionNode.put((Object)"children", (Object)folderTypeNodes);
        return collectionNode;
    }

    public static StreamingOutput streamFile(final File file) {
        return new StreamingOutput(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void write(OutputStream out) throws IOException, WebApplicationException {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
                        catch (IOException e2) {
                            throw new WebApplicationException((Throwable)e2, Response.Status.INTERNAL_SERVER_ERROR);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
            }
        };
    }
}

