/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.PageElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatFactory;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.presets.PaletteIdentifyException;
import org.nuxeo.theme.presets.PaletteParseException;
import org.nuxeo.theme.presets.PaletteParser;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.resources.ResourceManager;
import org.nuxeo.theme.resources.ResourceType;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.Flavor;
import org.nuxeo.theme.styling.service.descriptors.FlavorPresets;
import org.nuxeo.theme.styling.service.descriptors.Logo;
import org.nuxeo.theme.styling.service.descriptors.PalettePreview;
import org.nuxeo.theme.styling.service.descriptors.SimpleStyle;
import org.nuxeo.theme.styling.service.descriptors.ThemePage;
import org.nuxeo.theme.styling.service.registries.FlavorRegistry;
import org.nuxeo.theme.styling.service.registries.PageRegistry;
import org.nuxeo.theme.styling.service.registries.ResourceRegistry;
import org.nuxeo.theme.styling.service.registries.StyleRegistry;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.uids.Identifiable;

public class ThemeStylingServiceImpl
extends DefaultComponent
implements ThemeStylingService {
    private static final Log log = LogFactory.getLog(ThemeStylingServiceImpl.class);
    protected PageRegistry pageReg;
    protected FlavorRegistry flavorReg;
    protected StyleRegistry styleReg;
    protected ResourceRegistry resourceReg;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.pageReg = new PageRegistry();
        this.flavorReg = new FlavorRegistry();
        this.styleReg = new StyleRegistry();
        this.resourceReg = new ResourceRegistry();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof Flavor) {
            Flavor flavor = (Flavor)contribution;
            log.info((Object)String.format("Register flavor '%s'", flavor.getName()));
            this.registerFlavor(flavor, contributor.getContext());
            log.info((Object)String.format("Done registering flavor '%s'", flavor.getName()));
        } else if (contribution instanceof SimpleStyle) {
            SimpleStyle style = (SimpleStyle)contribution;
            log.info((Object)String.format("Register style '%s'", style.getName()));
            this.registerStyle(style, contributor.getContext());
            log.info((Object)String.format("Done registering style '%s'", style.getName()));
        } else if (contribution instanceof ThemePage) {
            ThemePage themePage = (ThemePage)contribution;
            log.info((Object)String.format("Register page '%s'", themePage.getName()));
            this.registerPage(themePage);
            log.info((Object)String.format("Done registering page '%s'", themePage.getName()));
        } else if (contribution instanceof ResourceType) {
            ResourceType resource = (ResourceType)contribution;
            log.info((Object)String.format("Register resource '%s'", resource.getName()));
            this.registerResource(resource, contributor.getContext());
            log.info((Object)String.format("Done registering resource '%s'", resource.getName()));
        } else {
            log.error((Object)String.format("Unknown contribution to the theme styling service, extension point '%s': '%s", extensionPoint, contribution));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof Flavor) {
            Flavor flavor = (Flavor)contribution;
            this.flavorReg.removeContribution(flavor);
            Flavor newFlavor = this.flavorReg.getFlavor(flavor.getName());
            if (newFlavor == null) {
                this.unregisterFlavorToThemeService(flavor);
            } else if (!Framework.getRuntime().isShuttingDown()) {
                this.registerFlavor(newFlavor, contributor.getContext());
            }
        } else if (contribution instanceof ResourceType) {
            ResourceType resource = (ResourceType)contribution;
            this.resourceReg.removeContribution(resource);
            ResourceType newResource = this.resourceReg.getResource(resource.getName());
            if (newResource == null) {
                this.unregisterResourceToThemeService(resource);
            } else if (!Framework.getRuntime().isShuttingDown()) {
                this.registerResource(newResource, contributor.getContext());
            }
        } else if (contribution instanceof SimpleStyle) {
            SimpleStyle style = (SimpleStyle)contribution;
            this.styleReg.removeContribution(style);
            if (!Framework.getRuntime().isShuttingDown()) {
                this.postRegisterAllThemePageResources();
            }
        } else if (contribution instanceof ThemePage) {
            ThemePage themePage = (ThemePage)contribution;
            this.pageReg.removeContribution(themePage);
            ThemePage newThemePage = this.pageReg.getThemePage(themePage.getName());
            if (newThemePage == null) {
                try {
                    this.unRegisterThemePageResources(themePage);
                }
                catch (ThemeException e) {
                    throw new RuntimeException(e);
                }
            } else if (!Framework.getRuntime().isShuttingDown()) {
                try {
                    this.postRegisterThemePageResources(newThemePage);
                }
                catch (ThemeException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            log.error((Object)String.format("Unknown contribution to the theme styling service, extension point '%s': '%s", extensionPoint, contribution));
        }
    }

    protected void registerPage(ThemePage themePage) {
        String themePageName = themePage.getName();
        ThemePage existingPage = this.pageReg.getThemePage(themePageName);
        this.pageReg.addContribution(themePage);
        if (existingPage != null && existingPage.isLoaded()) {
            if ("*".equals(themePageName)) {
                this.postRegisterAllThemePageResources();
            } else {
                ThemePage newPage = this.pageReg.getThemePage(themePageName);
                try {
                    this.postRegisterThemePageResources(newPage);
                }
                catch (ThemeException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void registerFlavor(Flavor flavor, RuntimeContext extensionContext) {
        List<FlavorPresets> presets = flavor.getPresets();
        if (presets != null) {
            for (FlavorPresets myPreset : presets) {
                String content;
                String src = myPreset.getSrc();
                URL url = this.getUrlFromPath(src, extensionContext);
                if (url == null) {
                    log.error((Object)String.format("Could not find resource at '%s'", src));
                    continue;
                }
                try {
                    content = new String(FileUtils.readBytes((URL)url));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                myPreset.setContent(content);
            }
        }
        this.flavorReg.addContribution(flavor);
        String flavorName = flavor.getName();
        Flavor newFlavor = this.flavorReg.getFlavor(flavorName);
        this.registerFlavorToThemeService(newFlavor, extensionContext);
        for (Flavor f : this.flavorReg.getFlavorsExtending(flavorName)) {
            log.info((Object)String.format("Register again flavor '%s' as it extends flavor '%s'", f.getName(), flavorName));
            this.registerFlavorToThemeService(f, extensionContext);
        }
    }

    protected List<FlavorPresets> computePresets(Flavor flavor, List<String> flavors) {
        ArrayList<FlavorPresets> presets = new ArrayList<FlavorPresets>();
        if (flavor != null) {
            String extendsFlavorName;
            List<FlavorPresets> localPresets = flavor.getPresets();
            if (localPresets != null) {
                presets.addAll(localPresets);
            }
            if (!StringUtils.isBlank((String)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    log.error((Object)String.format("Cyclic dependency detected in flavor '%s' hierarchy", flavor.getName()));
                    return presets;
                }
                flavors.add(flavor.getName());
                Flavor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    List<FlavorPresets> parentPresets = this.computePresets(extendedFlavor, flavors);
                    if (parentPresets != null) {
                        presets.addAll(0, parentPresets);
                    }
                } else {
                    log.warn((Object)String.format("Extended flavor '%s' not found", extendsFlavorName));
                }
            }
        }
        return presets;
    }

    protected void registerFlavorToThemeService(Flavor flavor, RuntimeContext extensionContext) {
        String flavorName = flavor.getName();
        List<FlavorPresets> presets = this.computePresets(flavor, new ArrayList<String>());
        HashMap presetsByCat = new HashMap();
        if (presets != null) {
            for (FlavorPresets myPreset : presets) {
                String content = myPreset.getContent();
                if (content == null) {
                    log.error((Object)String.format("Null content for preset with source '%s' in flavor '%s'", myPreset.getSrc(), flavorName));
                    continue;
                }
                String cat = myPreset.getCategory();
                Map allEntries = presetsByCat.containsKey(cat) ? (Map)presetsByCat.get(cat) : new HashMap();
                try {
                    Map newEntries = PaletteParser.parse((byte[])content.getBytes(), (String)myPreset.getSrc());
                    if (newEntries != null) {
                        allEntries.putAll(newEntries);
                    }
                    if (allEntries.isEmpty()) {
                        presetsByCat.remove(cat);
                        continue;
                    }
                    presetsByCat.put(cat, allEntries);
                }
                catch (PaletteIdentifyException | PaletteParseException e) {
                    log.error((Object)String.format("Could not parse palette for preset with source '%s' in flavor '%s'", myPreset.getSrc(), flavorName), e);
                }
            }
        }
        this.unregisterFlavorToThemeService(flavor);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Register flavor '%s' to the theme service", flavorName));
        }
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        for (String cat : presetsByCat.keySet()) {
            String paletteName = this.getPaletteName(flavorName, cat);
            Map entries = (Map)presetsByCat.get(cat);
            for (Map.Entry entry : entries.entrySet()) {
                PresetType preset = new PresetType((String)entry.getKey(), (String)entry.getValue(), paletteName, cat, "", "");
                typeRegistry.register((Type)preset);
            }
        }
    }

    protected void unregisterFlavorToThemeService(Flavor flavor) {
        String flavorName = flavor.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unregister flavor '%s' from the theme service", flavorName));
        }
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (ThemeStylingService.PRESET_CATEGORY cat : ThemeStylingService.PRESET_CATEGORY.values()) {
            String paletteName = this.getPaletteName(flavorName, cat.name());
            groupNames.add(paletteName);
        }
        List registeredPresets = typeRegistry.getTypes(TypeFamily.PRESET);
        for (Type type : registeredPresets) {
            PresetType preset = (PresetType)type;
            if (!groupNames.contains(preset.getGroup())) continue;
            typeRegistry.unregister(type);
        }
    }

    protected void registerResource(ResourceType resource, RuntimeContext extensionContext) {
        ResourceType oldResource = this.resourceReg.getResource(resource.getName());
        if (oldResource != null) {
            this.unregisterResourceToThemeService(oldResource);
        }
        this.resourceReg.addContribution(resource);
        String resourceName = resource.getName();
        ResourceType newResource = this.resourceReg.getResource(resourceName);
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        typeRegistry.register((Type)newResource);
        ThemeManager themeManager = Manager.getThemeManager();
        themeManager.updateResourceOrdering();
    }

    protected void unregisterResourceToThemeService(ResourceType resource) {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ThemeManager themeManager = Manager.getThemeManager();
        typeRegistry.unregister((Type)resource);
        themeManager.unregisterResourceOrdering(resource);
    }

    protected void registerStyle(SimpleStyle style, RuntimeContext extensionContext) {
        String src = style.getSrc();
        if (src == null) {
            log.error((Object)String.format("Null source for style '%s'", style.getName()));
            return;
        }
        URL url = this.getUrlFromPath(src, extensionContext);
        if (url == null) {
            log.error((Object)String.format("Could not find resource at '%s'", src));
        } else {
            String cssSource;
            try {
                cssSource = new String(FileUtils.readBytes((URL)url));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            style.setContent(cssSource);
        }
        this.styleReg.addContribution(style);
        this.postRegisterAllThemePageResources();
    }

    protected String getPaletteName(String name, String category) {
        return name + " " + category;
    }

    protected URL getUrlFromPath(String path, RuntimeContext extensionContext) {
        URL url;
        block3: {
            if (path == null) {
                return null;
            }
            url = null;
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                url = extensionContext.getLocalResource(path);
                if (url != null) break block3;
                url = extensionContext.getResource(path);
            }
        }
        return url;
    }

    protected void postRegisterAllThemePageResources() {
        if (this.pageReg != null) {
            for (ThemePage res : this.pageReg.getThemePages()) {
                if (!res.isLoaded()) continue;
                try {
                    this.postRegisterThemePageResources(res);
                }
                catch (ThemeException e) {
                    log.error((Object)String.format("Could not load theme page resources for page '%s' ", res.getName()), (Throwable)e);
                }
            }
        }
    }

    protected void postRegisterThemePageResources(ThemePage page) throws ThemeException {
        String pageName = page.getName();
        if (!"*".equals(pageName)) {
            ThemePage forAllPage = this.pageReg.getConfigurationApplyingToAllThemes();
            this.postRegisterThemePageResources(pageName, page, forAllPage);
        }
    }

    protected void postRegisterThemePageResources(String themePageName, ThemePage page, ThemePage pageApplyingToAll) throws ThemeException {
        PageElement pageElement;
        String themeName = ThemePage.getThemeName(themePageName);
        ThemeManager themeManager = Manager.getThemeManager();
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        if (themeDescriptor == null) {
            log.error((Object)String.format("Could not resolve theme descriptor for name '%s'", themeName));
        }
        if (themeDescriptor != null && !themeDescriptor.isLoaded()) {
            ThemeManager.loadTheme((ThemeDescriptor)themeDescriptor);
        }
        if ((pageElement = themeManager.getPageByPath(themePageName)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Register theme page '%s' to the theme service", themePageName));
            }
            ArrayList<String> allStyleNames = new ArrayList<String>();
            List<String> styleNames = page.getStyles();
            if (styleNames != null) {
                allStyleNames.addAll(styleNames);
            }
            if (pageApplyingToAll != null && (styleNames = pageApplyingToAll.getStyles()) != null) {
                allStyleNames.addAll(styleNames);
            }
            if (!allStyleNames.isEmpty()) {
                Style style = themeManager.createStyle();
                style.setExternal(true);
                for (String styleName : allStyleNames) {
                    SimpleStyle simpleStyle = this.styleReg.getStyle(styleName);
                    if (simpleStyle == null) {
                        log.warn((Object)("Style unknown: " + styleName));
                        continue;
                    }
                    String cssSource = simpleStyle.getContent();
                    if (cssSource != null) {
                        cssSource = cssSource.replaceAll("__FLAVOR__", ThemeManager.getCollectionCssMarker());
                        Utils.loadCss((Style)style, (String)cssSource, (String)"*", (boolean)true);
                        continue;
                    }
                    log.error((Object)("Null content for css style: " + styleName));
                }
                style.setName(themePageName + " Page Styles");
                style.setCollection(themePageName + " CSS");
                themeManager.setNamedObject(themeName, "style", (Identifiable)style);
                Style existingPageStyle = (Style)ElementFormatter.getFormatFor((Element)pageElement, (String)"style");
                if (existingPageStyle == null) {
                    existingPageStyle = (Style)FormatFactory.create((String)"style");
                    ElementFormatter.setFormat((Object)pageElement, (Format)existingPageStyle);
                }
                themeManager.makeFormatInherit((Format)existingPageStyle, (Format)style);
            } else {
                themeManager.removeNamedObject(themeName, "style", themePageName + " Page Styles");
            }
            page.setLoaded(true);
            if (pageApplyingToAll != null) {
                pageApplyingToAll.setLoaded(true);
            }
            themeManager.stylesModified(themeName);
            themeManager.themeModified(themeName);
            themeManager.resetCachedResources();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Done registering theme page '%s' to the theme service", themePageName));
            }
        } else {
            log.error((Object)String.format("Unknown theme page '%s'", page.getName()));
        }
    }

    protected void unRegisterThemePageResources(ThemePage page) throws ThemeException {
        String pageName = page.getName();
        if (!"*".equals(pageName)) {
            this.unRegisterThemePageResources(pageName, page);
        }
    }

    protected void unRegisterThemePageResources(String themePageName, ThemePage page) throws ThemeException {
        PageElement pageElement;
        ThemeManager themeManager = Manager.getThemeManager();
        String themeName = ThemePage.getThemeName(themePageName);
        ThemeDescriptor themeDescriptor = ThemeManager.getThemeDescriptorByThemeName((String)themeName);
        if (themeDescriptor == null) {
            return;
        }
        if (themeDescriptor != null && !themeDescriptor.isLoaded()) {
            ThemeManager.loadTheme((ThemeDescriptor)themeDescriptor);
        }
        if ((pageElement = themeManager.getPageByPath(themePageName)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unregister theme page '%s' from the theme service", themePageName));
            }
            themeManager.removeNamedObject(themeName, "style", themePageName + " Page Styles");
            themeManager.stylesModified(themeName);
            themeManager.themeModified(themeName);
        } else {
            log.error((Object)String.format("Unknown theme page '%s'", page.getName()));
        }
    }

    @Override
    public String getDefaultFlavorName(String themePageName) {
        ThemePage themePage;
        if (this.pageReg != null && (themePage = this.pageReg.getThemePage(themePageName)) != null) {
            return themePage.getDefaultFlavor();
        }
        return null;
    }

    @Override
    public Flavor getFlavor(String flavorName) {
        if (this.flavorReg != null) {
            Flavor flavor = this.flavorReg.getFlavor(flavorName);
            Flavor clone = null;
            if (flavor != null) {
                if (flavor.getLogo() == null) {
                    clone = flavor.clone();
                    clone.setLogo(this.computeLogo(flavor, new ArrayList<String>()));
                }
                if (flavor.getPalettePreview() == null) {
                    if (clone == null) {
                        clone = flavor.clone();
                    }
                    clone.setPalettePreview(this.computePalettePreview(flavor, new ArrayList<String>()));
                }
            }
            if (clone != null) {
                return clone;
            }
            return flavor;
        }
        return null;
    }

    @Override
    public Logo getLogo(String flavorName) {
        Flavor flavor = this.getFlavor(flavorName);
        if (flavor != null) {
            return flavor.getLogo();
        }
        return null;
    }

    protected Logo computeLogo(Flavor flavor, List<String> flavors) {
        if (flavor != null) {
            String extendsFlavorName;
            Logo localLogo = flavor.getLogo();
            if (localLogo == null && !StringUtils.isBlank((String)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    log.error((Object)String.format("Cyclic dependency detected in flavor '%s' hierarchy", flavor.getName()));
                    return null;
                }
                flavors.add(flavor.getName());
                Flavor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    localLogo = this.computeLogo(extendedFlavor, flavors);
                } else {
                    log.warn((Object)String.format("Extended flavor '%s' not found", extendsFlavorName));
                }
            }
            return localLogo;
        }
        return null;
    }

    protected PalettePreview computePalettePreview(Flavor flavor, List<String> flavors) {
        if (flavor != null) {
            String extendsFlavorName;
            PalettePreview localPalette = flavor.getPalettePreview();
            if (localPalette == null && !StringUtils.isBlank((String)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    log.error((Object)String.format("Cyclic dependency detected in flavor '%s' hierarchy", flavor.getName()));
                    return null;
                }
                flavors.add(flavor.getName());
                Flavor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    localPalette = this.computePalettePreview(extendedFlavor, flavors);
                } else {
                    log.warn((Object)String.format("Extended flavor '%s' not found", extendsFlavorName));
                }
            }
            return localPalette;
        }
        return null;
    }

    @Override
    public List<String> getFlavorNames(String themePageName) {
        ThemePage themePage;
        if (this.pageReg != null && (themePage = this.pageReg.getThemePage(themePageName)) != null) {
            String defaultFlavor;
            ThemePage forAllPage;
            ArrayList<String> flavors = new ArrayList<String>();
            List<String> localFlavors = themePage.getFlavors();
            if (localFlavors != null) {
                flavors.addAll(localFlavors);
            }
            if ((forAllPage = this.pageReg.getConfigurationApplyingToAllThemes()) != null && (localFlavors = forAllPage.getFlavors()) != null) {
                flavors.addAll(localFlavors);
            }
            if ((defaultFlavor = themePage.getDefaultFlavor()) != null && !flavors.contains(defaultFlavor)) {
                flavors.add(0, defaultFlavor);
            }
            return flavors;
        }
        return null;
    }

    @Override
    public List<Flavor> getFlavors(String themePageName) {
        List<String> flavorNames = this.getFlavorNames(themePageName);
        if (flavorNames != null) {
            ArrayList<Flavor> flavors = new ArrayList<Flavor>();
            for (String flavorName : flavorNames) {
                Flavor flavor = this.getFlavor(flavorName);
                if (flavor == null) continue;
                flavors.add(flavor);
            }
            return flavors;
        }
        return null;
    }

    @Override
    public void themeRegistered(String themeName) {
        if (themeName == null) {
            return;
        }
        if (this.pageReg != null) {
            for (ThemePage res : this.pageReg.getThemePages()) {
                String name = ThemePage.getThemeName(res.getName());
                if (!themeName.equals(name)) continue;
                try {
                    this.postRegisterThemePageResources(res);
                }
                catch (ThemeException e) {
                    log.error((Object)("Could not load theme page resources for theme " + themeName), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void themeGlobalResourcesRegistered(URL themeUrl) {
        String themePageName = ThemeManager.getPagePathByUrl((URL)themeUrl);
        ThemePage themePage = this.pageReg.getThemePage(themePageName);
        if (themePage != null) {
            ThemePage forAllPage;
            ArrayList<String> resources = new ArrayList<String>();
            List<String> localResources = themePage.getResources();
            if (localResources != null) {
                resources.addAll(localResources);
            }
            if ((forAllPage = this.pageReg.getConfigurationApplyingToAllThemes()) != null && (localResources = forAllPage.getResources()) != null) {
                resources.addAll(localResources);
            }
            if (resources != null && !resources.isEmpty()) {
                ResourceManager resourceManager = Manager.getResourceManager();
                for (String r : resources) {
                    ResourceType resource = this.resourceReg.getResource(r);
                    if (resource == null) {
                        log.warn((Object)String.format("Missing resource '%s' referenced in theme page '%s'", r, themePageName));
                        continue;
                    }
                    resourceManager.addResource(r, themeUrl);
                }
            }
            ThemeManager themeManager = Manager.getThemeManager();
            themeManager.updateResourceOrdering();
        }
    }
}

