/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.binary.metadata.internals.BinaryMetadataServiceImpl;
import org.nuxeo.binary.metadata.internals.MetadataMappingDescriptor;
import org.nuxeo.binary.metadata.internals.MetadataMappingRegistry;
import org.nuxeo.binary.metadata.internals.MetadataProcessorDescriptor;
import org.nuxeo.binary.metadata.internals.MetadataProcessorRegistry;
import org.nuxeo.binary.metadata.internals.MetadataRuleDescriptor;
import org.nuxeo.binary.metadata.internals.MetadataRuleRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class BinaryMetadataComponent
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(BinaryMetadataComponent.class);
    protected static BinaryMetadataComponent self;
    protected final BinaryMetadataServiceImpl metadataService = new BinaryMetadataServiceImpl();
    protected final MetadataMappingRegistry mappingRegistry = new MetadataMappingRegistry();
    protected final MetadataProcessorRegistry processorRegistry = new MetadataProcessorRegistry();
    protected final MetadataRuleRegistry ruleRegistry = new MetadataRuleRegistry();

    public void activate(ComponentContext context) {
        super.activate(context);
        self = this;
    }

    public void deactivate(ComponentContext context) {
        self = null;
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("metadataMappings".equals(extensionPoint)) {
            this.mappingRegistry.addContribution((MetadataMappingDescriptor)contribution);
        } else if ("metadataRules".equals(extensionPoint)) {
            this.ruleRegistry.addContribution((MetadataRuleDescriptor)contribution);
        } else if ("metadataProcessors".equals(extensionPoint)) {
            this.processorRegistry.addContribution((MetadataProcessorDescriptor)contribution);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("metadataMappings".equals(extensionPoint)) {
            this.mappingRegistry.removeContribution((MetadataMappingDescriptor)contribution);
        } else if ("metadataRules".equals(extensionPoint)) {
            this.ruleRegistry.removeContribution((MetadataRuleDescriptor)contribution);
        } else if ("metadataProcessors".equals(extensionPoint)) {
            this.processorRegistry.removeContribution((MetadataProcessorDescriptor)contribution);
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void applicationStarted(ComponentContext context) {
        super.applicationStarted(context);
        this.ruleRegistry.handleApplicationStarted();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == BinaryMetadataService.class) {
            return adapter.cast(this.metadataService);
        }
        return null;
    }
}

