/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.core.listener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.runtime.api.Framework;

public class PublishRelationsListener
implements EventListener {
    private static final Log log = LogFactory.getLog(PublishRelationsListener.class);
    public static final String RENDITION_PROXY_PUBLISHED = "renditionProxyPublished";
    protected RelationManager rmanager;
    protected List<String> graphNamesForCopyFromWork = Arrays.asList("default");
    protected List<String> graphNamesForCopyFromReplacedProxy = Arrays.asList("default", "documentComments");

    public RelationManager getRelationManager() {
        if (this.rmanager == null) {
            this.rmanager = (RelationManager)Framework.getService(RelationManager.class);
        }
        return this.rmanager;
    }

    public List<String> getGraphNamesForCopyFromWork() throws ClientException {
        if (this.graphNamesForCopyFromWork == null) {
            return this.getRelationManager().getGraphNames();
        }
        return this.graphNamesForCopyFromWork;
    }

    public List<String> getGraphNamesForCopyFromReplacedProxy() throws ClientException {
        if (this.graphNamesForCopyFromReplacedProxy == null) {
            return this.getRelationManager().getGraphNames();
        }
        return this.graphNamesForCopyFromReplacedProxy;
    }

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            List replacedProxyIds;
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel publishedDoc = docCtx.getSourceDocument();
            if (!publishedDoc.isProxy()) {
                return;
            }
            CoreSession session = ctx.getCoreSession();
            RelationManager rmanager = this.getRelationManager();
            Resource publishedResource = rmanager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)publishedDoc, null);
            Resource sourceResource = null;
            if (!RENDITION_PROXY_PUBLISHED.equals(event.getName())) {
                try {
                    DocumentModel sourceDoc = session.getSourceDocument(publishedDoc.getRef());
                    sourceDoc = session.getSourceDocument(sourceDoc.getRef());
                    sourceResource = rmanager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)sourceDoc, null);
                    this.copyRelationsFromWorkingCopy(rmanager, sourceResource, publishedResource);
                }
                catch (ClientException e) {
                    if (e.getCause() instanceof DocumentException || e instanceof DocumentSecurityException) {
                        log.warn((Object)"working copy of the proxy is no longer available or not readable by the current user, cannot copy the source relations");
                    }
                    throw e;
                }
            }
            if ((replacedProxyIds = (List)ctx.getProperties().get("replacedProxyRefs")) != null) {
                for (String replacedProxyId : replacedProxyIds) {
                    DocumentLocationImpl docLoc = new DocumentLocationImpl(ctx.getRepositoryName(), new IdRef(replacedProxyId), null);
                    Resource replacedResource = rmanager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)docLoc, null);
                    this.copyRelationsFromReplacedProxy(rmanager, replacedResource, publishedResource, sourceResource);
                }
            }
        }
    }

    protected void copyRelationsFromReplacedProxy(RelationManager rmanager, Resource replacedResource, Resource publishedResource, Resource sourceResource) throws ClientException {
        for (String graphName : this.getGraphNamesForCopyFromReplacedProxy()) {
            Graph graph = rmanager.getGraphByName(graphName);
            ArrayList<Statement> newStatements = new ArrayList<Statement>();
            for (Statement stmt : graph.getStatements((Node)replacedResource, null, null)) {
                if (this.isCopyFromSource(stmt, sourceResource)) continue;
                stmt.setSubject((Node)publishedResource);
                newStatements.add(stmt);
            }
            for (Statement stmt : graph.getStatements(null, null, (Node)replacedResource)) {
                if (this.isCopyFromSource(stmt, sourceResource)) continue;
                stmt.setObject((Node)publishedResource);
                newStatements.add(stmt);
            }
            if (newStatements.isEmpty()) continue;
            graph.add(newStatements);
        }
    }

    protected boolean isCopyFromSource(Statement stmt, Resource sourceResource) {
        Node[] values = stmt.getProperties(RelationConstants.COPY_FROM_WORK_VERSION);
        if (values == null) {
            return false;
        }
        return Arrays.asList(values).contains(sourceResource);
    }

    protected void copyRelationsFromWorkingCopy(RelationManager rmanager, Resource sourceResource, Resource publishedResource) throws ClientException {
        for (String graphName : this.getGraphNamesForCopyFromWork()) {
            Graph graph = rmanager.getGraphByName(graphName);
            ArrayList<Statement> newStatements = new ArrayList<Statement>();
            for (Statement stmt : graph.getStatements((Node)sourceResource, null, null)) {
                stmt.setSubject((Node)publishedResource);
                stmt.addProperty(RelationConstants.COPY_FROM_WORK_VERSION, (Node)sourceResource);
                newStatements.add(stmt);
            }
            for (Statement stmt : graph.getStatements(null, null, (Node)sourceResource)) {
                stmt.setObject((Node)publishedResource);
                stmt.addProperty(RelationConstants.COPY_FROM_WORK_VERSION, (Node)sourceResource);
                newStatements.add(stmt);
            }
            if (newStatements.isEmpty()) continue;
            graph.add(newStatements);
        }
    }
}

