/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.runtime.services.streaming.StreamSource;
import org.nuxeo.runtime.services.streaming.StringSource;

public class Html2TextConverter
implements Converter {
    private static final Log log = LogFactory.getLog(Html2TextConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        InputStream stream = null;
        try {
            StreamingBlob sblob;
            StreamSource streamSource;
            Blob blob = blobHolder.getBlob();
            Source source = null;
            if (blob instanceof StreamingBlob && (streamSource = (sblob = (StreamingBlob)blob).getStreamSource()) instanceof StringSource) {
                source = new Source((CharSequence)((StringSource)streamSource).getString());
            }
            if (source == null) {
                source = new Source(blob.getStream());
            }
            Renderer renderer = source.getRenderer();
            renderer.setIncludeHyperlinkURLs(false);
            renderer.setDecorateFontStyles(false);
            String text = renderer.toString();
            text = text.replaceAll("\r\n", "\n");
            text = text.replaceAll(" *\n", "\n");
            text = text.replaceAll("\\n\\n+", "\n\n");
            text = text.trim();
            SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)new StringBlob(text, "text/plain"));
            return simpleCachableBlobHolder;
        }
        catch (IOException | ClientException e) {
            throw new ConversionException("Error during Html2Text conversion", (Exception)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing Blob stream", (Throwable)e);
                }
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

