/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.localconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.localconfiguration.LocalThemeConfig;
import org.nuxeo.theme.localconfiguration.LocalThemeHelper;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.Flavor;
import org.nuxeo.theme.themes.ThemeManager;

@Name(value="themeConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class ThemeConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ThemeConfigurationActions.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected String theme;

    @Deprecated
    public List<SelectItem> getAvailableThemes() {
        ArrayList<SelectItem> themes = new ArrayList<SelectItem>();
        for (String theme : ThemeManager.getThemeNames((String)"jsf-facelets")) {
            themes.add(new SelectItem((Object)theme, theme));
        }
        return themes;
    }

    @Deprecated
    public List<SelectItem> getAvailablePages() {
        ArrayList<SelectItem> pages = new ArrayList<SelectItem>();
        if (this.theme != null && !this.theme.equals("")) {
            for (String pageName : Manager.getThemeManager().getPageNames(this.theme)) {
                pages.add(new SelectItem((Object)pageName, pageName));
            }
        }
        return pages;
    }

    @Deprecated
    public List<SelectItem> getAvailablePerspectives() {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        for (PerspectiveType perspectiveType : PerspectiveManager.listPerspectives()) {
            selectItemList.add(new SelectItem((Object)perspectiveType.name, perspectiveType.title));
        }
        return selectItemList;
    }

    @Deprecated
    public void themeChange(ActionEvent event) {
        UIComponent select = event.getComponent().getParent();
        if (!(select instanceof ValueHolder)) {
            log.error((Object)("Bad component returned " + select));
            throw new AbortProcessingException("Bad component returned " + select);
        }
        this.theme = (String)((ValueHolder)select).getValue();
    }

    public String getConfigurationLayout() {
        Boolean useOldThemeConf = Boolean.valueOf(Framework.getProperty((String)"theme.useOldLocalConfiguration"));
        if (Boolean.TRUE.equals(useOldThemeConf)) {
            return "old_theme_configuration";
        }
        return "theme_configuration";
    }

    public List<Flavor> getAvailableFlavors(String themePage) {
        ThemeStylingService service = (ThemeStylingService)Framework.getService(ThemeStylingService.class);
        if (service == null) {
            return null;
        }
        return service.getFlavors(themePage);
    }

    public String getDefaultFlavorName(String themePage) {
        ThemeStylingService service = (ThemeStylingService)Framework.getService(ThemeStylingService.class);
        if (service == null) {
            return null;
        }
        return service.getDefaultFlavorName(themePage);
    }

    public Flavor getDefaultFlavor(String themePage) {
        ThemeStylingService service = (ThemeStylingService)Framework.getService(ThemeStylingService.class);
        if (service == null) {
            return null;
        }
        String flavorName = service.getDefaultFlavorName(themePage);
        if (flavorName != null) {
            return service.getFlavor(flavorName);
        }
        return null;
    }

    public String getCurrentLocalFlavorName() throws ClientException {
        LocalThemeConfig localThemeConfig;
        DocumentModel currentSuperSpace = this.navigationContext.getCurrentSuperSpace();
        if (currentSuperSpace != null && (localThemeConfig = LocalThemeHelper.getLocalThemeConfig((DocumentModel)currentSuperSpace)) != null) {
            String flavor = localThemeConfig.getFlavor();
            return flavor;
        }
        return null;
    }
}

