/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public class DirectoryEntryResolver
implements ObjectResolver {
    public static final String NAME = "directoryResolver";
    public static final String PARAM_DIRECTORY = "directory";
    private String idField;
    private String schema;
    private Directory directory;
    private Map<String, Serializable> parameters;
    private DirectoryService directoryService;

    public DirectoryService getDirectoryService() {
        if (this.directoryService == null) {
            this.directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        }
        return this.directoryService;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public void configure(Map<String, String> parameters) throws IllegalArgumentException, IllegalStateException {
        if (this.parameters != null) {
            throw new IllegalStateException("cannot change configuration, may be already in use somewhere");
        }
        String directoryName = parameters.get(PARAM_DIRECTORY);
        if (directoryName != null) {
            directoryName = directoryName.trim();
        }
        if (directoryName == null || directoryName.isEmpty()) {
            throw new IllegalArgumentException("missing directory parameter. A directory name is necessary");
        }
        this.directory = this.getDirectoryService().getDirectory(directoryName);
        if (this.directory == null) {
            throw new IllegalArgumentException(String.format("the directory \"%s\" was not found", directoryName));
        }
        this.idField = this.directory.getIdField();
        this.schema = this.directory.getSchema();
        this.parameters = new HashMap<String, Serializable>();
        this.parameters.put(PARAM_DIRECTORY, (Serializable)((Object)this.directory.getName()));
    }

    public String getName() {
        this.checkConfig();
        return NAME;
    }

    public Map<String, Serializable> getParameters() {
        this.checkConfig();
        return Collections.unmodifiableMap(this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(Object value) throws IllegalStateException {
        this.checkConfig();
        if (value != null && value instanceof String) {
            String id = (String)value;
            Session session = null;
            try {
                session = this.directory.getSession();
                boolean bl = session.hasEntry(id);
                return bl;
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                        session = null;
                    }
                    catch (Exception e) {
                        session = null;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fetch(Object value) throws IllegalStateException {
        this.checkConfig();
        if (value != null && value instanceof String) {
            String id = (String)value;
            Session session = null;
            try {
                session = this.directory.getSession();
                DocumentModel documentModel = session.getEntry(id);
                return documentModel;
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                        session = null;
                    }
                    catch (Exception e) {
                        session = null;
                    }
                }
            }
        }
        return null;
    }

    public <T> T fetch(Class<T> type, Object value) throws IllegalStateException {
        this.checkConfig();
        DocumentModel doc = (DocumentModel)this.fetch(value);
        if (doc != null && type.isInstance(doc)) {
            return type.cast(doc);
        }
        return null;
    }

    public Serializable getReference(Object entity) throws IllegalStateException {
        this.checkConfig();
        if (entity != null && entity instanceof DocumentModel) {
            DocumentModel doc = (DocumentModel)entity;
            if (!doc.hasSchema(this.schema)) {
                return null;
            }
            return (Serializable)doc.getProperty(this.schema, this.idField);
        }
        return null;
    }

    public String getConstraintErrorMessage(Object invalidValue, Locale locale) {
        this.checkConfig();
        return ObjectResolver.Helper.getConstraintErrorMessage((ObjectResolver)this, (Object)invalidValue, (Locale)locale, (String[])new String[]{this.directory.getName()});
    }

    private void checkConfig() throws IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("you should call #configure(Map<String, String>) before. Please get this resolver throught ExternalReferenceService which is in charge of resolver configuration.");
        }
    }
}

