/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.memory;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.memory.MemoryDirectorySession;
import org.nuxeo.runtime.api.Framework;

public class MemoryDirectory
extends AbstractDirectory {
    public final String schemaName;
    public final Set<String> schemaSet;
    public final String idField;
    public final String passwordField;
    public Map<String, Object> map;
    public MemoryDirectorySession session;
    protected boolean isReadOnly = false;

    public MemoryDirectory(String name, String schema, String idField, String passwordField) throws DirectoryException {
        this(name, schema, new HashSet<String>(), idField, passwordField);
        SchemaManager sm = this.getSchemaManager();
        Schema sch = sm.getSchema(schema);
        if (sch == null) {
            throw new DirectoryException("Unknown schema :" + schema);
        }
        Collection fields = sch.getFields();
        for (Field f : fields) {
            this.schemaSet.add(f.getName().getLocalName());
        }
    }

    public SchemaManager getSchemaManager() throws DirectoryException {
        SchemaManager sm = (SchemaManager)Framework.getService(SchemaManager.class);
        if (sm == null) {
            throw new DirectoryException("Unable to look up type service");
        }
        return sm;
    }

    public MemoryDirectory(String name, String schemaName, Set<String> schemaSet, String idField, String passwordField) {
        super(name);
        this.schemaName = schemaName;
        this.schemaSet = schemaSet;
        this.idField = idField;
        this.passwordField = passwordField;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schemaName;
    }

    public String getParentDirectory() {
        return null;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = new MemoryDirectorySession(this);
        }
        this.addSession((Session)this.session);
        return this.session;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.session = null;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }
}

