/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.naming.GenericNamingResourcesFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.DataSourceHelper;
import org.nuxeo.runtime.datasource.PooledDataSourceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@XObject(value="datasource")
public class DataSourceDescriptor {
    @XNode(value="@name")
    protected String name;
    @XNode(value="@xaDataSource")
    protected String xaDataSource;
    @XNode(value="@dataSource")
    protected String dataSource;
    @XNode(value="@driverClassName")
    protected String driverClasssName;
    @XNode(value="")
    public Element element;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> properties;
    protected Reference poolReference;
    protected Reference xaReference;

    public String getName() {
        return Framework.expandVars((String)this.name);
    }

    public String getXaDataSource() {
        return Framework.expandVars((String)this.xaDataSource);
    }

    public String getDataSource() {
        return Framework.expandVars((String)this.dataSource);
    }

    public String getDriverClasssName() {
        return Framework.expandVars((String)this.driverClasssName);
    }

    public void bindSelf(Context naming) throws NamingException {
        StringRefAddr addr;
        String value;
        if (this.xaDataSource != null) {
            String xaName = DataSourceHelper.relativize(this.getName() + "-xa");
            this.poolReference = new Reference(XADataSource.class.getName(), PoolFactory.class.getName(), null);
            this.poolReference.add(new StringRefAddr("dataSourceJNDI", xaName));
            this.xaReference = new Reference(Framework.expandVars((String)this.xaDataSource), GenericNamingResourcesFactory.class.getName(), null);
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                String key = e.getKey();
                value = Framework.expandVars((String)e.getValue());
                addr = new StringRefAddr(key, value);
                this.xaReference.add(addr);
            }
            naming.bind(DataSourceHelper.getDataSourceJNDIName(xaName), (Object)this.xaReference);
        } else if (this.dataSource != null) {
            this.poolReference = new Reference(DataSource.class.getName(), PoolFactory.class.getName(), null);
            String name = Framework.expandVars((String)this.dataSource);
            this.poolReference.add(new StringRefAddr("dataSourceJNDI", DataSourceHelper.getDataSourceJNDIName(name)));
        } else if (this.driverClasssName != null) {
            this.poolReference = new Reference(DataSource.class.getName(), PoolFactory.class.getName(), null);
        } else {
            throw new RuntimeException("Datasource " + this.getName() + " should have xaDataSource or driverClassName attribute");
        }
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            String key = e.getKey();
            String value2 = Framework.expandVars((String)e.getValue());
            StringRefAddr addr2 = new StringRefAddr(key, value2);
            this.poolReference.add(addr2);
        }
        NamedNodeMap attrs = this.element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String attrName = attr.getNodeName();
            value = Framework.expandVars((String)attr.getNodeValue());
            addr = new StringRefAddr(attrName, value);
            this.poolReference.add(addr);
        }
        LogFactory.getLog(DataSourceDescriptor.class).info((Object)("binding " + this.getName()));
        String jndiName = DataSourceHelper.getDataSourceJNDIName(this.getName());
        naming.bind(jndiName, (Object)this.poolReference);
        naming.lookup(jndiName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindSelf(Context naming) throws NamingException {
        try {
            PooledDataSourceRegistry registry = (PooledDataSourceRegistry)Framework.getLocalService(PooledDataSourceRegistry.class);
            if (registry != null) {
                registry.clearPool(this.getName());
            }
        }
        finally {
            try {
                if (this.xaReference != null) {
                    naming.unbind(DataSourceHelper.getDataSourceJNDIName(this.getName() + "-xa"));
                }
            }
            finally {
                naming.unbind(DataSourceHelper.getDataSourceJNDIName(this.getName()));
            }
        }
    }

    public static class PoolFactory
    implements ObjectFactory {
        @Override
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> env) {
            return ((PooledDataSourceRegistry)Framework.getService(PooledDataSourceRegistry.class)).getOrCreatePool(obj, name, nameCtx, env);
        }
    }
}

