/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.commands;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.runtime.api.Framework;

public class IndexingCommand
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String INSERT = "ES_INSERT";
    public static final String UPDATE = "ES_UPDATE";
    public static final String UPDATE_SECURITY = "ES_UPDATE_SECURITY";
    public static final String DELETE = "ES_DELETE";
    public static final String PREFIX = "IndexingCommand-";
    public static final String UNKOWN_DOCUMENT_ID = "unknown";
    protected String name;
    protected boolean sync;
    protected boolean recurse;
    protected transient DocumentModel targetDocument;
    protected String uid;
    protected String path;
    protected String repository;
    protected String id;
    protected List<String> schemas;
    protected static final Log log = LogFactory.getLog(IndexingCommand.class);
    protected transient Event indexingEvent;

    protected IndexingCommand() {
    }

    public IndexingCommand(DocumentModel targetDocument, String command, boolean sync, boolean recurse) {
        assert (!sync || !recurse || DELETE.equals(command));
        this.id = PREFIX + UUID.randomUUID().toString();
        this.name = command;
        this.sync = sync;
        this.recurse = recurse;
        if (targetDocument == null) {
            this.uid = UNKOWN_DOCUMENT_ID;
            this.repository = this.getDefaultRepository();
            this.targetDocument = null;
        } else {
            DocumentModel doc;
            this.targetDocument = doc = this.getValidTargetDocument(targetDocument);
            this.repository = doc.getRepositoryName();
            this.uid = doc.getId();
        }
        this.markUpdated();
        assert (this.uid != null) : "Invalid IndexingCommand with a null doc id";
    }

    private DocumentModel getValidTargetDocument(DocumentModel target) {
        if (target.getId() != null) {
            return target;
        }
        DocumentRef documentRef = target.getRef();
        log.warn((Object)("Processing indexing command on a document with a null id: " + documentRef + " activate trace level for more info."));
        if (log.isTraceEnabled()) {
            Throwable throwable = new Throwable();
            StringWriter stack = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stack));
            log.trace((Object)("You should use a document returned by session.createDocument, stack " + stack.toString()));
        }
        return target.getCoreSession().getDocument(documentRef);
    }

    private String getDefaultRepository() {
        RepositoryManager mgr = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        return mgr.getDefaultRepository().getName();
    }

    public IndexingCommand(DocumentModel targetDocument, boolean sync, boolean recurse) {
        this(targetDocument, INSERT, sync, recurse);
    }

    public void refresh(CoreSession session) throws ClientException {
        IdRef idref = new IdRef(this.uid);
        if (this.uid != null && session.exists((DocumentRef)idref)) {
            this.targetDocument = session.getDocument((DocumentRef)idref);
        } else {
            log.info((Object)("Can not refresh document because it was deleted: " + idref));
        }
        this.markUpdated();
    }

    public String getRepository() {
        return this.repository;
    }

    public void merge(IndexingCommand other) {
        this.merge(other.sync, other.recurse);
    }

    public void merge(boolean sync, boolean recurse) {
        this.sync = this.sync || sync;
        this.recurse = this.recurse || recurse;
        this.markUpdated();
    }

    public boolean canBeMerged(IndexingCommand other) {
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (DELETE.equals(this.name)) {
            return true;
        }
        return !other.sync && !this.sync || !other.recurse && !this.recurse;
    }

    public boolean isSync() {
        return this.sync;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public String getName() {
        return this.name;
    }

    public DocumentModel getTargetDocument() {
        return this.targetDocument;
    }

    public String toJSON() throws IOException {
        StringWriter out = new StringWriter();
        JsonFactory factory = new JsonFactory();
        JsonGenerator jsonGen = factory.createJsonGenerator((Writer)out);
        this.toJSON(jsonGen);
        out.flush();
        jsonGen.close();
        return out.toString();
    }

    public void toJSON(JsonGenerator jsonGen) throws IOException {
        jsonGen.writeStartObject();
        jsonGen.writeStringField("id", this.id);
        jsonGen.writeStringField("name", this.name);
        jsonGen.writeStringField("docId", this.getDocId());
        if (this.targetDocument != null) {
            jsonGen.writeStringField("path", this.targetDocument.getPathAsString());
        }
        jsonGen.writeStringField("repo", this.getRepository());
        jsonGen.writeBooleanField("recurse", this.recurse);
        jsonGen.writeBooleanField("sync", this.sync);
        jsonGen.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexingCommand fromJSON(CoreSession session, String json) throws ClientException {
        IndexingCommand indexingCommand;
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jp = jsonFactory.createJsonParser(json);
        try {
            indexingCommand = IndexingCommand.fromJSON(session, jp);
        }
        catch (Throwable throwable) {
            try {
                jp.close();
                throw throwable;
            }
            catch (IOException e) {
                throw ClientException.wrap((Throwable)e);
            }
        }
        jp.close();
        return indexingCommand;
    }

    public static IndexingCommand fromJSON(CoreSession session, JsonParser jp) throws IOException {
        IndexingCommand cmd = new IndexingCommand();
        JsonToken token = jp.nextToken();
        if (token != JsonToken.START_OBJECT) {
            return null;
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if ("name".equals(fieldname)) {
                cmd.name = jp.getText();
                continue;
            }
            if ("docId".equals(fieldname)) {
                cmd.uid = jp.getText();
                continue;
            }
            if ("path".equals(fieldname)) {
                cmd.path = jp.getText();
                continue;
            }
            if ("repo".equals(fieldname)) {
                cmd.repository = jp.getText();
                continue;
            }
            if ("id".equals(fieldname)) {
                cmd.id = jp.getText();
                continue;
            }
            if ("recurse".equals(fieldname)) {
                cmd.recurse = jp.getBooleanValue();
                continue;
            }
            if (!"sync".equals(fieldname)) continue;
            cmd.sync = jp.getBooleanValue();
        }
        if (cmd.uid != null) {
            if (!session.getRepositoryName().equals(cmd.repository)) {
                log.error((Object)("Unable to restore doc from repository " + cmd.repository + " with a session on repository " + session.getRepositoryName()));
            } else {
                IdRef ref = new IdRef(cmd.uid);
                if (!session.exists((DocumentRef)ref)) {
                    if (!DELETE.equals(cmd.getName())) {
                        log.warn((Object)("Unable to retrieve document " + cmd.uid + " form indexing command " + cmd.name));
                    }
                } else {
                    cmd.targetDocument = session.getDocument((DocumentRef)ref);
                }
            }
        }
        return cmd;
    }

    public String getId() {
        return this.id;
    }

    public String getDocId() {
        return this.uid;
    }

    public IndexingCommand clone(DocumentModel newDoc) {
        return new IndexingCommand(newDoc, this.name, this.sync, this.recurse);
    }

    public String[] getSchemas() {
        String[] ret = null;
        if (this.schemas != null && this.schemas.size() > 0) {
            ret = this.schemas.toArray(new String[this.schemas.size()]);
        } else if (this.targetDocument != null) {
            ret = this.targetDocument.getSchemas();
        }
        return ret;
    }

    public void addSchemas(String schema) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>();
        }
        if (!this.schemas.contains(schema)) {
            this.schemas.add(schema);
        }
        this.markUpdated();
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public void computeIndexingEvent() {
        if (this.getTargetDocument() != null) {
            CoreSession session = this.getTargetDocument().getCoreSession();
            if (session != null) {
                EventContextImpl context = new EventContextImpl(session, session.getPrincipal());
                this.indexingEvent = context.newEvent("ESIndexSyncTrigger");
            } else if (Framework.isInitialized()) {
                log.error((Object)String.format("Unable to generate event, no session found for cmd: %s, sessionid: %s", this.toString(), this.getTargetDocument().getSessionId()));
            }
        }
    }

    public Event asIndexingEvent() throws IOException {
        if (this.indexingEvent == null) {
            this.computeIndexingEvent();
        }
        if (this.indexingEvent != null) {
            this.indexingEvent.getContext().getProperties().put(this.getId(), this.toJSON());
        }
        return this.indexingEvent;
    }

    protected void markUpdated() {
        this.indexingEvent = null;
        if (this.sync) {
            this.computeIndexingEvent();
        }
    }

    public void makeSync() {
        if (!(this.sync || this.recurse && !DELETE.equals(this.name))) {
            this.sync = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Turn command into sync: " + this.toString()));
            }
            this.markUpdated();
        }
    }

    public void disconnect() {
        this.targetDocument = null;
    }
}

