/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.fetcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.elasticsearch.fetcher.Fetcher;

public class VcsFetcher
extends Fetcher {
    public VcsFetcher(CoreSession session, SearchResponse response, Map<String, String> repoNames) {
        super(session, response, repoNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentModelListImpl fetchDocuments() {
        Map<String, List<String>> repoHits = this.getHitsPerRepository();
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
        String openSessionRepository = this.getSession().getRepositoryName();
        for (String repo : repoHits.keySet()) {
            boolean closeSession;
            CoreSession session;
            if (openSessionRepository.equals(repo)) {
                session = this.getSession();
                closeSession = false;
            } else {
                session = CoreInstance.openCoreSession((String)repo);
                closeSession = true;
            }
            try {
                docs.addAll(this.fetchFromVcs(repoHits.get(repo), session));
            }
            finally {
                if (!closeSession) continue;
                session.close();
            }
        }
        this.sortResults(docs);
        DocumentModelListImpl ret = new DocumentModelListImpl(docs.size());
        if (!docs.isEmpty()) {
            ret.addAll(docs);
        }
        return ret;
    }

    private Map<String, List<String>> getHitsPerRepository() {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (SearchHit hit : this.getResponse().getHits()) {
            String repoName = this.getRepoForIndex(hit.getIndex());
            ArrayList<String> docIds = (ArrayList<String>)ret.get(repoName);
            if (docIds == null) {
                docIds = new ArrayList<String>();
                ret.put(repoName, docIds);
            }
            docIds.add(hit.getId());
        }
        return ret;
    }

    private List<DocumentModel> fetchFromVcs(List<String> ids, CoreSession session) throws ClientException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM Document, Relation WHERE ecm:uuid IN (");
        for (int i = 0; i < ids.size(); ++i) {
            sb.append(NXQL.escapeString((String)ids.get(i)));
            if (i >= ids.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return session.query(sb.toString());
    }

    private void sortResults(List<DocumentModel> docs) {
        final ArrayList<String> ids = new ArrayList<String>();
        for (SearchHit hit : this.getResponse().getHits()) {
            ids.add(this.getRepoForIndex(hit.getIndex()) + hit.getId());
        }
        Collections.sort(docs, new Comparator<DocumentModel>(){

            @Override
            public int compare(DocumentModel a, DocumentModel b) {
                return ids.indexOf(a.getRepositoryName() + a.getId()) - ids.indexOf(b.getRepositoryName() + b.getId());
            }
        });
    }
}

