/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.work.BaseIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractIndexingWorker
extends BaseIndexingWorker {
    private static final long serialVersionUID = 1L;
    protected final IndexingCommand cmd;
    protected final String path;

    public AbstractIndexingWorker(IndexingCommand cmd) {
        this.cmd = cmd;
        this.path = cmd.getTargetDocument().getPathAsString();
        cmd.disconnect();
    }

    @Override
    public void doWork() {
        CoreSession session = this.initSession(this.repositoryName);
        ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getLocalService(ElasticSearchIndexing.class);
        this.cmd.refresh(session);
        this.doIndexingWork(esi, this.cmd);
    }

    protected abstract void doIndexingWork(ElasticSearchIndexing var1, IndexingCommand var2);
}

