/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.work.AbstractIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public class ChildrenIndexingWorker
extends AbstractIndexingWorker
implements Work {
    private static final long serialVersionUID = 1L;

    public ChildrenIndexingWorker(IndexingCommand cmd) {
        super(cmd);
    }

    public String getTitle() {
        String title = " ElasticSearch indexing children for doc " + this.cmd.getDocId() + " in repository " + this.cmd.getRepository();
        if (this.path != null) {
            title = title + " (" + this.path + ")";
        }
        return title;
    }

    @Override
    protected void doIndexingWork(ElasticSearchIndexing esi, IndexingCommand cmd) {
        DocumentModel doc = cmd.getTargetDocument();
        DocumentModelIterator iter = this.session.getChildrenIterator(doc.getRef());
        while (iter.hasNext()) {
            this.session.save();
            DocumentModel child = (DocumentModel)iter.next();
            IndexingCommand childCommand = cmd.clone(child);
            if (!esi.isAlreadyScheduled(childCommand)) {
                esi.indexNow(childCommand);
            }
            if (!child.isFolder()) continue;
            ChildrenIndexingWorker subWorker = new ChildrenIndexingWorker(childCommand);
            WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
            wm.schedule((Work)subWorker);
        }
    }
}

