/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.work.AbstractIndexingWorker;
import org.nuxeo.elasticsearch.work.ChildrenIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public class IndexingWorker
extends AbstractIndexingWorker
implements Work {
    private static final long serialVersionUID = 1L;
    protected final List<String> recursableCommands = Arrays.asList("ES_UPDATE", "ES_INSERT", "ES_UPDATE_SECURITY");

    public IndexingWorker(IndexingCommand cmd) {
        super(cmd);
    }

    public String getTitle() {
        String title = " ElasticSearch indexing for doc " + this.cmd.getDocId() + " in repository " + this.cmd.getRepository();
        if (this.path != null) {
            title = title + " (" + this.path + ")";
        }
        return title;
    }

    protected boolean needRecurse(IndexingCommand cmd) {
        return cmd.isRecurse() && this.recursableCommands.contains(cmd.getName());
    }

    @Override
    protected void doIndexingWork(ElasticSearchIndexing esi, IndexingCommand cmd) {
        esi.indexNow(cmd);
        if (this.needRecurse(cmd)) {
            ChildrenIndexingWorker subWorker = new ChildrenIndexingWorker(cmd);
            WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
            wm.schedule((Work)subWorker);
        }
    }
}

