/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.constraints;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public abstract class AbstractConstraint
implements Constraint {
    private static final long serialVersionUID = 1L;
    private static final String HARD_CODED_CONTRAINT_ERROR_MESSAGE = "The constraint '%s' failed for value %s";

    public final String toString() {
        return this.getDescription().toString();
    }

    @Override
    public String getErrorMessage(Object invalidValue, Locale locale) {
        Locale computedLocale;
        Object[] params;
        String message;
        ArrayList<String> pathTokens = new ArrayList<String>();
        pathTokens.add("label.schema.constraint.violation");
        pathTokens.add(this.getDescription().getName());
        String keyConstraint = StringUtils.join(pathTokens, (char)'.');
        String computedInvalidValue = "null";
        if (invalidValue != null) {
            String invalidValueString = invalidValue.toString();
            computedInvalidValue = invalidValueString.length() > 20 ? invalidValueString.substring(0, 15) + "..." : invalidValueString;
        }
        if ((message = I18NUtils.getMessageString((String)"messages", (String)keyConstraint, (Object[])(params = new Object[]{computedInvalidValue}), (Locale)(computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG))) != null && !message.trim().isEmpty() && !keyConstraint.equals(message)) {
            return message;
        }
        params = new Object[]{computedInvalidValue, this.toString()};
        message = I18NUtils.getMessageString((String)"messages", (String)"label.schema.constraint.violation", (Object[])params, (Locale)computedLocale);
        if (message != null && !message.trim().isEmpty() && !keyConstraint.equals(message)) {
            return message;
        }
        return String.format(HARD_CODED_CONTRAINT_ERROR_MESSAGE, this.toString(), computedInvalidValue);
    }
}

