/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.constraints;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.schema.types.constraints.AbstractConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.ConstraintUtils;

public class NumericIntervalConstraint
extends AbstractConstraint {
    private static final long serialVersionUID = 3630463971175189087L;
    private static final String NAME = "NumericIntervalConstraint";
    private static final String PNAME_MINIMUM = "Minimum";
    private static final String PNAME_MAXIMUM = "Maximum";
    private static final String PNAME_MIN_INC = "MinimumInclusive";
    private static final String PNAME_MAX_INC = "MaximumInclusive";
    private final BigDecimal min;
    private final BigDecimal max;
    private final boolean includingMin;
    private final boolean includingMax;

    public NumericIntervalConstraint(Object min, boolean includingMin, Object max, boolean includingMax) {
        this.min = ConstraintUtils.objectToBigDecimal(min);
        this.includingMin = includingMin;
        this.max = ConstraintUtils.objectToBigDecimal(max);
        this.includingMax = includingMax;
    }

    @Override
    public boolean validate(Object object) {
        int test;
        BigDecimal val = ConstraintUtils.objectToBigDecimal(object);
        if (val == null) {
            return true;
        }
        if (this.min != null) {
            test = this.min.compareTo(val);
            if (test > 0) {
                return false;
            }
            if (!this.includingMin && test == 0) {
                return false;
            }
        }
        if (this.max != null) {
            test = this.max.compareTo(val);
            if (test < 0) {
                return false;
            }
            if (!this.includingMax && test == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Constraint.Description getDescription() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        if (this.min != null) {
            params.put(PNAME_MINIMUM, this.min);
            params.put(PNAME_MIN_INC, Boolean.valueOf(this.includingMin));
        }
        if (this.max != null) {
            params.put(PNAME_MAXIMUM, this.max);
            params.put(PNAME_MAX_INC, Boolean.valueOf(this.includingMax));
        }
        return new Constraint.Description(NAME, params);
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public boolean isIncludingMin() {
        return this.includingMin;
    }

    public boolean isIncludingMax() {
        return this.includingMax;
    }

    @Override
    public String getErrorMessage(Object invalidValue, Locale locale) {
        String subKey = (this.min != null ? (this.includingMin ? "minin" : "minex") : "") + (this.max != null ? (this.includingMax ? "maxin" : "maxex") : "");
        Object[] params = this.min != null && this.max != null ? new Object[]{this.min, this.max} : (this.min != null ? new Object[]{this.min} : new Object[]{this.max});
        ArrayList<String> pathTokens = new ArrayList<String>();
        pathTokens.add("label.schema.constraint.violation");
        pathTokens.add(NAME);
        pathTokens.add(subKey);
        String key = StringUtils.join(pathTokens, (char)'.');
        Locale computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG;
        String message = I18NUtils.getMessageString((String)"messages", (String)key, (Object[])params, (Locale)computedLocale);
        if (message != null && !message.trim().isEmpty() && !key.equals(message)) {
            return message;
        }
        return super.getErrorMessage(invalidValue, computedLocale);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includingMax ? 1231 : 1237);
        result = 31 * result + (this.includingMin ? 1231 : 1237);
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericIntervalConstraint other = (NumericIntervalConstraint)obj;
        if (this.includingMax != other.includingMax) {
            return false;
        }
        if (this.includingMin != other.includingMin) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        return !(this.min == null ? other.min != null : !this.min.equals(other.min));
    }
}

