/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.resolver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public interface ObjectResolver {
    public void configure(Map<String, String> var1) throws IllegalArgumentException, IllegalArgumentException;

    public String getName();

    public Map<String, Serializable> getParameters();

    public boolean validate(Object var1);

    public Object fetch(Object var1);

    public <T> T fetch(Class<T> var1, Object var2);

    public Serializable getReference(Object var1);

    public String getConstraintErrorMessage(Object var1, Locale var2);

    public static final class Helper {
        private Helper() {
        }

        public static String getConstraintErrorMessage(ObjectResolver resolver, String suffixCase, Object invalidValue, Locale locale, String ... additionnalParameters) {
            ArrayList<String> pathTokens = new ArrayList<String>();
            pathTokens.add("label.schema.constraint.violation");
            pathTokens.add("resolver");
            pathTokens.add(resolver.getName());
            if (suffixCase != null) {
                pathTokens.add(suffixCase);
            }
            String keyConstraint = StringUtils.join(pathTokens, (char)'.');
            String computedInvalidValue = "null";
            if (invalidValue != null) {
                String invalidValueString = invalidValue.toString();
                computedInvalidValue = invalidValueString.length() > 20 ? invalidValueString.substring(0, 15) + "..." : invalidValueString;
            }
            Object[] params = new Object[1 + additionnalParameters.length];
            params[0] = computedInvalidValue;
            for (int i = 1; i < params.length; ++i) {
                params[i] = additionnalParameters[i - 1];
            }
            Locale computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG;
            String message = I18NUtils.getMessageString((String)"messages", (String)keyConstraint, (Object[])params, (Locale)computedLocale);
            if (message != null && !message.trim().isEmpty() && !keyConstraint.equals(message)) {
                return message;
            }
            return String.format("%s cannot resolve reference %s", resolver.getName(), computedInvalidValue);
        }

        public static String getConstraintErrorMessage(ObjectResolver resolver, Object invalidValue, Locale locale, String ... additionnalParameters) {
            return Helper.getConstraintErrorMessage(resolver, null, invalidValue, locale, additionnalParameters);
        }
    }
}

