/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.resolver;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;

public class TestingColorResolver
implements ObjectResolver {
    public static final String COLOR_MODE = "mode";
    public static final String NAME = "colorReference";
    private MODE mode;
    private Map<String, Serializable> parameters;

    @Override
    public void configure(Map<String, String> parameters) throws IllegalStateException, IllegalArgumentException {
        if (this.parameters != null) {
            throw new IllegalStateException("cannot change configuration, may be already in use somewhere");
        }
        String modeParam = parameters.get(COLOR_MODE);
        if (modeParam == null || modeParam.trim().isEmpty()) {
            throw new IllegalArgumentException("missing mode param");
        }
        try {
            this.mode = MODE.valueOf(modeParam);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("missing mode param", e);
        }
        this.parameters = new HashMap<String, Serializable>();
        this.parameters.put(COLOR_MODE, (Serializable)((Object)this.mode.name()));
    }

    @Override
    public String getName() throws IllegalStateException {
        this.checkConfig();
        return NAME;
    }

    @Override
    public Map<String, Serializable> getParameters() throws IllegalStateException {
        this.checkConfig();
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public boolean validate(Object value) throws IllegalStateException {
        this.checkConfig();
        return this.fetch(value) != null;
    }

    @Override
    public Color fetch(Object value) throws IllegalStateException {
        this.checkConfig();
        if (value instanceof String) {
            String ref = (String)value;
            switch (this.mode) {
                case PRIMARY: {
                    for (PrimaryColor color : PrimaryColor.values()) {
                        if (!color.name().equals(ref)) continue;
                        return color;
                    }
                    break;
                }
                case SECONDARY: {
                    for (SecondaryColor color : SecondaryColor.values()) {
                        if (!color.name().equals(ref)) continue;
                        return color;
                    }
                    break;
                }
            }
        }
        return null;
    }

    @Override
    public <T> T fetch(Class<T> type, Object value) throws IllegalStateException {
        this.checkConfig();
        if (Color.class.equals(type)) {
            return (T)this.fetch(value);
        }
        if (this.mode == MODE.PRIMARY && PrimaryColor.class.equals(type)) {
            return (T)this.fetch(value);
        }
        if (this.mode == MODE.SECONDARY && SecondaryColor.class.equals(type)) {
            return (T)this.fetch(value);
        }
        return null;
    }

    @Override
    public Serializable getReference(Object entity) throws IllegalStateException {
        Color color;
        this.checkConfig();
        if (entity instanceof Color && (color = (Color)entity) != null) {
            switch (this.mode) {
                case PRIMARY: {
                    if (!(color instanceof PrimaryColor)) break;
                    return color.name();
                }
                case SECONDARY: {
                    if (!(color instanceof SecondaryColor)) break;
                    return color.name();
                }
            }
        }
        return null;
    }

    @Override
    public String getConstraintErrorMessage(Object invalidValue, Locale locale) {
        this.checkConfig();
        return String.format("\"%s\" is not a correct %s color", invalidValue, this.mode.name().toLowerCase());
    }

    private void checkConfig() throws IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("you should call #configure(Map<String, String>) before. Please get this resolver throught ExternalReferenceService which is in charge of resolver configuration.");
        }
    }

    public static enum SecondaryColor implements Color
    {
        VIOLET,
        ORANGE,
        GREEN;

    }

    public static enum PrimaryColor implements Color
    {
        RED,
        BLUE,
        YELLOW;

    }

    public static interface Color {
        public String name();
    }

    public static enum MODE {
        PRIMARY,
        SECONDARY;

    }
}

