/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="tagActions")
@Scope(value=ScopeType.CONVERSATION)
public class TagActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TagActionsBean.class);
    public static final String TAG_SEARCH_RESULT_PAGE = "tag_search_results";
    public static final String SELECTION_EDITED = "selectionEdited";
    public static final String DOCUMENTS_IMPORTED = "documentImported";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    protected String listLabel;
    private String tagLabel;
    private boolean addTag;
    @RequestParameter
    protected Boolean canSelectNewTag;

    @Factory(value="tagServiceEnabled", scope=ScopeType.APPLICATION)
    public boolean isTagServiceEnabled() throws ClientException {
        return this.getTagService() != null;
    }

    protected TagService getTagService() {
        TagService tagService = (TagService)Framework.getService(TagService.class);
        return tagService.isEnabled() ? tagService : null;
    }

    @Factory(value="currentDocumentTags", scope=ScopeType.EVENT)
    public List<Tag> getDocumentTags() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return new ArrayList<Tag>(0);
        }
        String docId = currentDocument.getId();
        List tags = this.getTagService().getDocumentTags(this.documentManager, docId, null);
        Collections.sort(tags, Tag.LABEL_COMPARATOR);
        return tags;
    }

    @Deprecated
    public static String getDocIdForTag(DocumentModel doc) {
        return doc.isProxy() ? doc.getSourceId() : doc.getId();
    }

    public String addTagging() throws ClientException {
        String messageKey;
        this.tagLabel = TagActionsBean.cleanLabel(this.tagLabel);
        if (StringUtils.isBlank((String)this.tagLabel)) {
            messageKey = "message.add.new.tagging.not.empty";
        } else {
            DocumentRef ref;
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            String docId = currentDocument.getId();
            TagService tagService = this.getTagService();
            tagService.tag(this.documentManager, docId, this.tagLabel, null);
            if (currentDocument.isVersion()) {
                DocumentModel liveDocument = this.documentManager.getSourceDocument(currentDocument.getRef());
                if (!liveDocument.isCheckedOut()) {
                    tagService.tag(this.documentManager, liveDocument.getId(), this.tagLabel, null);
                }
            } else if (!currentDocument.isCheckedOut() && (ref = this.documentManager.getBaseVersion(currentDocument.getRef())) instanceof IdRef) {
                tagService.tag(this.documentManager, ref.toString(), this.tagLabel, null);
            }
            messageKey = "message.add.new.tagging";
            Contexts.getEventContext().remove("currentDocumentTags");
        }
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(messageKey), new Object[]{this.tagLabel});
        this.reset();
        return null;
    }

    public String removeTagging(String label) throws ClientException {
        DocumentRef ref;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String docId = currentDocument.getId();
        TagService tagService = this.getTagService();
        tagService.untag(this.documentManager, docId, label, null);
        if (currentDocument.isVersion()) {
            DocumentModel liveDocument = this.documentManager.getSourceDocument(currentDocument.getRef());
            if (!liveDocument.isCheckedOut()) {
                tagService.untag(this.documentManager, liveDocument.getId(), label, null);
            }
        } else if (!currentDocument.isCheckedOut() && (ref = this.documentManager.getBaseVersion(currentDocument.getRef())) instanceof IdRef) {
            tagService.untag(this.documentManager, ref.toString(), label, null);
        }
        this.reset();
        Contexts.getEventContext().remove("currentDocumentTags");
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("message.remove.tagging"), new Object[]{label});
        return null;
    }

    @Factory(value="tagCloudOnAllDocuments", scope=ScopeType.EVENT)
    public List<Tag> getPopularCloudOnAllDocuments() throws ClientException {
        List cloud = this.getTagService().getTagCloud(this.documentManager, null, null, Boolean.TRUE);
        double min = 100.0;
        double max = 200.0;
        for (Tag tag : cloud) {
            tag.setWeight((long)(min + (double)tag.getWeight() * (max - min) / 100.0));
        }
        Collections.sort(cloud, Tag.LABEL_COMPARATOR);
        return cloud;
    }

    public String listDocumentsForTag(String listLabel) throws ClientException {
        this.listLabel = listLabel;
        return TAG_SEARCH_RESULT_PAGE;
    }

    @Factory(value="taggedDocuments", scope=ScopeType.EVENT)
    public DocumentModelList getChildrenSelectModel() throws ClientException {
        if (StringUtils.isBlank((String)this.listLabel)) {
            return new DocumentModelListImpl(0);
        }
        List ids = this.getTagService().getTagDocumentIds(this.documentManager, this.listLabel, null);
        DocumentModelListImpl docs = new DocumentModelListImpl(ids.size());
        DocumentModel doc = null;
        for (String id : ids) {
            try {
                doc = this.documentManager.getDocument((DocumentRef)new IdRef(id));
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
            if (doc == null) continue;
            docs.add((Object)doc);
            doc = null;
        }
        return docs;
    }

    public String getListLabel() {
        return this.listLabel;
    }

    public void setListLabel(String listLabel) {
        this.listLabel = listLabel;
    }

    public boolean canModifyTag(Tag tag) {
        return tag != null;
    }

    public void reset() {
        this.tagLabel = null;
    }

    public void showAddTag(ActionEvent event) {
        this.addTag = !this.addTag;
    }

    public String getTagLabel() {
        return this.tagLabel;
    }

    public void setTagLabel(String tagLabel) {
        this.tagLabel = tagLabel;
    }

    public boolean getAddTag() {
        return this.addTag;
    }

    public void setAddTag(boolean addTag) {
        this.addTag = addTag;
    }

    public List<Tag> getSuggestions(Object input) throws ClientException {
        String label = (String)input;
        List<Tag> tags = this.getTagService().getSuggestions(this.documentManager, label, null);
        Collections.sort(tags, Tag.LABEL_COMPARATOR);
        if (tags.size() > 10) {
            tags = tags.subList(0, 10);
        }
        label = TagActionsBean.cleanLabel(label);
        if (Boolean.TRUE.equals(this.canSelectNewTag) && !tags.contains(new Tag(label, 0))) {
            tags.add(0, new Tag(label, -1));
        }
        return tags;
    }

    protected static String cleanLabel(String label) {
        label = label.toLowerCase();
        label = label.replace(" ", "");
        label = label.replace("\\", "");
        label = label.replace("'", "");
        label = label.replace("%", "");
        return label;
    }

    @Observer(value={"selectionEdited", "documentImported"})
    public void addTagsOnEvent(List<DocumentModel> documents, DocumentModel docModel) throws ClientException {
        List tags = (List)((Object)docModel.getContextData(org.nuxeo.common.collections.ScopeType.REQUEST, "bulk_tags"));
        if (tags != null && !tags.isEmpty()) {
            TagService tagService = (TagService)Framework.getLocalService(TagService.class);
            String username = this.documentManager.getPrincipal().getName();
            for (DocumentModel doc : documents) {
                for (String tag : tags) {
                    tagService.tag(this.documentManager, doc.getId(), tag, username);
                }
            }
        }
    }

    @Observer(value={"documentSelectionChanged"}, create=false)
    @BypassInterceptors
    public void documentChanged() {
        this.addTag = false;
    }
}

