/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.detectors;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.jmimemagic.MagicDetector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;

public class OOoMimetypeSniffer
implements MagicDetector {
    private static final Log log = LogFactory.getLog(OOoMimetypeSniffer.class);

    public String getDisplayName() {
        return "OOo 1.x & OpenDocument MimeType Detector";
    }

    public String[] getHandledExtensions() {
        return new String[]{"ods", "ots", "odt", "ott", "odp", "otp", "odg", "otg", "otm", "oth", "odi", "oti", "odf", "otf", "odc", "otc", "sxw", "stw", "sxg", "sxc", "stc", "sxi", "sti", "sxd", "std", "sxm"};
    }

    public String[] getHandledTypes() {
        return new String[]{"application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.spreadsheet-template", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.presentation-template", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.graphics-template", "application/vnd.oasis.opendocument.text-master", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.image", "application/vnd.oasis.opendocument.image-template", "application/vnd.oasis.opendocument.formula", "application/vnd.oasis.opendocument.formula-template", "application/vnd.oasis.opendocument.chart", "application/vnd.oasis.opendocument.chart-template", "application/vnd.sun.xml.writer", "application/vnd.sun.xml.writer.template", "application/vnd.sun.xml.writer.global", "application/vnd.sun.xml.calc", "application/vnd.sun.xml.calc.template", "application/vnd.sun.xml.impress", "application/vnd.sun.xml.impress.template", "application/vnd.sun.xml.draw", "application/vnd.sun.xml.draw.template", "application/vnd.sun.xml.math"};
    }

    public String getName() {
        return "ooodetector";
    }

    public String getVersion() {
        return "0.2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        String[] mimetypes = new String[]{};
        File file = null;
        try {
            file = File.createTempFile("magicdetector", ".xml");
            FileUtils.writeFile((File)file, (byte[])data);
            mimetypes = this.guessOOo(file);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return mimetypes;
    }

    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        return this.guessOOo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] guessOOo(File file) {
        String[] mimetype = new String[]{};
        File tempFile = null;
        try {
            ZipFile zip = new ZipFile(file);
            ZipEntry entry = zip.getEntry("mimetype");
            if (entry != null) {
                tempFile = File.createTempFile("nxMimeTypeDetector_", ".dir");
                tempFile.delete();
                if (!tempFile.isDirectory()) {
                    tempFile.mkdir();
                }
                ZipUtils.unzip((File)file, (File)tempFile);
                String path = tempFile.getAbsolutePath();
                path = path + File.separator + "mimetype";
                File mimetypeFile = new File(path);
                mimetype = new String[]{FileUtils.readFile((File)mimetypeFile)};
            }
            if (tempFile == null) return mimetype;
        }
        catch (IOException e) {
            if (tempFile == null) return mimetype;
            FileUtils.deleteTree(tempFile);
            return mimetype;
            catch (Throwable throwable) {
                if (tempFile == null) throw throwable;
                FileUtils.deleteTree(tempFile);
                throw throwable;
            }
        }
        FileUtils.deleteTree((File)tempFile);
        return mimetype;
    }
}

