/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.detectors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.jmimemagic.MagicDetector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.nuxeo.common.utils.FileUtils;

public class XlsMimetypeSniffer
implements MagicDetector {
    private static final Log log = LogFactory.getLog(XlsMimetypeSniffer.class);

    public String getDisplayName() {
        return "XLS MimeType Detector";
    }

    public String[] getHandledExtensions() {
        return new String[]{"xls"};
    }

    public String[] getHandledTypes() {
        return new String[]{"application/vnd.ms-excel", "application/msexcel", "application/vnd.microsoft-excel"};
    }

    public String getName() {
        return "xlsdetector";
    }

    public String getVersion() {
        return "0.1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        String[] mimetypes = new String[]{""};
        File file = null;
        try {
            file = File.createTempFile("magicdetector", ".xls");
            FileUtils.writeFile((File)file, (byte[])data);
            mimetypes = this.guessExcel(file);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return mimetypes;
    }

    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        return this.guessExcel(file);
    }

    public String[] guessExcel(File file) {
        String[] mimetypes = new String[]{};
        try {
            FileInputStream stream = new FileInputStream(file);
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)stream);
            if (workbook.getNumberOfSheets() != 0) {
                mimetypes = this.getHandledTypes();
            }
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"MimeType detector : Not an excel file");
        }
        catch (IOException e) {
            log.debug((Object)"MimeType detector : Not an excel file");
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)"MimeType detector : Not an excel file");
        }
        return mimetypes;
    }
}

