/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.jsf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewDescriptor;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewImpl;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewRegistry;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewState;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewStateImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.ReferencePageProviderDescriptor;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentViewServiceImpl
extends DefaultComponent
implements ContentViewService {
    public static final String CONTENT_VIEW_EP = "contentViews";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ContentViewServiceImpl.class);
    protected ContentViewRegistry contentViewReg = new ContentViewRegistry();

    @Override
    public ContentView getContentView(String name) throws ClientException {
        Boolean showFilterForm;
        Boolean showRefreshPage;
        Boolean showPageSizeSelector;
        Boolean showTitle;
        Boolean translateEmptySentence;
        Boolean translateTitle;
        ContentViewDescriptor desc = this.contentViewReg.getContentView(name);
        if (desc == null) {
            return null;
        }
        Boolean useGlobalPageSize = desc.getUseGlobalPageSize();
        if (useGlobalPageSize == null) {
            useGlobalPageSize = Boolean.FALSE;
        }
        if ((translateTitle = desc.getTranslateTitle()) == null) {
            translateTitle = Boolean.FALSE;
        }
        if ((translateEmptySentence = desc.getTranslateEmptySentence()) == null) {
            translateEmptySentence = Boolean.FALSE;
        }
        if ((showTitle = desc.getShowTitle()) == null) {
            showTitle = Boolean.FALSE;
        }
        if ((showPageSizeSelector = desc.getShowPageSizeSelector()) == null) {
            showPageSizeSelector = Boolean.FALSE;
        }
        if ((showRefreshPage = desc.getShowRefreshCommand()) == null) {
            showRefreshPage = Boolean.TRUE;
        }
        if ((showFilterForm = desc.getShowFilterForm()) == null) {
            showFilterForm = Boolean.FALSE;
        }
        String[] queryParams = null;
        String searchDocumentType = null;
        String sortInfosBinding = null;
        String pageSizeBinding = null;
        CoreQueryPageProviderDescriptor coreDesc = desc.getCoreQueryPageProvider();
        GenericPageProviderDescriptor genDesc = desc.getGenericPageProvider();
        ReferencePageProviderDescriptor refDesc = desc.getReferencePageProvider();
        String[] refQueryParams = null;
        if (refDesc != null && refDesc.isEnabled()) {
            PageProviderService ppService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
            if (ppService == null) {
                throw new ClientException("Page provider service cannot be resolved");
            }
            PageProviderDefinition def = ppService.getPageProviderDefinition(refDesc.getName());
            if (def == null) {
                log.error((Object)("Could not resolve page provider with name " + refDesc.getName()));
            } else if (def instanceof CoreQueryPageProviderDescriptor) {
                coreDesc = (CoreQueryPageProviderDescriptor)def;
                refQueryParams = refDesc.getQueryParameters();
            } else if (def instanceof GenericPageProviderDescriptor) {
                genDesc = (GenericPageProviderDescriptor)def;
                refQueryParams = refDesc.getQueryParameters();
            }
        }
        if (coreDesc != null && coreDesc.isEnabled()) {
            queryParams = coreDesc.getQueryParameters();
            sortInfosBinding = coreDesc.getSortInfosBinding();
            pageSizeBinding = coreDesc.getPageSizeBinding();
            searchDocumentType = coreDesc.getSearchDocumentType();
        } else if (genDesc != null && genDesc.isEnabled()) {
            queryParams = genDesc.getQueryParameters();
            sortInfosBinding = genDesc.getSortInfosBinding();
            pageSizeBinding = genDesc.getPageSizeBinding();
            searchDocumentType = genDesc.getSearchDocumentType();
        }
        ArrayList<String> allQueryParams = new ArrayList<String>();
        if (queryParams != null) {
            allQueryParams.addAll(Arrays.asList(queryParams));
        }
        if (refQueryParams != null) {
            allQueryParams.addAll(Arrays.asList(refQueryParams));
        }
        String searchDocBinding = desc.getSearchDocumentBinding();
        ContentViewImpl contentView = new ContentViewImpl(name, desc.getTitle(), translateTitle, desc.getIconPath(), desc.getSelectionListName(), desc.getPagination(), desc.getActionCategories(), desc.getSearchLayout(), desc.getResultLayouts(), desc.getFlags(), desc.getCacheKey(), desc.getCacheSize(), desc.getRefreshEventNames(), desc.getResetEventNames(), useGlobalPageSize, allQueryParams.toArray(new String[0]), searchDocBinding, searchDocumentType, desc.getResultColumnsBinding(), desc.getResultLayoutBinding(), sortInfosBinding, pageSizeBinding, showTitle, showPageSizeSelector, showRefreshPage, showFilterForm, desc.getEmptySentence(), translateEmptySentence);
        return contentView;
    }

    protected ContentViewHeader getContentViewHeader(ContentViewDescriptor desc) {
        return new ContentViewHeader(desc.getName(), desc.getTitle(), Boolean.TRUE.equals(desc.getTranslateTitle()), desc.getIconPath());
    }

    @Override
    public ContentViewHeader getContentViewHeader(String name) {
        ContentViewDescriptor desc = this.contentViewReg.getContentView(name);
        if (desc == null) {
            return null;
        }
        return this.getContentViewHeader(desc);
    }

    @Override
    public Set<String> getContentViewNames() {
        return Collections.unmodifiableSet(this.contentViewReg.getContentViewNames());
    }

    @Override
    public Set<ContentViewHeader> getContentViewHeaders() {
        HashSet<ContentViewHeader> res = new HashSet<ContentViewHeader>();
        for (ContentViewDescriptor desc : this.contentViewReg.getContentViews()) {
            res.add(this.getContentViewHeader(desc));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<String> getContentViewNames(String flag) {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        Set<String> items = this.contentViewReg.getContentViewsByFlag(flag);
        if (items != null) {
            res.addAll(items);
        }
        return res;
    }

    @Override
    public Set<ContentViewHeader> getContentViewHeaders(String flag) {
        Set<String> cvs = this.getContentViewNames(flag);
        HashSet<ContentViewHeader> res = new HashSet<ContentViewHeader>();
        for (String cv : cvs) {
            ContentViewHeader header = this.getContentViewHeader(cv);
            if (header == null) continue;
            res.add(header);
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, DocumentModel searchDocument, Object ... parameters) throws ClientException {
        ContentViewDescriptor contentViewDesc = this.contentViewReg.getContentView(name);
        if (contentViewDesc == null) {
            return null;
        }
        PageProviderService ppService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        if (ppService == null) {
            throw new ClientException("Page provider service is null");
        }
        String ppName = contentViewDesc.getPageProviderName();
        PageProvider provider = ppService.getPageProvider(ppName, searchDocument, sortInfos, pageSize, currentPage, this.resolvePageProviderProperties(contentViewDesc.getPageProviderProperties()), parameters);
        return provider;
    }

    public Map<String, Serializable> resolvePageProviderProperties(Map<String, String> stringProps) throws ClientException {
        HashMap<String, Serializable> resolvedProps = new HashMap<String, Serializable>();
        for (Map.Entry<String, String> prop : stringProps.entrySet()) {
            resolvedProps.put(prop.getKey(), this.resolveProperty(prop.getValue()));
        }
        return resolvedProps;
    }

    protected Serializable resolveProperty(String elExpression) {
        FacesContext context = FacesContext.getCurrentInstance();
        Object value = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)elExpression);
        if (value != null && !(value instanceof Serializable)) {
            log.error((Object)String.format("Error processing expression '%s', result is not serializable: %s", elExpression, value));
            return null;
        }
        return (Serializable)value;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(ContentViewService.class)) {
            return (T)this;
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONTENT_VIEW_EP.equals(extensionPoint)) {
            ContentViewDescriptor desc = (ContentViewDescriptor)contribution;
            this.contentViewReg.addContribution(desc);
            this.registerPageProvider(desc);
        }
    }

    protected void registerPageProvider(ContentViewDescriptor desc) {
        PageProviderDefinition ppDef;
        ReferencePageProviderDescriptor refDesc = desc.getReferencePageProvider();
        if (refDesc != null && refDesc.isEnabled()) {
            return;
        }
        PageProviderService ppService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        if (ppService == null) {
            throw new ClientException("PageProviderService is not available");
        }
        String name = desc.getName();
        PageProviderDefinition coreDef = this.getPageProviderDefWithName(name, (PageProviderDefinition)desc.getCoreQueryPageProvider());
        PageProviderDefinition genDef = this.getPageProviderDefWithName(name, (PageProviderDefinition)desc.getGenericPageProvider());
        if (coreDef != null && genDef != null) {
            log.error((Object)String.format("Only one page provider should be registered on content view '%s': take the reference descriptor by default, then core query descriptor, and then generic descriptor", name));
        }
        PageProviderDefinition pageProviderDefinition = ppDef = coreDef != null ? coreDef : genDef;
        if (ppDef != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Register PageProvider from ContentView: %s %s", ppDef.getName(), ppDef));
            }
            ppService.registerPageProviderDefinition(ppDef);
        }
    }

    protected PageProviderDefinition getPageProviderDefWithName(String name, PageProviderDefinition ppDef) {
        if (ppDef != null && ppDef.isEnabled()) {
            if (ppDef.getName() == null) {
                ppDef.setName(name);
            }
            return ppDef;
        }
        return null;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONTENT_VIEW_EP.equals(extensionPoint)) {
            ContentViewDescriptor desc = (ContentViewDescriptor)contribution;
            this.unregisterPageProvider(desc);
            this.contentViewReg.removeContribution(desc);
        }
    }

    protected void unregisterPageProvider(ContentViewDescriptor desc) {
        PageProviderService ppService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        if (ppService == null) {
            log.info((Object)"PageProviderServer is not available, failed to unregister pp of the cv");
            return;
        }
        if (desc.getCoreQueryPageProvider() != null) {
            ppService.unregisterPageProviderDefinition((PageProviderDefinition)desc.getCoreQueryPageProvider());
        }
        if (desc.getGenericPageProvider() != null) {
            ppService.unregisterPageProviderDefinition((PageProviderDefinition)desc.getGenericPageProvider());
        }
    }

    @Override
    public ContentView restoreContentView(ContentViewState contentViewState) throws ClientException {
        if (contentViewState == null) {
            return null;
        }
        String name = contentViewState.getContentViewName();
        ContentView cv = this.getContentView(name);
        if (cv != null) {
            Long pageSize = contentViewState.getPageSize();
            cv.setCurrentPageSize(pageSize);
            DocumentModel searchDocument = contentViewState.getSearchDocumentModel();
            cv.setSearchDocumentModel(searchDocument);
            if (searchDocument != null) {
                String searchType = cv.getSearchDocumentModelType();
                if (!searchDocument.getType().equals(searchType)) {
                    log.warn((Object)String.format("Restored document type '%s' is different from the one declared on content view with name '%s': should be '%s'", searchDocument.getType(), name, searchType));
                }
            }
            Long currentPage = contentViewState.getCurrentPage();
            Object[] params = contentViewState.getQueryParameters();
            cv.getPageProvider(searchDocument, contentViewState.getSortInfos(), pageSize, currentPage, params);
            if (!cv.hasResultLayoutBinding()) {
                cv.setCurrentResultLayout(contentViewState.getResultLayout());
            }
            if (!cv.hasResultLayoutColumnsBinding()) {
                cv.setCurrentResultLayoutColumns(contentViewState.getResultColumns());
            }
        } else {
            throw new ClientException(String.format("Unknown content view with name '%s'", name));
        }
        return cv;
    }

    @Override
    public ContentViewState saveContentView(ContentView contentView) {
        if (contentView == null) {
            return null;
        }
        ContentViewStateImpl state = new ContentViewStateImpl();
        state.setContentViewName(contentView.getName());
        state.setPageSize(contentView.getCurrentPageSize());
        PageProvider<?> pp = contentView.getCurrentPageProvider();
        if (pp != null) {
            state.setPageProviderName(pp.getName());
            state.setSearchDocumentModel(pp.getSearchDocumentModel());
            state.setCurrentPage(new Long(pp.getCurrentPageIndex()));
            state.setQueryParameters(pp.getParameters());
            state.setSortInfos(pp.getSortInfos());
        } else {
            state.setSearchDocumentModel(contentView.getSearchDocumentModel());
            state.setQueryParameters(contentView.getQueryParameters());
        }
        state.setResultLayout(contentView.getCurrentResultLayout());
        state.setResultColumns(contentView.getCurrentResultLayoutColumns());
        return state;
    }
}

