/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.awt.Point;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureConversion;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractPictureAdapter
implements PictureResourceAdapter {
    private static final Log log = LogFactory.getLog(PictureResourceAdapter.class);
    public static final String VIEWS_PROPERTY = "picture:views";
    public static final String CONTENT_XPATH = "picture:views/view[%d]/content";
    public static final String FIELD_HEADLINE = "headline";
    public static final String FIELD_SUBHEADLINE = "subheadline";
    public static final String FIELD_BYLINE = "byline";
    public static final String FIELD_DATELINE = "dateline";
    public static final String FIELD_SLUGLINE = "slugline";
    public static final String FIELD_CREDIT = "credit";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELD_SOURCE = "source";
    public static final String FIELD_ORIGIN = "origin";
    public static final String FIELD_GENRE = "genre";
    public static final String FIELD_CAPTION = "caption";
    public static final String FIELD_TYPAGE = "typage";
    public static final String SCHEMA_NAME = "picture";
    public static final int MEDIUM_SIZE = 1200;
    public static final int SMALL_SIZE = 350;
    public static final int THUMB_SIZE = 150;
    protected DocumentModel doc;
    protected Integer width;
    protected Integer height;
    protected Integer depth;
    protected String description;
    protected String type;
    protected File file;
    protected Blob fileContent;
    protected ImageInfo imageInfo;
    private CoreSession session;
    private ConversionService converionService;

    @Override
    public void setDocumentModel(DocumentModel doc) {
        this.doc = doc;
    }

    protected ImagingService getImagingService() {
        return (ImagingService)Framework.getLocalService(ImagingService.class);
    }

    protected ConversionService getConversionService() throws ClientException {
        if (this.converionService == null) {
            this.converionService = (ConversionService)Framework.getService(ConversionService.class);
        }
        return this.converionService;
    }

    protected CoreSession getSession() {
        if (this.session == null) {
            if (this.doc == null) {
                return null;
            }
            this.session = this.doc.getCoreSession();
        }
        return this.session;
    }

    protected void setMetadata() throws IOException, ClientException {
        boolean imageInfoUsed = false;
        ImageInfo imageInfo = this.getImageInfo();
        if (imageInfo != null) {
            this.width = imageInfo.getWidth();
            this.height = imageInfo.getHeight();
            this.depth = imageInfo.getDepth();
            imageInfoUsed = true;
        }
        Map<String, Object> metadata = this.getImagingService().getImageMetadata(this.fileContent);
        this.description = (String)metadata.get("description");
        if (!imageInfoUsed) {
            this.width = (Integer)metadata.get("width");
            this.height = (Integer)metadata.get("height");
        }
        this.doc.setPropertyValue("picture:byline", (Serializable)((Object)((String)metadata.get("byLine"))));
        this.doc.setPropertyValue("picture:caption", (Serializable)((Object)((String)metadata.get(FIELD_CAPTION))));
        this.doc.setPropertyValue("picture:credit", (Serializable)((Object)((String)metadata.get(FIELD_CREDIT))));
        if (metadata.containsKey("dateCreated")) {
            this.doc.setPropertyValue("picture:dateline", (Serializable)((Object)metadata.get("dateCreated").toString()));
        }
        this.doc.setPropertyValue("picture:headline", (Serializable)((Object)((String)metadata.get(FIELD_HEADLINE))));
        this.doc.setPropertyValue("picture:language", (Serializable)((Object)((String)metadata.get(FIELD_LANGUAGE))));
        this.doc.setPropertyValue("picture:origin", (Serializable)((Object)((String)metadata.get("objectName"))));
        this.doc.setPropertyValue("picture:source", (Serializable)((Object)((String)metadata.get(FIELD_SOURCE))));
        this.doc.setPropertyValue("imd:image_description", (Serializable)((Object)((String)metadata.get("description"))));
        this.doc.setPropertyValue("imd:user_comment", (Serializable)((Object)((String)metadata.get("comment"))));
        this.doc.setPropertyValue("imd:equipment", (Serializable)((Object)((String)metadata.get("equipment"))));
        Date dateTimeOriginal = (Date)metadata.get("originalDate");
        if (dateTimeOriginal != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateTimeOriginal);
            this.doc.setPropertyValue("imd:date_time_original", (Serializable)calendar);
        }
        this.doc.setPropertyValue("imd:xresolution", (Serializable)((Integer)metadata.get("horizontalResolution")));
        this.doc.setPropertyValue("imd:yresolution", (Serializable)((Integer)metadata.get("verticalResolution")));
        this.doc.setPropertyValue("imd:pixel_xdimension", (Serializable)((Integer)metadata.get("pixelXDimension")));
        this.doc.setPropertyValue("imd:pixel_ydimension", (Serializable)((Integer)metadata.get("pixelYDimension")));
        this.doc.setPropertyValue("imd:copyright", (Serializable)((Object)((String)metadata.get("copyright"))));
        this.doc.setPropertyValue("imd:exposure_time", (Serializable)((Object)((String)metadata.get("exposure"))));
        this.doc.setPropertyValue("imd:iso_speed_ratings", (Serializable)((Object)((String)metadata.get("ISOspeed"))));
        this.doc.setPropertyValue("imd:focal_length", (Serializable)((Double)metadata.get("focalLength")));
        this.doc.setPropertyValue("imd:color_space", (Serializable)((Object)((String)metadata.get("colorSpace"))));
        this.doc.setPropertyValue("imd:white_balance", (Serializable)((Object)((String)metadata.get("whiteBalance"))));
        ICC_Profile iccProfile = (ICC_Profile)metadata.get("iccProfile");
        if (iccProfile != null) {
            this.doc.setPropertyValue("imd:icc_profile", (Serializable)((Object)iccProfile.toString()));
        }
        this.doc.setPropertyValue("imd:orientation", (Serializable)((Object)((String)metadata.get("orientation"))));
        this.doc.setPropertyValue("imd:fnumber", (Serializable)((Double)metadata.get("fNumber")));
        this.doc.setPropertyValue("iptc:by_line", (Serializable)((Object)((String)metadata.get("byLine"))));
        this.doc.setPropertyValue("iptc:by_line_title", (Serializable)((Object)((String)metadata.get("byLineTitle"))));
        this.doc.setPropertyValue("iptc:caption", (Serializable)((Object)((String)metadata.get(FIELD_CAPTION))));
        this.doc.setPropertyValue("iptc:category", (Serializable)((Object)((String)metadata.get("category"))));
        this.doc.setPropertyValue("iptc:city", (Serializable)((Object)((String)metadata.get("city"))));
        this.doc.setPropertyValue("iptc:copyright_notice", (Serializable)((Object)((String)metadata.get("copyrightNotice"))));
        this.doc.setPropertyValue("iptc:country_or_primary_location", (Serializable)((Object)((String)metadata.get("countryOrPrimaryLocation"))));
        this.doc.setPropertyValue("iptc:credit", (Serializable)((Object)((String)metadata.get(FIELD_CREDIT))));
        Date dateCreated = (Date)metadata.get("dateCreated");
        if (dateCreated != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(dateCreated);
            this.doc.setPropertyValue("iptc:date_created", (Serializable)calendar);
        }
        this.doc.setPropertyValue("iptc:headline", (Serializable)((Object)((String)metadata.get(FIELD_HEADLINE))));
        this.doc.setPropertyValue("iptc:keywords", (Serializable)((Object)((String)metadata.get("keywords"))));
        this.doc.setPropertyValue("iptc:language", (Serializable)((Object)((String)metadata.get(FIELD_LANGUAGE))));
        this.doc.setPropertyValue("iptc:object_name", (Serializable)((Object)((String)metadata.get("objectName"))));
        this.doc.setPropertyValue("iptc:original_transmission_ref", (Serializable)((Object)((String)metadata.get("originalTransmissionReference"))));
        this.doc.setPropertyValue("iptc:originating_program", (Serializable)((Object)((String)metadata.get("originatingProgram"))));
        this.doc.setPropertyValue("iptc:province_or_state", (Serializable)((Object)((String)metadata.get("provinceOrState"))));
        this.doc.setPropertyValue("iptc:record_version", (Serializable)((Object)((String)metadata.get("recordVersion"))));
        Date releaseDate = (Date)metadata.get("releaseDate");
        if (releaseDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(releaseDate);
            this.doc.setPropertyValue("iptc:release_date", (Serializable)calendar);
        }
        this.doc.setPropertyValue("iptc:release_time", (Serializable)((Object)((String)metadata.get("releaseTime"))));
        this.doc.setPropertyValue("iptc:source", (Serializable)((Object)((String)metadata.get(FIELD_SOURCE))));
        this.doc.setPropertyValue("iptc:special_instructions", (Serializable)((Object)((String)metadata.get("specialInstructions"))));
        this.doc.setPropertyValue("iptc:supplemental_categories", (Serializable)((Object)((String)metadata.get("supplementalCategories"))));
        this.doc.setPropertyValue("iptc:time_created", (Serializable)((Object)((String)metadata.get("timeCreated"))));
        this.doc.setPropertyValue("iptc:urgency", (Serializable)((Object)((String)metadata.get("urgency"))));
        this.doc.setPropertyValue("iptc:writer", (Serializable)((Object)((String)metadata.get("writer"))));
    }

    protected void clearViews() throws ClientException {
        ArrayList viewsList = new ArrayList();
        this.doc.getProperty(VIEWS_PROPERTY).setValue(viewsList);
    }

    protected void addViews(List<Map<String, Object>> pictureConversions, String filename, String title) throws IOException, ClientException {
        this.doc.setProperty("dublincore", "title", (Object)title);
        if (pictureConversions != null) {
            for (Map<String, Object> view : pictureConversions) {
                Integer maxsize = view.get("maxsize") == null ? Integer.valueOf(1200) : Integer.valueOf(((Long)view.get("maxsize")).intValue());
                this.createPictureimpl((String)view.get("description"), (String)view.get("tag"), (String)view.get("title"), maxsize, filename, this.width, this.height, this.depth, this.fileContent);
            }
        } else {
            List<PictureView> pictureViews = this.getImagingService().computeViewsFor(this.doc, this.fileContent, this.getImageInfo(), true);
            this.addPictureViews(pictureViews, true);
        }
    }

    public void createPictureimpl(String description, String tag, String title, Integer maxsize, String filename, Integer width, Integer height, Integer depth, Blob fileContent) throws IOException, ClientException {
        if (fileContent.getFilename() == null) {
            fileContent.setFilename(filename);
        }
        if (maxsize == null) {
            maxsize = 0;
        }
        PictureConversion pictureConversion = new PictureConversion(title, description, tag, maxsize);
        PictureView view = this.getImagingService().computeViewFor(fileContent, pictureConversion, this.getImageInfo(), true);
        this.addPictureView(view);
    }

    protected void addPictureViews(List<PictureView> pictureViews, boolean clearPictureViews) {
        if (clearPictureViews) {
            this.clearViews();
        }
        List<Map<String, Serializable>> views = this.getPictureViews();
        for (PictureView pictureView : pictureViews) {
            views.add(pictureView.asMap());
        }
        this.doc.setPropertyValue(VIEWS_PROPERTY, (Serializable)((Object)views));
    }

    @Override
    public boolean fillPictureViews(Blob blob, String filename, String title) throws IOException, ClientException {
        return this.fillPictureViews(blob, filename, title, null);
    }

    protected List<Map<String, Serializable>> getPictureViews() {
        ArrayList views = (ArrayList)this.doc.getPropertyValue(VIEWS_PROPERTY);
        if (views == null) {
            views = new ArrayList();
        }
        return views;
    }

    protected void addPictureView(PictureView view) {
        List<Map<String, Serializable>> views = this.getPictureViews();
        views.add(view.asMap());
        this.doc.setPropertyValue(VIEWS_PROPERTY, (Serializable)((Object)views));
    }

    protected ImageInfo getImageInfo() {
        if (this.imageInfo == null) {
            this.imageInfo = this.getImagingService().getImageInfo(this.fileContent);
        }
        return this.imageInfo;
    }

    @Deprecated
    protected static Point getSize(Point current, int max) {
        int newx;
        int newy;
        int x = current.x;
        int y = current.y;
        if (x > y) {
            newy = y * max / x;
            newx = max;
        } else {
            newx = x * max / y;
            newy = max;
        }
        if (newx > x || newy > y) {
            return current;
        }
        return new Point(newx, newy);
    }

    @Deprecated
    protected String computeViewFilename(String filename, String format) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return filename + "." + format;
        }
        return filename.substring(0, index + 1) + format;
    }

    protected Blob getContentFromViews(Integer i) throws ClientException {
        return (Blob)this.doc.getPropertyValue(String.format(CONTENT_XPATH, i));
    }

    protected FileBlob crop(Blob blob, Map<String, Serializable> coords) throws ClientException {
        try {
            SimpleBlobHolder bh = new SimpleBlobHolder(blob);
            String type = blob.getMimeType();
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("x", coords.get("x"));
            options.put("y", coords.get("y"));
            options.put("height", coords.get("h"));
            options.put("width", coords.get("w"));
            if (type != "image/png") {
                bh = this.getConversionService().convert("pictureCrop", (BlobHolder)bh, options);
                return new FileBlob(bh.getBlob().getStream(), type);
            }
        }
        catch (IOException e) {
            throw new ClientException("Crop failed", (Throwable)e);
        }
        return null;
    }
}

