/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;

public class DocumentModelUpdater
extends AbstractDocumentModelWriter {
    private static final Log log = LogFactory.getLog(DocumentModelUpdater.class);

    public DocumentModelUpdater(CoreSession session, String parentPath) {
        super(session, parentPath);
    }

    public DocumentModelUpdater(CoreSession session, String parentPath, int saveInterval) {
        super(session, parentPath, saveInterval);
    }

    @Override
    public DocumentTranslationMap write(ExportedDocument xdoc) throws IOException {
        if (xdoc.getDocument() == null) {
            return null;
        }
        DocumentModel doc = null;
        String id = xdoc.getId();
        try {
            doc = this.session.getDocument((DocumentRef)new IdRef(id));
        }
        catch (ClientException e) {
            log.error((Object)("Cannot update document. No such document: " + id));
            return null;
        }
        try {
            doc = this.updateDocument(xdoc, doc);
            DocumentLocation source = xdoc.getSourceLocation();
            DocumentTranslationMapImpl map = new DocumentTranslationMapImpl(source.getServerName(), doc.getRepositoryName());
            map.put(source.getDocRef(), doc.getRef());
            return map;
        }
        catch (ClientException e) {
            IOException ioe = new IOException("Failed to import document in repository: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            log.error((Object)e);
            return null;
        }
    }
}

