/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.xplain.MinimizationStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletionStrategy
implements MinimizationStrategy {
    private boolean computationCanceled;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.xplain.DeletionStrategy");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    @Override
    public void cancelExplanationComputation() {
        this.computationCanceled = true;
    }

    @Override
    public IVecInt explain(ISolver solver, Map<Integer, ?> constrs, IVecInt assumps) throws TimeoutException {
        this.computationCanceled = false;
        VecInt encodingAssumptions = new VecInt(constrs.size() + assumps.size());
        assumps.copyTo(encodingAssumptions);
        IVecInt firstExplanation = solver.unsatExplanation();
        VecInt results = new VecInt(firstExplanation.size());
        if (firstExplanation.size() == 1) {
            results.push(-firstExplanation.get(0));
            return results;
        }
        if (solver.isVerbose()) {
            System.out.print(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("initial unsat core ").toString());
            firstExplanation.sort();
            IteratorInt it = firstExplanation.iterator();
            while (it.hasNext()) {
                System.out.print(constrs.get(new Integer(-it.next())));
                System.out.print(" ");
            }
            System.out.println();
            solver.printStat(new PrintWriter(System.out, true), "c ");
        }
        int i = 0;
        while (i < firstExplanation.size()) {
            if (assumps.contains(firstExplanation.get(i))) {
                firstExplanation.delete(i);
                continue;
            }
            ++i;
        }
        Set<Integer> constraintsVariables = constrs.keySet();
        VecInt remainingVariables = new VecInt(constraintsVariables.size());
        for (Integer v : constraintsVariables) {
            remainingVariables.push(v);
        }
        IteratorInt it = firstExplanation.iterator();
        while (it.hasNext()) {
            int p = it.next();
            if (p < 0) {
                p = -p;
            }
            remainingVariables.remove(p);
        }
        remainingVariables.copyTo(encodingAssumptions);
        int unsatcorebegin = encodingAssumptions.size();
        firstExplanation.copyTo(encodingAssumptions);
        if (!$assertionsDisabled && solver.isSatisfiable(encodingAssumptions)) {
            throw new AssertionError();
        }
        int unsatcorelimit = encodingAssumptions.size() - 1;
        int i2 = unsatcorebegin;
        while (i2 < unsatcorelimit) {
            if (this.computationCanceled) {
                throw new TimeoutException();
            }
            encodingAssumptions.set(i2, -encodingAssumptions.get(i2));
            if (solver.isVerbose()) {
                System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("checking ").append(constrs.get(new Integer(encodingAssumptions.get(i2)))).append(" ...").toString());
            }
            if (solver.isSatisfiable(encodingAssumptions)) {
                encodingAssumptions.set(i2, -encodingAssumptions.get(i2));
                results.push(-encodingAssumptions.get(i2));
                if (solver.isVerbose()) {
                    System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("mandatory.").toString());
                }
            } else if (solver.isVerbose()) {
                System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("not needed.").toString());
            }
            ++i2;
        }
        if (results.size() == 0) {
            results.push(-encodingAssumptions.get(unsatcorelimit));
            if (solver.isVerbose()) {
                System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("skipping last test,the remaining element ").append(constrs.get(new Integer(encodingAssumptions.get(unsatcorelimit)))).append(" is causing the inconsistency!").toString());
            }
        } else {
            encodingAssumptions.set(unsatcorelimit, -encodingAssumptions.get(unsatcorelimit));
            if (solver.isVerbose()) {
                System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("checking ").append(constrs.get(new Integer(encodingAssumptions.get(unsatcorelimit)))).append(" ...").toString());
            }
            if (solver.isSatisfiable(encodingAssumptions)) {
                encodingAssumptions.set(unsatcorelimit, -encodingAssumptions.get(unsatcorelimit));
                results.push(-encodingAssumptions.get(unsatcorelimit));
                if (solver.isVerbose()) {
                    System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("mandatory.").toString());
                }
            } else if (solver.isVerbose()) {
                System.out.println(new StringBuffer(String.valueOf(solver.getLogPrefix())).append("not needed.").toString());
            }
        }
        return results;
    }

    public String toString() {
        return "Deletion based minimization strategy";
    }
}

