/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.web;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openjena.atlas.lib.Lib;
import org.openjena.atlas.web.WebLib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaType {
    private static Logger log = LoggerFactory.getLogger(MediaType.class);
    private String type = null;
    private String subType = null;
    private String charset = null;
    public static final String strCharset = "charset";
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private String strContentType = null;

    private MediaType() {
    }

    public MediaType(MediaType other) {
        this.type = other.type;
        this.subType = other.subType;
        this.params = new LinkedHashMap<String, String>(other.params);
    }

    public MediaType(String string) {
        this.parseOneEntry(string);
    }

    protected MediaType(String type, String subType) {
        this.type = type;
        this.subType = subType;
    }

    public static MediaType create(String contentType, String charset) {
        MediaType mediaType = new MediaType(contentType);
        mediaType.setParameter(strCharset, charset);
        return mediaType;
    }

    public static MediaType create(String contentType, String subType, String charset) {
        MediaType mediaType = new MediaType();
        mediaType.type = contentType;
        mediaType.subType = subType;
        mediaType.setParameter(strCharset, charset);
        return mediaType;
    }

    private void parseOneEntry(String s) {
        String[] x = WebLib.split(s, ";");
        this.parseAndSetType(x[0]);
        for (int i = 1; i < x.length; ++i) {
            String[] z = WebLib.split(x[i], "=");
            if (z.length == 2) {
                this.params.put(z[0], z[1]);
                continue;
            }
            log.warn("Duff parameter: " + x[i] + " in " + s);
        }
        this.strContentType = null;
    }

    private void parseAndSetType(String s) {
        String[] t = WebLib.split(s, "/");
        this.type = t[0];
        if (t.length > 1) {
            this.subType = t[1];
        }
    }

    public String toHeaderString() {
        StringBuilder b = new StringBuilder();
        b.append(this.type);
        if (this.subType != null) {
            b.append("/").append(this.subType);
        }
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            b.append(";");
            b.append(entry.getKey());
            b.append("=");
            b.append(entry.getValue());
        }
        return b.toString();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[");
        b.append(this.type);
        if (this.subType != null) {
            b.append("/").append(this.subType);
        }
        for (String k : this.params.keySet()) {
            String v = this.params.get(k);
            b.append(" ");
            b.append(k);
            b.append("=");
            b.append(v);
        }
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        return Lib.hashCodeObject(this.type, 1) ^ Lib.hashCodeObject(this.subType, 2) ^ Lib.hashCodeObject(this.params, 3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaType)) {
            return false;
        }
        MediaType mt = (MediaType)object;
        return Lib.equal(this.type, mt.type) && Lib.equal(this.subType, mt.subType) && Lib.equal(this.params, mt.params);
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public void setParameter(String name, String value) {
        this.params.put(name, value);
        this.strContentType = null;
    }

    public String getContentType() {
        if (this.strContentType != null) {
            return this.strContentType;
        }
        if (this.subType == null) {
            return this.type;
        }
        return this.type + "/" + this.subType;
    }

    public String getCharset() {
        return this.getParameter(strCharset);
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
        this.strContentType = null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.strContentType = null;
    }
}

