/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.io.IOException;
import java.util.List;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.Paginable;
import org.nuxeo.ecm.automation.core.util.RecordSet;
import org.nuxeo.ecm.automation.jaxrs.DefaultJsonAdapter;
import org.nuxeo.ecm.automation.jaxrs.JsonAdapter;
import org.nuxeo.ecm.automation.jaxrs.io.documents.MultipartBlobs;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;

public class ResponseHelper {
    private ResponseHelper() {
    }

    public static Response notFound() {
        return Response.status((int)404).build();
    }

    public static Response emptyContent() {
        return Response.status((int)204).build();
    }

    public static Response notAllowed() {
        return Response.status((int)401).build();
    }

    public static Response blob(Blob blob) {
        return ResponseHelper.blob(blob, 200);
    }

    public static Response blobs(List<Blob> blobs) throws MessagingException, IOException {
        return ResponseHelper.blobs(blobs, 200);
    }

    public static Response blob(Blob blob, int httpStatus) {
        String type = blob.getMimeType();
        if (type == null || "???".equals(type)) {
            type = "application/octet-stream";
        }
        return Response.status((int)httpStatus).entity((Object)blob).type(type).header("Content-Disposition", (Object)("attachment; filename=" + blob.getFilename())).build();
    }

    public static Response blobs(List<Blob> blobs, int httpStatus) throws MessagingException, IOException {
        MultipartBlobs multipartBlobs = new MultipartBlobs(blobs);
        return Response.status((int)httpStatus).entity((Object)multipartBlobs).type((MediaType)new BoundaryMediaType(multipartBlobs.getContentType())).build();
    }

    public static Object getResponse(Object result, HttpServletRequest request) throws MessagingException, IOException {
        return ResponseHelper.getResponse(result, request, 200);
    }

    public static Object getResponse(Object result, HttpServletRequest request, int httpStatus) throws IOException, MessagingException {
        if (result == null || "true".equals(request.getHeader("X-NXVoidOperation"))) {
            return ResponseHelper.emptyContent();
        }
        if (result instanceof Blob) {
            return ResponseHelper.blob((Blob)result);
        }
        if (result instanceof BlobList) {
            return ResponseHelper.blobs((List<Blob>)((BlobList)result));
        }
        if (result instanceof DocumentRef) {
            CoreSession session = SessionFactory.getSession((HttpServletRequest)request);
            return Response.status((int)httpStatus).entity((Object)session.getDocument((DocumentRef)result)).build();
        }
        if (result instanceof DocumentModel || result instanceof DocumentModelList || result instanceof JsonAdapter || result instanceof RecordSet || result instanceof Paginable) {
            return Response.status((int)httpStatus).entity(result).build();
        }
        return Response.status((int)httpStatus).entity((Object)new DefaultJsonAdapter(result)).build();
    }

    public static class BoundaryMediaType
    extends MediaType {
        private final String ctype;

        BoundaryMediaType(String ctype) {
            super("multipart", "mixed");
            this.ctype = ctype;
        }

        public String toString() {
            return this.ctype;
        }
    }
}

